/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.index.firestore;

import com.google.cloud.datastore.core.index.firestore.ValueToFirestoreIndexValueConverter;
import com.google.cloud.datastore.core.rep.JndexValue;
import com.google.cloud.datastore.core.rep.Value;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CachingValueToFirestoreIndexValueConverter
extends ValueToFirestoreIndexValueConverter {
    private final Map<Value, JndexValue> cache = new HashMap<Value, JndexValue>();

    public CachingValueToFirestoreIndexValueConverter(int truncationThreshold) {
        super(truncationThreshold);
    }

    @Override
    public JndexValue convertValueTruncateIfThresholdExceeded(Value value) {
        JndexValue indexValue = this.cache.get(value);
        if (indexValue != null) {
            return indexValue;
        }
        return new CachingConverter(this.truncationThreshold).convertTopLevelValue(value);
    }

    private class CachingConverter
    extends ValueToFirestoreIndexValueConverter.Converter {
        public CachingConverter(int truncationThreshold) {
            super(truncationThreshold);
        }

        public JndexValue convertTopLevelValue(Value value) {
            JndexValue indexValue = this.convertValue(value);
            if (indexValue.isDeepTruncated()) {
                CachingValueToFirestoreIndexValueConverter.this.cache.put(value, indexValue);
            }
            return indexValue;
        }

        @Override
        public JndexValue convertValue(Value value) {
            JndexValue indexValue = super.convertValue(value);
            if (!indexValue.isDeepTruncated()) {
                JndexValue cachedValue = (JndexValue)CachingValueToFirestoreIndexValueConverter.this.cache.get(value);
                if (cachedValue != null) {
                    return cachedValue;
                }
                CachingValueToFirestoreIndexValueConverter.this.cache.put(value, indexValue);
            }
            return indexValue;
        }
    }
}

