/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.index.firestore;

import com.google.apphosting.datastore.shared.Config;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.JndexValue;
import com.google.cloud.datastore.core.rep.OtherServiceResourceRef;
import com.google.cloud.datastore.core.rep.PartitionRef;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathSegment;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.converter.ValueToLegacyMapValueConverter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.math.DoubleMath;
import com.google.protobuf.ByteString;
import java.util.Arrays;
import javax.annotation.Nullable;

public class ValueToFirestoreIndexValueConverter {
    public static final ValueToFirestoreIndexValueConverter DEFAULT = new ValueToFirestoreIndexValueConverter(Config.FirestoreV1Constants.getDefaultInstance().getIndexTruncationThresholdBytes());
    protected final int truncationThreshold;

    public ValueToFirestoreIndexValueConverter(int truncationThreshold) {
        this.truncationThreshold = truncationThreshold;
    }

    public JndexValue convertPropertyPathIgnoreThreshold(PropertyPath propertyPath) {
        return this.createConverter(Integer.MAX_VALUE).convertPropertyPath(propertyPath);
    }

    public JndexValue convertStringIgnoreThreshold(String string) {
        return this.createConverter(Integer.MAX_VALUE).convertString(string);
    }

    public JndexValue convertEntityRefIgnoreThreshold(EntityRef entityRef) {
        return JndexValue.createEntityRef(this.partConvertEntityRefIgnoreThreshold(entityRef));
    }

    public JndexValue.EntityRef partConvertEntityRefIgnoreThreshold(EntityRef entityRef) {
        return this.createConverter(Integer.MAX_VALUE).partConvertEntityRef(entityRef);
    }

    public JndexValue convertValueTruncateIfThresholdExceeded(Value value) {
        return this.createConverter(this.truncationThreshold).convertValue(value);
    }

    @Nullable
    public JndexValue convertValueNullIfThresholdExceeded(Value value) {
        Converter converter = this.createConverter(this.truncationThreshold);
        JndexValue indexValue = converter.convertValue(value);
        if (converter.thresholdExceeded()) {
            return null;
        }
        return indexValue;
    }

    public JndexValue convertValueIgnoreThreshold(Value value) {
        return this.createConverter(Integer.MAX_VALUE).convertValue(value);
    }

    private Converter createConverter(int truncationThreshold) {
        return new Converter(truncationThreshold);
    }

    @VisibleForTesting(productionVisibility=VisibleForTesting.Visibility.PACKAGE_PRIVATE)
    protected static class Converter {
        private static final ValueToLegacyMapValueConverter LEGACY_CONVERTER = new ValueToLegacyMapValueConverter();
        private boolean thresholdExceeded = false;
        private int remainingSize;

        public Converter(int truncationThreshold) {
            this.remainingSize = truncationThreshold;
        }

        public boolean thresholdExceeded() {
            return this.thresholdExceeded;
        }

        @VisibleForTesting
        public int remainingSize() {
            return this.remainingSize;
        }

        public JndexValue convertPropertyPath(PropertyPath propertyPath) {
            ImmutableList.Builder elementsBuilder = ImmutableList.builder();
            while (propertyPath != null) {
                JndexValue elementIndexValue;
                PropertyPathSegment segment = propertyPath.segment();
                if (segment instanceof PropertyPathSegment.Member) {
                    PropertyPathSegment.Member memberSegment = (PropertyPathSegment.Member)segment;
                    elementIndexValue = this.convertString(memberSegment.name().string());
                } else if (segment instanceof PropertyPathSegment.Index) {
                    PropertyPathSegment.Index indexSegment = (PropertyPathSegment.Index)segment;
                    elementIndexValue = this.convertLong(indexSegment.index());
                } else if (segment instanceof PropertyPathSegment.AllArrayElements) {
                    elementIndexValue = JndexValue.NULL;
                } else {
                    throw new IllegalArgumentException("Unknown property path segment type.");
                }
                elementsBuilder.add(elementIndexValue);
                propertyPath = propertyPath.next();
            }
            return JndexValue.createArray(false, (ImmutableList<JndexValue>)elementsBuilder.build());
        }

        public JndexValue convertValue(Value value) {
            value = LEGACY_CONVERTER.shallowConvertValue(value);
            switch (value.type()) {
                case NULL: {
                    --this.remainingSize;
                    return JndexValue.NULL;
                }
                case BOOLEAN: {
                    --this.remainingSize;
                    return JndexValue.createBoolean(value.asBoolean());
                }
                case LONG: {
                    return this.convertLong(value.asLong());
                }
                case DOUBLE: {
                    return this.convertDouble(value.asDouble());
                }
                case TIMESTAMP: {
                    this.remainingSize -= 8;
                    return JndexValue.createTimestamp(value.asTimestamp());
                }
                case STRING: {
                    return this.convertString(value.asString());
                }
                case BYTES: {
                    return this.convertBytes(value.asBytes());
                }
                case ENTITY_REF: {
                    return JndexValue.createEntityRef(this.partConvertEntityRef(value.asEntityRef()));
                }
                case GEO_POINT: {
                    this.remainingSize -= 16;
                    return JndexValue.createGeoPoint(value.asGeoPoint());
                }
                case ARRAY: {
                    return this.convertArray(value.asArray());
                }
                case MAP: {
                    return this.convertMap(value.asMap());
                }
                case RESOURCE_REF: {
                    if (!value.asResourceRef().equals(OtherServiceResourceRef.EMPTY)) break;
                    return JndexValue.createEntityRef(JndexValue.EntityRef.EMPTY);
                }
            }
            String string = String.valueOf((Object)value.type());
            Preconditions.checkArgument(false, new StringBuilder(23 + String.valueOf(string).length()).append("Unsupported Value type ").append(string).toString());
            return JndexValue.NULL;
        }

        private JndexValue convertLong(long num) {
            this.remainingSize -= 8;
            return JndexValue.createNumberLong(num);
        }

        private JndexValue convertDouble(double num) {
            this.remainingSize -= 8;
            if (num >= -9.223372036854776E18 && num < 9.223372036854776E18 && DoubleMath.isMathematicalInteger(num)) {
                return JndexValue.createNumberLong((long)num);
            }
            return JndexValue.createNumberDouble(num);
        }

        private JndexValue convertStringWithoutTruncation(String string) {
            int rememberRemainingSize = this.remainingSize;
            this.remainingSize = Integer.MAX_VALUE;
            JndexValue result = this.convertString(string);
            this.remainingSize = rememberRemainingSize;
            return result;
        }

        public JndexValue convertString(String string) {
            boolean truncated;
            int index;
            --this.remainingSize;
            int stringLength = string.length();
            for (index = 0; index < stringLength && this.remainingSize > 0; ++index) {
                char c = string.charAt(index);
                if (c <= '\u007f') {
                    --this.remainingSize;
                    continue;
                }
                if (c <= '\u07ff') {
                    this.remainingSize -= 2;
                    continue;
                }
                if (!Character.isHighSurrogate(c)) {
                    this.remainingSize -= 3;
                    continue;
                }
                this.remainingSize -= 4;
                ++index;
            }
            boolean bl = truncated = index != stringLength;
            if (truncated) {
                string = string.substring(0, index);
                this.thresholdExceeded = true;
            }
            return JndexValue.createString(truncated, string);
        }

        private JndexValue convertBytes(ByteString bytes) {
            boolean truncated;
            int numBytes = bytes.size();
            boolean bl = truncated = numBytes > this.remainingSize;
            if (truncated) {
                bytes = bytes.substring(0, this.remainingSize);
                this.remainingSize = 0;
                this.thresholdExceeded = true;
            } else {
                this.remainingSize -= numBytes;
            }
            return JndexValue.createBytes(truncated, bytes);
        }

        /*
         * Enabled aggressive block sorting
         */
        public JndexValue.EntityRef partConvertEntityRef(EntityRef entityRef) {
            PartitionRef partitionRef = entityRef.partitionRef();
            DatabaseRef databaseRef = partitionRef.databaseRef();
            String namespaceId = partitionRef.namespace();
            this.remainingSize -= 16;
            JndexValue projectIdIndexValue = this.convertStringWithoutTruncation(databaseRef.projectId());
            JndexValue databaseIdIndexValue = this.convertStringWithoutTruncation(databaseRef.databaseId());
            JndexValue namespaceIdIndexValue = JndexValue.ABSENT;
            JndexValue segmentsIndexValue = JndexValue.ABSENT;
            if (this.remainingSize <= 0) {
                this.thresholdExceeded = true;
                return new JndexValue.EntityRef(projectIdIndexValue, databaseIdIndexValue, namespaceIdIndexValue, segmentsIndexValue);
            }
            if (namespaceId.isEmpty()) {
                namespaceIdIndexValue = JndexValue.EMPTY_STRING;
            } else {
                namespaceIdIndexValue = this.convertString(namespaceId);
                if (this.remainingSize <= 0) {
                    this.thresholdExceeded = true;
                    return new JndexValue.EntityRef(projectIdIndexValue, databaseIdIndexValue, namespaceIdIndexValue, segmentsIndexValue);
                }
            }
            ImmutableList<EntityRef.PathElement> entityRefPathElements = entityRef.pathElements();
            if (entityRefPathElements.isEmpty()) {
                segmentsIndexValue = JndexValue.EMPTY_ARRAY;
                return new JndexValue.EntityRef(projectIdIndexValue, databaseIdIndexValue, namespaceIdIndexValue, segmentsIndexValue);
            }
            ImmutableList.Builder segmentsBuilder = ImmutableList.builder();
            boolean truncated = false;
            for (EntityRef.PathElement pathElement : entityRef.pathElements()) {
                JndexValue resourceIdIndexValue;
                if (this.remainingSize <= 0) {
                    truncated = true;
                    this.thresholdExceeded = true;
                    break;
                }
                String collectionId = pathElement.collectionId();
                JndexValue collectionIdIndexValue = this.convertString(collectionId);
                segmentsBuilder.add(collectionIdIndexValue);
                if (this.remainingSize <= 0) {
                    if (this.thresholdExceeded) break;
                    truncated = true;
                    this.thresholdExceeded = true;
                    break;
                }
                EntityRef.ResourceId resourceId = pathElement.resourceId();
                if (resourceId == null) break;
                if (resourceId.isLong()) {
                    resourceIdIndexValue = this.convertLong(resourceId.asLong());
                } else {
                    if (!resourceId.isString()) throw new IllegalStateException();
                    resourceIdIndexValue = this.convertString(resourceId.asString());
                }
                segmentsBuilder.add(resourceIdIndexValue);
                if (!this.thresholdExceeded) continue;
            }
            segmentsIndexValue = JndexValue.createArray(truncated, (ImmutableList<JndexValue>)segmentsBuilder.build());
            return new JndexValue.EntityRef(projectIdIndexValue, databaseIdIndexValue, namespaceIdIndexValue, segmentsIndexValue);
        }

        private JndexValue convertArray(ImmutableList<Value> array) {
            ImmutableList.Builder elementsBuilder = ImmutableList.builder();
            boolean truncated = false;
            for (Value elementValue : array) {
                if (this.remainingSize <= 0) {
                    truncated = true;
                    this.thresholdExceeded = true;
                    break;
                }
                JndexValue elementIndexValue = this.convertValue(elementValue);
                elementsBuilder.add(elementIndexValue);
                if (!this.thresholdExceeded) continue;
                break;
            }
            return JndexValue.createArray(truncated, (ImmutableList<JndexValue>)elementsBuilder.build());
        }

        private JndexValue convertMap(ImmutableMap<String, Value> map) {
            ImmutableMap.Builder<JndexValue, JndexValue> entriesBuilder = ImmutableMap.builder();
            boolean truncated = false;
            for (String key : this.mapKeySetInOrder(map)) {
                JndexValue valueIndexValue;
                Value value = map.get(key);
                if (this.remainingSize <= 0) {
                    truncated = true;
                    this.thresholdExceeded = true;
                    break;
                }
                JndexValue keyIndexValue = this.convertString(key);
                if (this.remainingSize <= 0) {
                    valueIndexValue = JndexValue.ABSENT;
                    if (!this.thresholdExceeded) {
                        this.thresholdExceeded = true;
                    }
                } else {
                    valueIndexValue = this.convertValue(value);
                }
                entriesBuilder.put(keyIndexValue, valueIndexValue);
                if (this.thresholdExceeded) break;
            }
            return JndexValue.createMap(truncated, entriesBuilder.build());
        }

        private String[] mapKeySetInOrder(ImmutableMap<String, Value> map) {
            Object[] keys = new String[map.size()];
            ((ImmutableCollection)((Object)map.keySet())).toArray(keys);
            Arrays.sort(keys);
            return keys;
        }
    }
}

