/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.rep.Condition;
import com.google.cloud.datastore.core.rep.Cursor;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathWithDirection;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.core.rep.QueryScope;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;

final class AutoValue_Query
extends Query {
    private final QueryScope scope;
    private final Query.Semantics semantics;
    private final String kind;
    private final EntityRef ancestor;
    private final boolean isShallow;
    private final Condition condition;
    private final ImmutableList<PropertyPathWithDirection> orderBy;
    private final ImmutableList<PropertyPath> groupBy;
    private final ImmutableList<PropertyPath> projection;
    private final boolean selectOnlyKeys;
    private final boolean allowDuplicateResults;
    private final Cursor startCursor;
    private final Cursor endCursor;
    private final int offset;
    private final Integer limit;
    private final PropertyMask propertyMask;
    private final Cursor resumeCursor;

    private AutoValue_Query(QueryScope scope, Query.Semantics semantics, @Nullable String kind, @Nullable EntityRef ancestor, boolean isShallow, @Nullable Condition condition, ImmutableList<PropertyPathWithDirection> orderBy, ImmutableList<PropertyPath> groupBy, ImmutableList<PropertyPath> projection, boolean selectOnlyKeys, boolean allowDuplicateResults, @Nullable Cursor startCursor, @Nullable Cursor endCursor, int offset, @Nullable Integer limit, PropertyMask propertyMask, @Nullable Cursor resumeCursor) {
        this.scope = scope;
        this.semantics = semantics;
        this.kind = kind;
        this.ancestor = ancestor;
        this.isShallow = isShallow;
        this.condition = condition;
        this.orderBy = orderBy;
        this.groupBy = groupBy;
        this.projection = projection;
        this.selectOnlyKeys = selectOnlyKeys;
        this.allowDuplicateResults = allowDuplicateResults;
        this.startCursor = startCursor;
        this.endCursor = endCursor;
        this.offset = offset;
        this.limit = limit;
        this.propertyMask = propertyMask;
        this.resumeCursor = resumeCursor;
    }

    @Override
    public QueryScope scope() {
        return this.scope;
    }

    @Override
    public Query.Semantics semantics() {
        return this.semantics;
    }

    @Override
    @Nullable
    public String kind() {
        return this.kind;
    }

    @Override
    @Nullable
    public EntityRef ancestor() {
        return this.ancestor;
    }

    @Override
    public boolean isShallow() {
        return this.isShallow;
    }

    @Override
    @Nullable
    public Condition condition() {
        return this.condition;
    }

    @Override
    public ImmutableList<PropertyPathWithDirection> orderBy() {
        return this.orderBy;
    }

    @Override
    public ImmutableList<PropertyPath> groupBy() {
        return this.groupBy;
    }

    @Override
    public ImmutableList<PropertyPath> projection() {
        return this.projection;
    }

    @Override
    public boolean selectOnlyKeys() {
        return this.selectOnlyKeys;
    }

    @Override
    public boolean allowDuplicateResults() {
        return this.allowDuplicateResults;
    }

    @Override
    @Nullable
    public Cursor startCursor() {
        return this.startCursor;
    }

    @Override
    @Nullable
    public Cursor endCursor() {
        return this.endCursor;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    @Nullable
    public Integer limit() {
        return this.limit;
    }

    @Override
    public PropertyMask propertyMask() {
        return this.propertyMask;
    }

    @Override
    @Nullable
    public Cursor resumeCursor() {
        return this.resumeCursor;
    }

    public String toString() {
        String string = String.valueOf(this.scope);
        String string2 = String.valueOf((Object)this.semantics);
        String string3 = this.kind;
        String string4 = String.valueOf(this.ancestor);
        boolean bl = this.isShallow;
        String string5 = String.valueOf(this.condition);
        String string6 = String.valueOf(this.orderBy);
        String string7 = String.valueOf(this.groupBy);
        String string8 = String.valueOf(this.projection);
        boolean bl2 = this.selectOnlyKeys;
        boolean bl3 = this.allowDuplicateResults;
        String string9 = String.valueOf(this.startCursor);
        String string10 = String.valueOf(this.endCursor);
        int n = this.offset;
        String string11 = String.valueOf(this.limit);
        String string12 = String.valueOf(this.propertyMask);
        String string13 = String.valueOf(this.resumeCursor);
        return new StringBuilder(240 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length() + String.valueOf(string6).length() + String.valueOf(string7).length() + String.valueOf(string8).length() + String.valueOf(string9).length() + String.valueOf(string10).length() + String.valueOf(string11).length() + String.valueOf(string12).length() + String.valueOf(string13).length()).append("Query{scope=").append(string).append(", semantics=").append(string2).append(", kind=").append(string3).append(", ancestor=").append(string4).append(", isShallow=").append(bl).append(", condition=").append(string5).append(", orderBy=").append(string6).append(", groupBy=").append(string7).append(", projection=").append(string8).append(", selectOnlyKeys=").append(bl2).append(", allowDuplicateResults=").append(bl3).append(", startCursor=").append(string9).append(", endCursor=").append(string10).append(", offset=").append(n).append(", limit=").append(string11).append(", propertyMask=").append(string12).append(", resumeCursor=").append(string13).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Query) {
            Query that = (Query)o;
            return this.scope.equals(that.scope()) && this.semantics.equals((Object)that.semantics()) && (this.kind == null ? that.kind() == null : this.kind.equals(that.kind())) && (this.ancestor == null ? that.ancestor() == null : this.ancestor.equals(that.ancestor())) && this.isShallow == that.isShallow() && (this.condition == null ? that.condition() == null : this.condition.equals(that.condition())) && this.orderBy.equals(that.orderBy()) && this.groupBy.equals(that.groupBy()) && this.projection.equals(that.projection()) && this.selectOnlyKeys == that.selectOnlyKeys() && this.allowDuplicateResults == that.allowDuplicateResults() && (this.startCursor == null ? that.startCursor() == null : this.startCursor.equals(that.startCursor())) && (this.endCursor == null ? that.endCursor() == null : this.endCursor.equals(that.endCursor())) && this.offset == that.offset() && (this.limit == null ? that.limit() == null : this.limit.equals(that.limit())) && this.propertyMask.equals(that.propertyMask()) && (this.resumeCursor == null ? that.resumeCursor() == null : this.resumeCursor.equals(that.resumeCursor()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.scope.hashCode();
        h$ *= 1000003;
        h$ ^= this.semantics.hashCode();
        h$ *= 1000003;
        h$ ^= this.kind == null ? 0 : this.kind.hashCode();
        h$ *= 1000003;
        h$ ^= this.ancestor == null ? 0 : this.ancestor.hashCode();
        h$ *= 1000003;
        h$ ^= this.isShallow ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.condition == null ? 0 : this.condition.hashCode();
        h$ *= 1000003;
        h$ ^= this.orderBy.hashCode();
        h$ *= 1000003;
        h$ ^= this.groupBy.hashCode();
        h$ *= 1000003;
        h$ ^= this.projection.hashCode();
        h$ *= 1000003;
        h$ ^= this.selectOnlyKeys ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.allowDuplicateResults ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.startCursor == null ? 0 : this.startCursor.hashCode();
        h$ *= 1000003;
        h$ ^= this.endCursor == null ? 0 : this.endCursor.hashCode();
        h$ *= 1000003;
        h$ ^= this.offset;
        h$ *= 1000003;
        h$ ^= this.limit == null ? 0 : this.limit.hashCode();
        h$ *= 1000003;
        h$ ^= this.propertyMask.hashCode();
        h$ *= 1000003;
        return h$ ^= this.resumeCursor == null ? 0 : this.resumeCursor.hashCode();
    }

    @Override
    public Query.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends Query.Builder {
        private QueryScope.Builder scopeBuilder$;
        private QueryScope scope;
        private Query.Semantics semantics;
        private String kind;
        private EntityRef ancestor;
        private Boolean isShallow;
        private Condition condition;
        private ImmutableList<PropertyPathWithDirection> orderBy;
        private ImmutableList<PropertyPath> groupBy;
        private ImmutableList<PropertyPath> projection;
        private Boolean selectOnlyKeys;
        private Boolean allowDuplicateResults;
        private Cursor startCursor;
        private Cursor endCursor;
        private Integer offset;
        private Integer limit;
        private PropertyMask propertyMask;
        private Cursor resumeCursor;

        Builder() {
        }

        private Builder(Query source) {
            this.scope = source.scope();
            this.semantics = source.semantics();
            this.kind = source.kind();
            this.ancestor = source.ancestor();
            this.isShallow = source.isShallow();
            this.condition = source.condition();
            this.orderBy = source.orderBy();
            this.groupBy = source.groupBy();
            this.projection = source.projection();
            this.selectOnlyKeys = source.selectOnlyKeys();
            this.allowDuplicateResults = source.allowDuplicateResults();
            this.startCursor = source.startCursor();
            this.endCursor = source.endCursor();
            this.offset = source.offset();
            this.limit = source.limit();
            this.propertyMask = source.propertyMask();
            this.resumeCursor = source.resumeCursor();
        }

        @Override
        public Query.Builder scope(QueryScope scope) {
            if (scope == null) {
                throw new NullPointerException("Null scope");
            }
            if (this.scopeBuilder$ != null) {
                throw new IllegalStateException("Cannot set scope after calling scopeBuilder()");
            }
            this.scope = scope;
            return this;
        }

        @Override
        public QueryScope.Builder scopeBuilder() {
            if (this.scopeBuilder$ == null) {
                if (this.scope == null) {
                    this.scopeBuilder$ = QueryScope.builder();
                } else {
                    this.scopeBuilder$ = this.scope.toBuilder();
                    this.scope = null;
                }
            }
            return this.scopeBuilder$;
        }

        @Override
        public Query.Builder semantics(Query.Semantics semantics) {
            if (semantics == null) {
                throw new NullPointerException("Null semantics");
            }
            this.semantics = semantics;
            return this;
        }

        @Override
        public Query.Builder kind(@Nullable String kind) {
            this.kind = kind;
            return this;
        }

        @Override
        public Query.Builder ancestor(@Nullable EntityRef ancestor) {
            this.ancestor = ancestor;
            return this;
        }

        @Override
        public Query.Builder isShallow(boolean isShallow) {
            this.isShallow = isShallow;
            return this;
        }

        @Override
        public Query.Builder condition(@Nullable Condition condition) {
            this.condition = condition;
            return this;
        }

        @Override
        @Nullable
        protected Condition condition() {
            return this.condition;
        }

        @Override
        public Query.Builder orderBy(ImmutableList<PropertyPathWithDirection> orderBy) {
            if (orderBy == null) {
                throw new NullPointerException("Null orderBy");
            }
            this.orderBy = orderBy;
            return this;
        }

        @Override
        public Query.Builder groupBy(ImmutableList<PropertyPath> groupBy) {
            if (groupBy == null) {
                throw new NullPointerException("Null groupBy");
            }
            this.groupBy = groupBy;
            return this;
        }

        @Override
        public Query.Builder projection(ImmutableList<PropertyPath> projection) {
            if (projection == null) {
                throw new NullPointerException("Null projection");
            }
            this.projection = projection;
            return this;
        }

        @Override
        public Query.Builder selectOnlyKeys(boolean selectOnlyKeys) {
            this.selectOnlyKeys = selectOnlyKeys;
            return this;
        }

        @Override
        public Query.Builder allowDuplicateResults(boolean allowDuplicateResults) {
            this.allowDuplicateResults = allowDuplicateResults;
            return this;
        }

        @Override
        public Query.Builder startCursor(@Nullable Cursor startCursor) {
            this.startCursor = startCursor;
            return this;
        }

        @Override
        public Query.Builder endCursor(Cursor endCursor) {
            this.endCursor = endCursor;
            return this;
        }

        @Override
        public Query.Builder offset(int offset) {
            this.offset = offset;
            return this;
        }

        @Override
        public Query.Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Query.Builder propertyMask(PropertyMask propertyMask) {
            if (propertyMask == null) {
                throw new NullPointerException("Null propertyMask");
            }
            this.propertyMask = propertyMask;
            return this;
        }

        @Override
        public Query.Builder resumeCursor(Cursor resumeCursor) {
            this.resumeCursor = resumeCursor;
            return this;
        }

        @Override
        public Query build() {
            if (this.scopeBuilder$ != null) {
                this.scope = this.scopeBuilder$.build();
            } else if (this.scope == null) {
                QueryScope.Builder scope$builder = QueryScope.builder();
                this.scope = scope$builder.build();
            }
            String missing = "";
            if (this.semantics == null) {
                missing = String.valueOf(missing).concat(" semantics");
            }
            if (this.isShallow == null) {
                missing = String.valueOf(missing).concat(" isShallow");
            }
            if (this.orderBy == null) {
                missing = String.valueOf(missing).concat(" orderBy");
            }
            if (this.groupBy == null) {
                missing = String.valueOf(missing).concat(" groupBy");
            }
            if (this.projection == null) {
                missing = String.valueOf(missing).concat(" projection");
            }
            if (this.selectOnlyKeys == null) {
                missing = String.valueOf(missing).concat(" selectOnlyKeys");
            }
            if (this.allowDuplicateResults == null) {
                missing = String.valueOf(missing).concat(" allowDuplicateResults");
            }
            if (this.offset == null) {
                missing = String.valueOf(missing).concat(" offset");
            }
            if (this.propertyMask == null) {
                missing = String.valueOf(missing).concat(" propertyMask");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_Query(this.scope, this.semantics, this.kind, this.ancestor, this.isShallow, this.condition, this.orderBy, this.groupBy, this.projection, this.selectOnlyKeys, this.allowDuplicateResults, this.startCursor, this.endCursor, this.offset, this.limit, this.propertyMask, this.resumeCursor);
        }
    }
}

