/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.rep.Cursor;
import com.google.cloud.datastore.core.rep.ReadResult;
import com.google.storage.onestore.v3.OnestoreEntity;
import javax.annotation.Nullable;

final class AutoValue_ReadResult
extends ReadResult {
    private final OnestoreEntity.Reference reference;
    private final OnestoreEntity.EntityProto entity;
    private final ReadResult.MissingEntityReason missingEntityReason;
    private final long createVersion;
    private final long updateVersion;
    private final Long readTimestamp;
    private final Cursor cursor;

    private AutoValue_ReadResult(@Nullable OnestoreEntity.Reference reference, @Nullable OnestoreEntity.EntityProto entity, @Nullable ReadResult.MissingEntityReason missingEntityReason, long createVersion, long updateVersion, @Nullable Long readTimestamp, @Nullable Cursor cursor) {
        this.reference = reference;
        this.entity = entity;
        this.missingEntityReason = missingEntityReason;
        this.createVersion = createVersion;
        this.updateVersion = updateVersion;
        this.readTimestamp = readTimestamp;
        this.cursor = cursor;
    }

    @Override
    @Nullable
    public OnestoreEntity.Reference reference() {
        return this.reference;
    }

    @Override
    @Nullable
    public OnestoreEntity.EntityProto entity() {
        return this.entity;
    }

    @Override
    @Nullable
    public ReadResult.MissingEntityReason missingEntityReason() {
        return this.missingEntityReason;
    }

    @Override
    public long createVersion() {
        return this.createVersion;
    }

    @Override
    public long updateVersion() {
        return this.updateVersion;
    }

    @Override
    @Nullable
    public Long readTimestamp() {
        return this.readTimestamp;
    }

    @Override
    @Nullable
    public Cursor cursor() {
        return this.cursor;
    }

    public String toString() {
        String string = String.valueOf(this.reference);
        String string2 = String.valueOf(this.entity);
        String string3 = String.valueOf((Object)this.missingEntityReason);
        long l = this.createVersion;
        long l2 = this.updateVersion;
        String string4 = String.valueOf(this.readTimestamp);
        String string5 = String.valueOf(this.cursor);
        return new StringBuilder(150 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append("ReadResult{reference=").append(string).append(", entity=").append(string2).append(", missingEntityReason=").append(string3).append(", createVersion=").append(l).append(", updateVersion=").append(l2).append(", readTimestamp=").append(string4).append(", cursor=").append(string5).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ReadResult) {
            ReadResult that = (ReadResult)o;
            return (this.reference == null ? that.reference() == null : this.reference.equals(that.reference())) && (this.entity == null ? that.entity() == null : this.entity.equals(that.entity())) && (this.missingEntityReason == null ? that.missingEntityReason() == null : this.missingEntityReason.equals((Object)that.missingEntityReason())) && this.createVersion == that.createVersion() && this.updateVersion == that.updateVersion() && (this.readTimestamp == null ? that.readTimestamp() == null : this.readTimestamp.equals(that.readTimestamp())) && (this.cursor == null ? that.cursor() == null : this.cursor.equals(that.cursor()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.reference == null ? 0 : this.reference.hashCode();
        h$ *= 1000003;
        h$ ^= this.entity == null ? 0 : this.entity.hashCode();
        h$ *= 1000003;
        h$ ^= this.missingEntityReason == null ? 0 : this.missingEntityReason.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.createVersion >>> 32 ^ this.createVersion);
        h$ *= 1000003;
        h$ ^= (int)(this.updateVersion >>> 32 ^ this.updateVersion);
        h$ *= 1000003;
        h$ ^= this.readTimestamp == null ? 0 : this.readTimestamp.hashCode();
        h$ *= 1000003;
        return h$ ^= this.cursor == null ? 0 : this.cursor.hashCode();
    }

    @Override
    ReadResult.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends ReadResult.Builder {
        private OnestoreEntity.Reference reference;
        private OnestoreEntity.EntityProto entity;
        private ReadResult.MissingEntityReason missingEntityReason;
        private Long createVersion;
        private Long updateVersion;
        private Long readTimestamp;
        private Cursor cursor;

        Builder() {
        }

        private Builder(ReadResult source) {
            this.reference = source.reference();
            this.entity = source.entity();
            this.missingEntityReason = source.missingEntityReason();
            this.createVersion = source.createVersion();
            this.updateVersion = source.updateVersion();
            this.readTimestamp = source.readTimestamp();
            this.cursor = source.cursor();
        }

        @Override
        public ReadResult.Builder reference(@Nullable OnestoreEntity.Reference reference) {
            this.reference = reference;
            return this;
        }

        @Override
        public ReadResult.Builder entity(@Nullable OnestoreEntity.EntityProto entity) {
            this.entity = entity;
            return this;
        }

        @Override
        public ReadResult.Builder missingEntityReason(@Nullable ReadResult.MissingEntityReason missingEntityReason) {
            this.missingEntityReason = missingEntityReason;
            return this;
        }

        @Override
        public ReadResult.Builder createVersion(long createVersion) {
            this.createVersion = createVersion;
            return this;
        }

        @Override
        public ReadResult.Builder updateVersion(long updateVersion) {
            this.updateVersion = updateVersion;
            return this;
        }

        @Override
        public ReadResult.Builder readTimestamp(@Nullable Long readTimestamp) {
            this.readTimestamp = readTimestamp;
            return this;
        }

        @Override
        public ReadResult.Builder cursor(@Nullable Cursor cursor) {
            this.cursor = cursor;
            return this;
        }

        @Override
        public ReadResult build() {
            String missing = "";
            if (this.createVersion == null) {
                missing = String.valueOf(missing).concat(" createVersion");
            }
            if (this.updateVersion == null) {
                missing = String.valueOf(missing).concat(" updateVersion");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_ReadResult(this.reference, this.entity, this.missingEntityReason, this.createVersion, this.updateVersion, this.readTimestamp, this.cursor);
        }
    }
}

