/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.rep.JndexValue;
import com.google.cloud.datastore.core.rep.Value;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.ByteString;
import com.google.type.LatLng;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;

public abstract class BaseJndexValueComparator
implements Comparator<JndexValue> {
    protected static final Comparator<ByteString> BYTE_STRING_COMPARATOR = ByteString.unsignedLexicographicalComparator();

    protected int compareEntityRefWithoutTruncated(JndexValue.EntityRef left, JndexValue.EntityRef right) {
        int comparison = this.compare(left.projectId, right.projectId);
        if (comparison != 0) {
            return comparison;
        }
        comparison = this.compare(left.databaseId, right.databaseId);
        if (comparison != 0) {
            return comparison;
        }
        comparison = this.compare(left.namespaceId, right.namespaceId);
        if (comparison != 0) {
            return comparison;
        }
        if (left.segments == JndexValue.ABSENT && right.segments.equals(JndexValue.EMPTY_ARRAY)) {
            return 1;
        }
        if (right.segments == JndexValue.ABSENT && left.segments.equals(JndexValue.EMPTY_ARRAY)) {
            return -1;
        }
        return this.compare(left.segments, right.segments);
    }

    protected int compareGeoPoint(LatLng left, LatLng right) {
        int latComparison = Double.compare(left.getLatitude(), right.getLatitude());
        if (latComparison != 0) {
            return latComparison;
        }
        return Double.compare(left.getLongitude(), right.getLongitude());
    }

    protected int compareArrayWithoutTruncated(ImmutableList<JndexValue> left, ImmutableList<JndexValue> right) {
        int leftSize = left.size();
        int rightSize = right.size();
        int minSize = Math.min(leftSize, rightSize);
        for (int index = 0; index < minSize; ++index) {
            int elementComparison = this.compare((JndexValue)left.get(index), (JndexValue)right.get(index));
            if (elementComparison == 0) continue;
            return elementComparison;
        }
        return Integer.compare(leftSize, rightSize);
    }

    protected int compareMapWithoutTruncated(ImmutableMap<JndexValue, JndexValue> left, ImmutableMap<JndexValue, JndexValue> right) {
        boolean rightHasNext;
        block2: {
            block3: {
                Map.Entry rightEntry;
                JndexValue rightValue;
                Map.Entry leftEntry;
                JndexValue leftValue;
                int valueComparison;
                Iterator leftIterator = ((ImmutableSet)left.entrySet()).iterator();
                Iterator rightIterator = ((ImmutableSet)right.entrySet()).iterator();
                do {
                    JndexValue rightKey;
                    boolean leftHasNext = leftIterator.hasNext();
                    rightHasNext = rightIterator.hasNext();
                    if (!leftHasNext) break block2;
                    if (!rightHasNext) break block3;
                    leftEntry = (Map.Entry)leftIterator.next();
                    rightEntry = (Map.Entry)rightIterator.next();
                    JndexValue leftKey = (JndexValue)leftEntry.getKey();
                    int keyComparison = this.compare(leftKey, rightKey = (JndexValue)rightEntry.getKey());
                    if (keyComparison == 0) continue;
                    return keyComparison;
                } while ((valueComparison = this.compare(leftValue = (JndexValue)leftEntry.getValue(), rightValue = (JndexValue)rightEntry.getValue())) == 0);
                return valueComparison;
            }
            return 1;
        }
        if (rightHasNext) {
            return -1;
        }
        return 0;
    }

    protected int compareLegacyUserWithoutTruncation(Value.LegacyUser left, Value.LegacyUser right) {
        int comparison = left.email().compareTo(right.email());
        if (comparison != 0) {
            return comparison;
        }
        comparison = left.authDomain().compareTo(right.authDomain());
        if (comparison != 0) {
            return comparison;
        }
        comparison = Long.compare(left.gaiaId(), right.gaiaId());
        if (comparison != 0) {
            return comparison;
        }
        comparison = left.obfuscatedGaiaId().compareTo(right.obfuscatedGaiaId());
        if (comparison != 0) {
            return comparison;
        }
        comparison = left.federatedIdentity().compareTo(right.federatedIdentity());
        if (comparison != 0) {
            return comparison;
        }
        comparison = left.federatedProvider().compareTo(right.federatedProvider());
        return comparison;
    }
}

