/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_Cursor;
import com.google.cloud.datastore.core.rep.Direction;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.UnifiedIndexValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;

@AutoValue
public abstract class Cursor {
    public static final Cursor EMPTY = new AutoValue_Cursor(Category.EMPTY, null, null, ImmutableList.of(), ImmutableList.of(), false, false);
    public static final Cursor RAW_INDEX_KEY_FIRST = new AutoValue_Cursor(Category.RAW_INDEX, null, null, ImmutableList.of(), ImmutableList.of(), false, false);

    public static Cursor create(EntityRef key, @Nullable ImmutableList<PropertyPath> propertyPaths, ImmutableList<UnifiedIndexValue> indexValues) {
        return Cursor.create(Preconditions.checkNotNull(key), propertyPaths, indexValues, false, Direction.ASCENDING);
    }

    public static Cursor create(@Nullable EntityRef key, @Nullable ImmutableList<PropertyPath> propertyPaths, ImmutableList<UnifiedIndexValue> indexValues, boolean before, @Nullable Direction firstOrderByDirection) {
        return Cursor.create(key, propertyPaths, indexValues, before, Cursor.convertBeforeAndFirstOrderByDirectionToBeforeAscending(before, firstOrderByDirection));
    }

    public static Cursor create(@Nullable EntityRef key, @Nullable ImmutableList<PropertyPath> propertyPaths, ImmutableList<UnifiedIndexValue> indexValues, boolean before, boolean beforeAscending) {
        return new AutoValue_Cursor(Category.REGULAR, null, key, indexValues, propertyPaths, before, beforeAscending);
    }

    public static Cursor createRawIndex(byte[] rawIndexKey, boolean before, @Nullable Direction firstOrderByDirection) {
        return Cursor.createRawIndex(rawIndexKey, before, Cursor.convertBeforeAndFirstOrderByDirectionToBeforeAscending(before, firstOrderByDirection));
    }

    public static Cursor createRawIndex(byte[] rawIndexKey, boolean before, boolean beforeAscending) {
        Preconditions.checkNotNull(rawIndexKey);
        return new AutoValue_Cursor(Category.RAW_INDEX, rawIndexKey, null, ImmutableList.of(), ImmutableList.of(), before, beforeAscending);
    }

    private static boolean convertBeforeAndFirstOrderByDirectionToBeforeAscending(boolean before, @Nullable Direction firstOrderByDirection) {
        return before ^ firstOrderByDirection == Direction.DESCENDING;
    }

    protected abstract Category category();

    @Nullable
    public abstract byte[] rawIndexKey();

    @Nullable
    public abstract EntityRef key();

    public abstract ImmutableList<UnifiedIndexValue> indexValues();

    @Nullable
    public abstract ImmutableList<PropertyPath> propertyPaths();

    public abstract boolean before();

    public abstract boolean beforeAscending();

    public boolean isRawIndex() {
        return this.category() == Category.RAW_INDEX;
    }

    public boolean isRegular() {
        return this.category() == Category.REGULAR;
    }

    protected static enum Category {
        EMPTY,
        RAW_INDEX,
        REGULAR;

    }
}

