/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.names.Names;
import com.google.cloud.datastore.core.rep.AutoValue_DatabaseIndexGroup;
import com.google.cloud.datastore.core.rep.DatastoreBuiltinIndex;
import com.google.cloud.datastore.core.rep.Index;
import com.google.cloud.datastore.core.rep.KindIndexGroup;
import com.google.cloud.datastore.core.rep.SingleFieldIndexingConfiguration;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.WorkflowState;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@AutoValue
public abstract class DatabaseIndexGroup {
    public static Value.DatastoreIndexing defaultDatastoreIndexing = Value.DatastoreIndexing.EXCLUDE;
    public static final DatabaseIndexGroup NO_INDEXES = DatabaseIndexGroup.create(ImmutableList.of(), ImmutableList.of(), SingleFieldIndexingConfiguration.EMPTY);
    public static final DatabaseIndexGroup METADATA_INDEXES = DatabaseIndexGroup.create(ImmutableList.of(), ImmutableList.of(DatastoreBuiltinIndex.create(DatastoreBuiltinIndex.Mode.KIND, WorkflowState.SERVING), DatastoreBuiltinIndex.create(DatastoreBuiltinIndex.Mode.ASC, WorkflowState.SERVING), DatastoreBuiltinIndex.create(DatastoreBuiltinIndex.Mode.DESC, WorkflowState.SERVING)), SingleFieldIndexingConfiguration.EMPTY);

    public KindIndexGroup kindlessIndexGroup() {
        return KindIndexGroup.EMPTY;
    }

    public KindIndexGroup kindIndexGroup(String kind) {
        Preconditions.checkNotNull(kind);
        KindIndexGroup kindIndexGroup = this.kindToIndexGroupMap().get(kind);
        if (kindIndexGroup == null) {
            return DatabaseIndexGroup.makeKindIndexGroup(kind, ImmutableList.of(), this.allDatastoreBuiltins(), this.singleFieldIndexing());
        }
        return kindIndexGroup;
    }

    abstract ImmutableMap<String, KindIndexGroup> kindToIndexGroupMap();

    public abstract ImmutableMap<Long, Index> allCompositeIndexesById();

    public abstract ImmutableList<Index> allCompositeIndexes();

    public abstract ImmutableList<DatastoreBuiltinIndex> allDatastoreBuiltins();

    public abstract SingleFieldIndexingConfiguration singleFieldIndexing();

    public Value.DatastoreIndexing datastoreIndexing() {
        return defaultDatastoreIndexing;
    }

    public static DatabaseIndexGroup create(ImmutableList<Index> compositeIndexes, ImmutableList<DatastoreBuiltinIndex> datastoreBuiltins, SingleFieldIndexingConfiguration singleFieldIndexing) {
        return new AutoValue_DatabaseIndexGroup(DatabaseIndexGroup.makeKindToIndexGroupMap(compositeIndexes, datastoreBuiltins, singleFieldIndexing), DatabaseIndexGroup.makeCompositeIndexMap(compositeIndexes), compositeIndexes, datastoreBuiltins, singleFieldIndexing);
    }

    public DatabaseIndexGroup withKindToIndexGroupMap(ImmutableMap<String, KindIndexGroup> value) {
        return new AutoValue_DatabaseIndexGroup(value, this.allCompositeIndexesById(), this.allCompositeIndexes(), this.allDatastoreBuiltins(), this.singleFieldIndexing());
    }

    private static ImmutableMap<String, KindIndexGroup> makeKindToIndexGroupMap(ImmutableList<Index> compositeIndexes, ImmutableList<DatastoreBuiltinIndex> datastoreBuiltins, SingleFieldIndexingConfiguration singleFieldIndexing) {
        ArrayListMultimap<String, Index> kindToIndexMultimap = ArrayListMultimap.create();
        for (Index index : compositeIndexes) {
            kindToIndexMultimap.put(index.definition().kind(), index);
        }
        ImmutableMap.Builder<String, KindIndexGroup> kindToIndexGroupMapBuilder = ImmutableMap.builder();
        for (Map.Entry entry : kindToIndexMultimap.asMap().entrySet()) {
            String kind = (String)entry.getKey();
            Collection kindIndexes = entry.getValue();
            KindIndexGroup kindIndexGroup = DatabaseIndexGroup.makeKindIndexGroup(kind, ImmutableList.copyOf(kindIndexes), datastoreBuiltins, singleFieldIndexing);
            kindToIndexGroupMapBuilder.put(kind, kindIndexGroup);
        }
        return kindToIndexGroupMapBuilder.build();
    }

    private static ImmutableMap<Long, Index> makeCompositeIndexMap(ImmutableList<Index> compositeIndexes) {
        HashMap<Long, Index> results = new HashMap<Long, Index>();
        for (Index index : compositeIndexes) {
            results.put(index.id(), index);
        }
        return ImmutableMap.copyOf(results);
    }

    private static KindIndexGroup makeKindIndexGroup(String kind, ImmutableList<Index> compositeIndexes, ImmutableList<DatastoreBuiltinIndex> datastoreBuiltins, SingleFieldIndexingConfiguration singleFieldIndexing) {
        return KindIndexGroup.create(kind, compositeIndexes, datastoreBuiltins, Names.isNameReserved(kind) ? SingleFieldIndexingConfiguration.EMPTY : singleFieldIndexing);
    }
}

