/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_EntityChange;
import com.google.cloud.datastore.core.rep.EntityV3Differ;
import com.google.common.base.Preconditions;
import com.google.storage.onestore.v3.OnestoreEntity;
import javax.annotation.Nullable;

@AutoValue
public abstract class EntityChange {
    public static final long NO_CREATE_TIME = -1L;

    public static EntityChange create(@Nullable OnestoreEntity.EntityProto newValue, @Nullable EntityV3Differ.EntityDelta entityDelta) {
        return EntityChange.create(newValue, entityDelta, -1L);
    }

    public static EntityChange create(@Nullable OnestoreEntity.EntityProto newValue, @Nullable EntityV3Differ.EntityDelta entityDelta, long createTimeMicros) {
        Preconditions.checkArgument(newValue != null || entityDelta != null, "EntityProto and EntityDelta cannot both be null.");
        return new AutoValue_EntityChange(newValue, entityDelta, createTimeMicros);
    }

    @Nullable
    public abstract OnestoreEntity.EntityProto newValue();

    @Nullable
    public abstract EntityV3Differ.EntityDelta entityDelta();

    public abstract long createTime();

    public boolean isDelete() {
        return this.newValue() == null;
    }

    public boolean isInsert() {
        return this.entityDelta() == null;
    }

    public boolean isUpdate() {
        return this.newValue() != null && this.entityDelta() != null;
    }
}

