/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_EntityRef;
import com.google.cloud.datastore.core.rep.AutoValue_EntityRef_Path;
import com.google.cloud.datastore.core.rep.AutoValue_EntityRef_PathElement;
import com.google.cloud.datastore.core.rep.AutoValue_EntityRef_ResourceId;
import com.google.cloud.datastore.core.rep.PartitionRef;
import com.google.cloud.datastore.core.rep.ResourceRef;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@AutoValue
public abstract class EntityRef
implements ResourceRef {
    public static final EntityRef EMPTY = EntityRef.create(PartitionRef.EMPTY, new PathElement[0]);
    public static final int MAX_KEY_PATH_LENGTH = 100;
    private OnestoreEntity.Reference v3Reference = null;

    public abstract PartitionRef partitionRef();

    public abstract ImmutableList<PathElement> pathElements();

    public Path path() {
        return Path.create(this.pathElements());
    }

    public EntityRef parent() {
        Preconditions.checkState(!this.pathElements().isEmpty());
        int pathSize = this.pathElements().size();
        OnestoreEntity.Reference v3Ref = this.v3Reference();
        if (v3Ref != null) {
            v3Ref = (OnestoreEntity.Reference)v3Ref.clone();
            v3Ref.getPath().mutableElements().remove(pathSize - 1);
        }
        return EntityRef.create(this.partitionRef(), this.pathElements().subList(0, pathSize - 1)).withV3Reference(v3Ref);
    }

    public PathElement lastPathElement() {
        Preconditions.checkState(!this.pathElements().isEmpty());
        return Iterables.getLast(this.pathElements());
    }

    public String collectionId() {
        return this.lastPathElement().collectionId();
    }

    @Nullable
    public ResourceId resourceId() {
        return this.lastPathElement().resourceId();
    }

    public static EntityRef create(PartitionRef partitionRef, List<PathElement> path) {
        return new AutoValue_EntityRef(partitionRef, ImmutableList.copyOf(path));
    }

    public static EntityRef create(PartitionRef partitionRef, Path path) {
        return new AutoValue_EntityRef(partitionRef, path.elements());
    }

    public static EntityRef create(PartitionRef partitionRef, PathElement ... pathElements) {
        return EntityRef.create(partitionRef, ImmutableList.copyOf(pathElements));
    }

    @Deprecated
    @Nullable
    public OnestoreEntity.Reference v3Reference() {
        return this.v3Reference;
    }

    @Deprecated
    public EntityRef withV3Reference(OnestoreEntity.Reference v3Reference) {
        AutoValue_EntityRef result = new AutoValue_EntityRef(this.partitionRef(), this.pathElements());
        result.v3Reference = v3Reference;
        return result;
    }

    @AutoValue
    public static abstract class Path {
        public abstract ImmutableList<PathElement> elements();

        public static Path create(List<PathElement> elements) {
            return new AutoValue_EntityRef_Path(ImmutableList.copyOf(elements));
        }

        public boolean isEmpty() {
            return this.elements().isEmpty();
        }

        public int size() {
            return this.elements().size();
        }

        public PathElement lastElement() {
            return Iterables.getLast(this.elements());
        }

        public String collectionId() {
            return this.lastElement().collectionId();
        }

        @Nullable
        public ResourceId resourceId() {
            return this.lastElement().resourceId();
        }

        @CheckReturnValue
        public Path append(PathElement element) {
            return Path.create((List<PathElement>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.elements())).add(element)).build()));
        }

        @CheckReturnValue
        public Path concat(Path other) {
            return Path.create((List<PathElement>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.elements())).addAll(other.elements())).build()));
        }

        public Path parent() {
            return Path.create(this.elements().subList(0, this.elements().size() - 1));
        }

        @CheckReturnValue
        public Path truncate(int numElements) {
            if (numElements >= this.size()) {
                return this;
            }
            return Path.create(this.elements().subList(0, numElements));
        }
    }

    @AutoValue
    public static abstract class PathElement {
        public abstract String collectionId();

        @Nullable
        public abstract ResourceId resourceId();

        public static PathElement create(String collectionId, @Nullable ResourceId resourceId) {
            return new AutoValue_EntityRef_PathElement(collectionId, resourceId);
        }
    }

    @AutoValue
    public static abstract class ResourceId {
        @Nullable
        public abstract String asString();

        public abstract long asLong();

        public boolean isLong() {
            return 0L != this.asLong();
        }

        public boolean isString() {
            return this.asString() != null;
        }

        public static ResourceId createString(String stringId) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(stringId));
            return new AutoValue_EntityRef_ResourceId(stringId, 0L);
        }

        public static ResourceId createLong(long longId) {
            Preconditions.checkArgument(longId != 0L);
            return new AutoValue_EntityRef_ResourceId(null, longId);
        }
    }
}

