/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_EntityV3Differ_ValuePlus;
import com.google.cloud.datastore.core.rep.DatastoreValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class EntityV3Differ {
    @Nullable
    public static EntityDelta diff(OnestoreEntity.EntityProto oldEntity, @Nullable OnestoreEntity.EntityProto newEntity) {
        return newEntity == null ? EntityDelta.fromDeletedEntity(oldEntity) : EntityDelta.fromEntities(oldEntity, newEntity);
    }

    public static final class KeyValueDelta {
        private final OnestoreEntity.Reference key;

        public KeyValueDelta(@Nullable OnestoreEntity.Reference key) {
            this.key = key;
        }

        @Nullable
        public OnestoreEntity.Reference key() {
            return this.key;
        }
    }

    public static final class ArrayValueDelta
    extends ValueDelta {
        private final ImmutableMap<Integer, ValueDelta> oldIndexToValueDeltas;

        @Nullable
        private static ArrayValueDelta diff(List<ValuePlus> oldValuePluses, List<ValuePlus> newValuePluses) {
            int i;
            ImmutableMap.Builder<Integer, ValueDelta> arrayDeltaMapBuilder = ImmutableMap.builder();
            int commonLength = Math.min(newValuePluses.size(), oldValuePluses.size());
            for (i = 0; i < commonLength; ++i) {
                ValueDelta valueDelta = SingleValueDelta.diffSingleProperty(oldValuePluses.get(i), newValuePluses.get(i));
                if (valueDelta == null) continue;
                arrayDeltaMapBuilder.put(i, valueDelta);
            }
            if (newValuePluses.size() > commonLength) {
                arrayDeltaMapBuilder.put(commonLength, AbsentValueDelta.ABSENT_VALUE);
            } else if (oldValuePluses.size() > commonLength) {
                for (i = commonLength; i < oldValuePluses.size(); ++i) {
                    arrayDeltaMapBuilder.put(i, new SingleValueDelta(oldValuePluses.get(i)));
                }
            }
            ImmutableMap<Integer, ValueDelta> arrayDelta = arrayDeltaMapBuilder.build();
            if (arrayDelta.isEmpty()) {
                return null;
            }
            return new ArrayValueDelta(arrayDelta);
        }

        public ArrayValueDelta(Map<Integer, ValueDelta> oldIndexToValueDeltas) {
            this.oldIndexToValueDeltas = ImmutableMap.copyOf(oldIndexToValueDeltas);
        }

        public ImmutableMap<Integer, ValueDelta> getOldIndexToValueDeltas() {
            return this.oldIndexToValueDeltas;
        }
    }

    public static final class FullArrayDelta
    extends ValueDelta {
        private final ImmutableList<ValuePlus> oldValuePluses;

        public FullArrayDelta(List<ValuePlus> valuePluses) {
            this.oldValuePluses = ImmutableList.copyOf(valuePluses);
        }

        public ImmutableList<ValuePlus> oldValuePluses() {
            return this.oldValuePluses;
        }
    }

    public static final class EntityDelta
    extends ValueDelta {
        private static final ImmutableList<ValuePlus> EMPTY_ARRAY_PROPERTIES = ImmutableList.of(ValuePlus.EMPTY_ARRAY);
        @Nullable
        private final KeyValueDelta key;
        private final ImmutableMap<String, ValueDelta> propertyNameToValueDeltas;
        private final boolean oldIndexed;

        public static EntityDelta fromEntities(OnestoreEntity.EntityProto oldEntity, OnestoreEntity.EntityProto newEntity) {
            Preconditions.checkArgument(oldEntity.getKey().equals(newEntity.getKey()));
            return EntityDelta.fromEntityValues(true, oldEntity, true, newEntity);
        }

        public static EntityDelta fromDeletedEntity(OnestoreEntity.EntityProto oldEntity) {
            return EntityDelta.fromEntityValues(true, oldEntity, true, new OnestoreEntity.EntityProto());
        }

        @Nullable
        private static EntityDelta fromEntityValues(boolean oldIndexed, OnestoreEntity.EntityProto oldEntity, boolean newIndexed, OnestoreEntity.EntityProto newEntity) {
            KeyValueDelta key;
            ListMultimap<String, ValuePlus> oldValuePlusMap = EntityDelta.toValuePlusListMultimap(oldEntity);
            ListMultimap<String, ValuePlus> newValuePlusMap = EntityDelta.toValuePlusListMultimap(newEntity);
            HashMap<String, ValueDelta> propertyNameToValueDeltas = new HashMap<String, ValueDelta>();
            EntityDelta.compareProperties(oldValuePlusMap, newValuePlusMap, propertyNameToValueDeltas);
            EntityDelta.addDeletedProperties(oldValuePlusMap, newValuePlusMap.keySet(), propertyNameToValueDeltas);
            KeyValueDelta keyValueDelta = key = oldEntity.getKey().equals(newEntity.getKey()) ? null : new KeyValueDelta(oldEntity.getKey());
            if (propertyNameToValueDeltas.isEmpty() && oldIndexed == newIndexed && key == null) {
                return null;
            }
            return new EntityDelta(key, oldIndexed, propertyNameToValueDeltas);
        }

        private static ListMultimap<String, ValuePlus> toValuePlusListMultimap(OnestoreEntity.EntityProto entityProto) {
            ArrayListMultimap<String, ValuePlus> result = ArrayListMultimap.create();
            EntityDelta.convertToValuePlusAndAddToPropertyMap(true, entityProto.propertys(), result);
            EntityDelta.convertToValuePlusAndAddToPropertyMap(false, entityProto.rawPropertys(), result);
            return result;
        }

        private static void convertToValuePlusAndAddToPropertyMap(boolean isIndexed, List<OnestoreEntity.Property> properties, ListMultimap<String, ValuePlus> valuePlusMap) {
            for (OnestoreEntity.Property property : properties) {
                valuePlusMap.put(property.getName(), ValuePlus.create(isIndexed, property));
            }
        }

        private static void compareProperties(ListMultimap<String, ValuePlus> oldValuePlusMap, ListMultimap<String, ValuePlus> newValuePlusMap, Map<String, ValueDelta> valueDeltas) {
            for (Map.Entry<String, List<ValuePlus>> newValuePlusEntry : Multimaps.asMap(newValuePlusMap).entrySet()) {
                String propertyName = newValuePlusEntry.getKey();
                List<ValuePlus> newValuePluses = newValuePlusEntry.getValue();
                Collection oldValuePluses = oldValuePlusMap.get((Object)propertyName);
                ValueDelta valueDelta = oldValuePluses.isEmpty() ? AbsentValueDelta.ABSENT_VALUE : EntityDelta.diffPropertyLists(EntityDelta.canonicalizeEmptyArray((List<ValuePlus>)oldValuePlusMap.get((Object)propertyName)), EntityDelta.canonicalizeEmptyArray(newValuePluses));
                if (valueDelta == null) continue;
                valueDeltas.put(propertyName, valueDelta);
            }
        }

        private static void addDeletedProperties(ListMultimap<String, ValuePlus> oldValuePlusMap, Set<String> newEntityPropertyNames, Map<String, ValueDelta> valueDeltas) {
            for (String propertyName : oldValuePlusMap.keySet()) {
                if (newEntityPropertyNames.contains(propertyName)) continue;
                List<ValuePlus> oldValuePluses = oldValuePlusMap.get((Object)propertyName);
                ValueDelta valueDelta = EntityDelta.representsArray(oldValuePluses = EntityDelta.canonicalizeEmptyArray(oldValuePluses)) ? new FullArrayDelta(oldValuePluses) : new SingleValueDelta(oldValuePluses.get(0));
                valueDeltas.put(propertyName, valueDelta);
            }
        }

        @Nullable
        private static ValueDelta diffPropertyLists(List<ValuePlus> oldValuePluses, List<ValuePlus> newValuePluses) {
            boolean newIsArray;
            boolean oldIsArray = EntityDelta.representsArray(oldValuePluses);
            if (oldIsArray == (newIsArray = EntityDelta.representsArray(newValuePluses))) {
                if (oldIsArray) {
                    return ArrayValueDelta.diff(oldValuePluses, newValuePluses);
                }
                return SingleValueDelta.diffSingleProperty(oldValuePluses.get(0), newValuePluses.get(0));
            }
            if (oldIsArray) {
                return new FullArrayDelta(oldValuePluses);
            }
            return new SingleValueDelta(oldValuePluses.get(0));
        }

        private static List<ValuePlus> canonicalizeEmptyArray(List<ValuePlus> valuePluses) {
            if (EMPTY_ARRAY_PROPERTIES.equals(valuePluses)) {
                return ImmutableList.of();
            }
            return valuePluses;
        }

        private static boolean representsArray(List<ValuePlus> valuePluses) {
            return valuePluses.size() != 1 || valuePluses.get(0).isArrayElement();
        }

        public EntityDelta(@Nullable KeyValueDelta key, boolean oldIndexed, Map<String, ValueDelta> propertyNameToValueDeltas) {
            this.oldIndexed = oldIndexed;
            this.key = key;
            this.propertyNameToValueDeltas = ImmutableMap.copyOf(propertyNameToValueDeltas);
        }

        @Nullable
        public KeyValueDelta keyDelta() {
            return this.key;
        }

        public ImmutableMap<String, ValueDelta> propertyNameToValueDeltas() {
            return this.propertyNameToValueDeltas;
        }

        public boolean isOldIndexed() {
            return this.oldIndexed;
        }
    }

    public static final class SingleValueDelta
    extends ValueDelta {
        private final ValuePlus oldValuePlus;

        @Nullable
        private static ValueDelta diffSingleProperty(ValuePlus oldValuePlus, ValuePlus newValuePlus) {
            OnestoreEntity.EntityProto newEntity;
            OnestoreEntity.EntityProto oldEntity;
            if (oldValuePlus.equals(newValuePlus)) {
                return null;
            }
            if (oldValuePlus.isValueEntity() && newValuePlus.isValueEntity() && (oldEntity = SingleValueDelta.convertPropertyValueToEntityProto(oldValuePlus.value())) != null && (newEntity = SingleValueDelta.convertPropertyValueToEntityProto(newValuePlus.value())) != null) {
                return EntityDelta.fromEntityValues(oldValuePlus.isIndexed(), oldEntity, newValuePlus.isIndexed(), newEntity);
            }
            return new SingleValueDelta(oldValuePlus);
        }

        @Nullable
        private static OnestoreEntity.EntityProto convertPropertyValueToEntityProto(DatastoreValue value) {
            try {
                return OnestoreEntity.EntityProto.parser().parsePartialFrom(value.v3Value().getStringValueAsBytes());
            }
            catch (InvalidProtocolBufferException e) {
                return null;
            }
        }

        public SingleValueDelta(ValuePlus oldValuePlus) {
            this.oldValuePlus = oldValuePlus;
        }

        public ValuePlus oldValuePlus() {
            return this.oldValuePlus;
        }
    }

    public static class AbsentValueDelta
    extends ValueDelta {
        public static final AbsentValueDelta ABSENT_VALUE = new AbsentValueDelta();

        private AbsentValueDelta() {
        }
    }

    public static abstract class ValueDelta {
    }

    @AutoValue
    public static abstract class ValuePlus {
        public static final ValuePlus EMPTY_ARRAY = new AutoValue_EntityV3Differ_ValuePlus(false, true, OnestoreEntity.Property.Meaning.EMPTY_LIST, null, DatastoreValue.create(OnestoreEntity.PropertyValue.getDefaultInstance()));

        public static ValuePlus create(boolean isIndexed, OnestoreEntity.Property property) {
            if (property.getMeaningEnum() == OnestoreEntity.Property.Meaning.EMPTY_LIST) {
                return EMPTY_ARRAY;
            }
            String meaningUri = property.hasMeaningUri() ? property.getMeaningUri() : null;
            return new AutoValue_EntityV3Differ_ValuePlus(isIndexed, property.isMultiple(), property.getMeaningEnum(), meaningUri, DatastoreValue.create(property.getValue()));
        }

        public abstract boolean isIndexed();

        public abstract boolean isArrayElement();

        public abstract OnestoreEntity.Property.Meaning meaning();

        @Nullable
        public abstract String meaningUri();

        public abstract DatastoreValue value();

        public boolean isValueEntity() {
            return this.meaning() == OnestoreEntity.Property.Meaning.ENTITY_PROTO && this.value().v3Value().hasStringValue();
        }
    }
}

