/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.common.base.Preconditions;

public enum IdAllocationPolicy {
    SEQUENTIAL(1){

        @Override
        public long maximumCounterValue() {
            return 0xFFFFFFFFFFFFFL;
        }

        @Override
        public long counterToId(long counter) {
            return counter;
        }

        @Override
        public long idToCounter(long id) {
            return id;
        }

        @Override
        public boolean containsId(EntityRef.ResourceId id) {
            return id.isLong() && id.asLong() > 0L && id.asLong() <= 0xFFFFFFFFFFFFFL;
        }
    }
    ,
    SCATTERED(2){

        @Override
        public long maximumCounterValue() {
            return 0x7FFFFFFFFFFFFL;
        }

        @Override
        public boolean containsId(EntityRef.ResourceId id) {
            return id.isLong() && id.asLong() > 0xFFFFFFFFFFFFFL && id.asLong() <= 0x17FFFFFFFFFFFFL;
        }

        @Override
        public long counterToId(long counter) {
            if (counter > 0x7FFFFFFFFFFFFL) {
                throw new IndexOutOfBoundsException("Maximum scattered ID counter value exceeded");
            }
            return 0x10000000000000L + Long.reverse(counter << 13);
        }

        @Override
        public long idToCounter(long id) {
            Preconditions.checkArgument(this.containsId(EntityRef.ResourceId.createLong(id)), "ID does not conform to scattered ID allocation policy");
            return Long.reverse(id) >>> 13;
        }
    }
    ,
    FIRESTORE_V1_AUTO(3){

        @Override
        public boolean containsId(EntityRef.ResourceId id) {
            return !id.isLong();
        }

        @Override
        public long maximumCounterValue() {
            String string = String.valueOf((Object)FIRESTORE_V1_AUTO);
            throw new UnsupportedOperationException(new StringBuilder(21 + String.valueOf(string).length()).append("does not apply under ").append(string).toString());
        }

        @Override
        public long counterToId(long counter) {
            String string = String.valueOf((Object)FIRESTORE_V1_AUTO);
            throw new UnsupportedOperationException(new StringBuilder(21 + String.valueOf(string).length()).append("does not apply under ").append(string).toString());
        }

        @Override
        public long idToCounter(long id) {
            String string = String.valueOf((Object)FIRESTORE_V1_AUTO);
            throw new UnsupportedOperationException(new StringBuilder(21 + String.valueOf(string).length()).append("does not apply under ").append(string).toString());
        }
    };

    private static final long MAX_SEQUENTIAL_BIT = 52L;
    private static final long MAX_SEQUENTIAL_COUNTER_VALUE = 0xFFFFFFFFFFFFFL;
    private static final long MAX_SEQUENTIAL_ID = 0xFFFFFFFFFFFFFL;
    private static final long MAX_SCATTERED_COUNTER_VALUE = 0x7FFFFFFFFFFFFL;
    private static final long MAX_SCATTERED_ID = 0x17FFFFFFFFFFFFL;
    private static final long SCATTER_SHIFT = 13L;
    private final int id;

    public abstract boolean containsId(EntityRef.ResourceId var1);

    public abstract long maximumCounterValue();

    public abstract long counterToId(long var1);

    public abstract long idToCounter(long var1);

    private IdAllocationPolicy(int id) {
        this.id = id;
    }

    public int id() {
        return this.id;
    }
}

