/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.admininternal.Filter;
import com.google.cloud.datastore.core.rep.$AutoValue_Index;
import com.google.cloud.datastore.core.rep.IndexDef;
import com.google.cloud.datastore.core.rep.IndexState;
import com.google.cloud.datastore.core.rep.WorkflowState;
import com.google.cloud.datastore.internal.StorageFormat;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import javax.annotation.Nullable;

@AutoValue
public abstract class Index {
    public static final ImmutableMultimap<Filter.StateFilter, WorkflowState> STATE_FILTER_VISIBILITY = new ImmutableMultimap.Builder<Filter.StateFilter, WorkflowState>().putAll(Filter.StateFilter.USER_VISIBLE, WorkflowState.CREATED, WorkflowState.ENABLING, WorkflowState.SERVING).putAll(Filter.StateFilter.SHOW_NON_SERVING, (WorkflowState[])new WorkflowState[]{WorkflowState.CREATED, WorkflowState.ENABLING, WorkflowState.SERVING, WorkflowState.NON_SERVING}).putAll(Filter.StateFilter.ALL, (WorkflowState[])WorkflowState.values()).putAll(Filter.StateFilter.STATE_FILTER_UNSPECIFIED, (WorkflowState[])WorkflowState.values()).build();
    private static final ImmutableSet<WorkflowState> WRITING_STATES = ImmutableSet.of(WorkflowState.ENABLING, WorkflowState.SERVING, WorkflowState.NON_SERVING);

    public abstract IndexDef definition();

    public abstract long id();

    public abstract Optional<StorageFormat.BuiltinIndexId> builtinIndexId();

    @Deprecated
    public State state() {
        return this.state2().toLegacyState();
    }

    @Nullable
    public abstract Long updateTimeMicros();

    public abstract WorkflowState workflowState();

    public abstract boolean error();

    public IndexState state2() {
        return IndexState.create(this.workflowState(), this.error());
    }

    public boolean writing() {
        return WRITING_STATES.contains((Object)this.workflowState());
    }

    public abstract StorageVersion storageVersion();

    public boolean isFirestoreSingleField() {
        long indexId = this.id();
        return indexId == -6L || indexId == -9L || indexId == -7L || indexId == -10L || indexId == -12L || indexId == -13L;
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new $AutoValue_Index.Builder().storageVersion(StorageVersion.V1).error(false);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder definition(IndexDef var1);

        public abstract Builder id(long var1);

        public abstract Builder builtinIndexId(StorageFormat.BuiltinIndexId var1);

        public abstract Builder builtinIndexId(Optional<StorageFormat.BuiltinIndexId> var1);

        @Deprecated
        public Builder state(State state) {
            return this.workflowState(state.toWorkflowStateLossy()).error(state == State.ERROR);
        }

        protected abstract Builder error(boolean var1);

        protected abstract Builder workflowState(WorkflowState var1);

        public Builder workflowState(WorkflowState workflowState, boolean error) {
            return this.workflowState(workflowState).error(error);
        }

        public Builder indexState(IndexState indexState) {
            return this.workflowState(indexState.workflowState()).error(indexState.error());
        }

        public abstract Builder storageVersion(StorageVersion var1);

        public abstract Builder updateTimeMicros(@Nullable Long var1);

        public abstract Index build();
    }

    public static enum StorageVersion {
        V1,
        V2;

    }

    public static enum State {
        ENABLING,
        ENABLED,
        DELETING,
        DISABLING,
        DISABLED,
        ERROR,
        CREATED,
        NON_SERVING;


        public WorkflowState toWorkflowStateLossy() {
            switch (this) {
                case CREATED: {
                    return WorkflowState.CREATED;
                }
                case NON_SERVING: {
                    return WorkflowState.NON_SERVING;
                }
                case ENABLED: {
                    return WorkflowState.SERVING;
                }
                case ENABLING: {
                    return WorkflowState.ENABLING;
                }
                case DISABLING: 
                case DELETING: 
                case ERROR: {
                    return WorkflowState.DISABLING;
                }
                case DISABLED: {
                    return WorkflowState.DELETED;
                }
            }
            throw new AssertionError();
        }
    }
}

