/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.common.DatastoreCoreConfig;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.Index;
import com.google.cloud.datastore.core.rep.IndexValueAndRemainder;
import com.google.cloud.datastore.core.rep.JndexValue;
import com.google.cloud.datastore.core.rep.UnifiedIndexValue;
import com.google.cloud.datastore.core.rep.proto.IndexValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class IndexEntry {
    private final Index index;
    private final ImmutableList<IndexValueAndRemainder> values;
    @Nullable
    private final EntityRef ref;
    @Nullable
    private OnestoreEntity.CompositeProperty compositeProperty;

    public IndexEntry(Index index, ImmutableList<IndexValueAndRemainder> values, EntityRef ref) {
        this.index = Preconditions.checkNotNull(index);
        this.values = Preconditions.checkNotNull(values);
        this.ref = Preconditions.checkNotNull(ref);
        this.compositeProperty = null;
    }

    @Deprecated
    public IndexEntry(Index index, ImmutableList<IndexValueAndRemainder> values, @Nullable EntityRef ref, @Nullable OnestoreEntity.CompositeProperty compositeProperty) {
        this.index = index;
        this.values = values;
        this.ref = ref;
        this.compositeProperty = compositeProperty;
    }

    public Index index() {
        return this.index;
    }

    public ImmutableList<IndexValueAndRemainder> values() {
        return this.values;
    }

    @Nullable
    public OnestoreEntity.CompositeProperty compositeProperty() {
        return this.compositeProperty;
    }

    @Nullable
    public EntityRef entityRef() {
        return this.ref;
    }

    @Deprecated
    @Nullable
    public ImmutableList<IndexValueAndRemainder> getSingleFieldIndexValue() {
        if (this.index.isFirestoreSingleField()) {
            return ImmutableList.of(IndexEntry.dropContainsMark((IndexValueAndRemainder)this.values.get(1)), (IndexValueAndRemainder)this.values.get(3), (IndexValueAndRemainder)this.values.get(4));
        }
        return null;
    }

    private static IndexValueAndRemainder dropContainsMark(IndexValueAndRemainder value) {
        JndexValue last;
        ImmutableList<JndexValue> indexArray;
        IndexValue last2;
        List<IndexValue> indexArray2;
        IndexValue indexValue;
        UnifiedIndexValue unifiedIndexValue = value.unifiedIndexValue();
        if (unifiedIndexValue.isDatastore()) {
            return value;
        }
        JndexValue firestoreIndexValue = unifiedIndexValue.firestoreIndexValue();
        Object newIndexValue = null;
        JndexValue newJndexValue = null;
        if (!(!DatastoreCoreConfig.compareIndexValueJndexValue && DatastoreCoreConfig.useJndexValue || (indexValue = firestoreIndexValue.xjProto()).getValueTypeCase() != IndexValue.ValueTypeCase.ARRAY_VALUE || (indexArray2 = indexValue.getArrayValue().getValuesList()).isEmpty() || (last2 = Iterables.getLast(indexArray2)).getValueTypeCase() != IndexValue.ValueTypeCase.NULL_VALUE)) {
            IndexValue.ArrayValue.Builder array = IndexValue.ArrayValue.newBuilder();
            array.addAllValues(indexArray2);
            array.removeValues(array.getValuesCount() - 1);
            newIndexValue = IndexValue.newBuilder().setArrayValue(array).build();
        }
        if ((DatastoreCoreConfig.compareIndexValueJndexValue || DatastoreCoreConfig.useJndexValue) && firestoreIndexValue.type() == JndexValue.Type.ARRAY && !(indexArray = firestoreIndexValue.asArray()).isEmpty() && (last = (JndexValue)indexArray.get(indexArray.size() - 1)).equals(JndexValue.NULL)) {
            newJndexValue = JndexValue.createArray(false, ImmutableList.copyOf(indexArray.subList(0, indexArray.size() - 1)));
            newJndexValue.setXjProto((IndexValue)newIndexValue);
        }
        if (DatastoreCoreConfig.compareIndexValueJndexValue && newJndexValue == null != (newIndexValue == null)) {
            DatastoreCoreConfig.hackReportProblem(DatastoreCoreConfig.ProblemType.INDEX_JNDEX_IS_ARRAY_WITH_ELEMENT_MISMATCH, null, new Exception(value.toString()));
        }
        if ((DatastoreCoreConfig.useJndexValue ? newJndexValue : newIndexValue) == null) {
            return value;
        }
        if (!DatastoreCoreConfig.useJndexValue && !DatastoreCoreConfig.compareIndexValueJndexValue) {
            newJndexValue = JndexValue.xjCreateProto(newIndexValue);
        }
        return IndexValueAndRemainder.createForFirestore(newJndexValue);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("values", this.values).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexEntry that = (IndexEntry)o;
        return this.index.equals(that.index) && this.values.equals(that.values) && Objects.equals(this.ref, that.ref);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.values, this.ref);
    }
}

