/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_IndexState;
import com.google.cloud.datastore.core.rep.Index;
import com.google.cloud.datastore.core.rep.WorkflowState;

@AutoValue
public abstract class IndexState {
    public abstract WorkflowState workflowState();

    public abstract boolean error();

    public static IndexState of(WorkflowState workflowState) {
        return IndexState.create(workflowState, false);
    }

    public static IndexState create(WorkflowState workflowState, boolean error) {
        return new AutoValue_IndexState(workflowState, error);
    }

    public Index.State toLegacyState() {
        if (this.error()) {
            return Index.State.ERROR;
        }
        switch (this.workflowState()) {
            case CREATED: {
                return Index.State.CREATED;
            }
            case ENABLING: {
                return Index.State.ENABLING;
            }
            case SERVING: {
                return Index.State.ENABLED;
            }
            case NON_SERVING: {
                return Index.State.NON_SERVING;
            }
            case DISABLING: {
                return Index.State.DELETING;
            }
            case DELETED: {
                return Index.State.DISABLED;
            }
        }
        throw new IllegalArgumentException(String.format("Invalid or unknown index state: %s", new Object[]{this.workflowState()}));
    }
}

