/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_IndexValueAndRemainder_EncodedMegastoreIndexValue;
import com.google.cloud.datastore.core.rep.AutoValue_IndexValueAndRemainder_Regular;
import com.google.cloud.datastore.core.rep.JndexValue;
import com.google.cloud.datastore.core.rep.UnifiedIndexValue;
import com.google.storage.onestore.v3.OnestoreEntity;

public abstract class IndexValueAndRemainder {
    public static final byte[] UNUSED_MEGASTORE_ENCODED_BYTE_ARRAY = new byte[0];

    public static IndexValueAndRemainder createWithoutRemainder(JndexValue indexValue) {
        return new AutoValue_IndexValueAndRemainder_Regular(UnifiedIndexValue.create(indexValue), OnestoreEntity.Property.Meaning.NO_MEANING);
    }

    public static IndexValueAndRemainder createForDatastore(UnifiedIndexValue unifiedIndexValue, OnestoreEntity.Property.Meaning meaning) {
        return new AutoValue_IndexValueAndRemainder_Regular(unifiedIndexValue, meaning);
    }

    public static IndexValueAndRemainder createForDatastore(UnifiedIndexValue unifiedIndexValue, OnestoreEntity.Property.Meaning meaning, byte[] encodedMegastoreIndexValue) {
        return new AutoValue_IndexValueAndRemainder_EncodedMegastoreIndexValue(unifiedIndexValue, meaning, encodedMegastoreIndexValue);
    }

    public static IndexValueAndRemainder createForFirestore(JndexValue indexValue) {
        return new AutoValue_IndexValueAndRemainder_Regular(UnifiedIndexValue.create(indexValue), OnestoreEntity.Property.Meaning.NO_MEANING);
    }

    public static IndexValueAndRemainder createStringForDatastore(String value) {
        OnestoreEntity.PropertyValue pvalue = new OnestoreEntity.PropertyValue().setStringValue(value);
        return new AutoValue_IndexValueAndRemainder_Regular(UnifiedIndexValue.create(pvalue), OnestoreEntity.Property.Meaning.NO_MEANING);
    }

    public static IndexValueAndRemainder createStringForDatastore(byte[] stringBytes) {
        OnestoreEntity.PropertyValue pvalue = new OnestoreEntity.PropertyValue().setStringValueAsBytes(stringBytes);
        return new AutoValue_IndexValueAndRemainder_Regular(UnifiedIndexValue.create(pvalue), OnestoreEntity.Property.Meaning.NO_MEANING);
    }

    public abstract UnifiedIndexValue unifiedIndexValue();

    public abstract OnestoreEntity.Property.Meaning meaning();

    public byte[] encodedMegastoreIndexValue() {
        return UNUSED_MEGASTORE_ENCODED_BYTE_ARRAY;
    }

    public IndexValueAndRemainder reverseMegastoreEncoding() {
        throw new UnsupportedOperationException();
    }

    @AutoValue
    protected static abstract class EncodedMegastoreIndexValue
    extends IndexValueAndRemainder {
        protected EncodedMegastoreIndexValue() {
        }

        @Override
        public abstract byte[] encodedMegastoreIndexValue();
    }

    @AutoValue
    protected static abstract class Regular
    extends IndexValueAndRemainder {
        protected Regular() {
        }
    }
}

