/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.rep.EntitySize;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.proto.IndexValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Utf8;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import com.google.type.LatLng;
import java.util.Map;
import javax.annotation.Nullable;

public class JndexValue {
    public static final int NULL_NATURAL_SIZE = 1;
    public static final int BOOLEAN_NATURAL_SIZE = 1;
    public static final int NUMBER_NATURAL_SIZE = 8;
    public static final int TIMESTAMP_NATURAL_SIZE = 8;
    public static final int GEO_POINT_NATURAL_SIZE = 16;
    public static final int STRING_BASE_NATURAL_SIZE = 1;
    public static final int ENTITY_REF_BASE_NATURAL_SIZE = 16;
    private static final Object NO_BOXED_OBJECT = new Object();
    public static final JndexValue ABSENT = new JndexValue();
    public static final JndexValue NULL = new JndexValue(Type.NULL, -2401018188504514833L, false, 1);
    public static final JndexValue NAN = new JndexValue(Type.NUMBER, Double.doubleToRawLongBits(Double.NaN), true, 8);
    public static final JndexValue FALSE = new JndexValue(Type.BOOLEAN, 0L, false, 1);
    public static final JndexValue TRUE = new JndexValue(Type.BOOLEAN, 1L, false, 1);
    public static final JndexValue EMPTY_STRING = JndexValue.createString(false, "");
    public static final JndexValue EMPTY_ARRAY = JndexValue.createArray(false, ImmutableList.of());
    public static final JndexValue EMPTY_MAP = JndexValue.createMap(false, ImmutableMap.of());
    private final boolean isDeepTruncated;
    private final boolean isShallowTruncated;
    private final boolean isNumberDouble;
    private final int naturalSize;
    private final Type type;
    private final long unboxed;
    private final Object boxed;
    private IndexValue xjProto = null;

    public static JndexValue xjCreateProto(IndexValue x) {
        JndexValue indexValue = new JndexValue(null, -2401053089408754003L, false, -1);
        indexValue.setXjProto(x);
        return indexValue;
    }

    public static JndexValue createBoolean(boolean x) {
        return x ? TRUE : FALSE;
    }

    public static JndexValue createNumberLong(long x) {
        return new JndexValue(Type.NUMBER, x, false, 8);
    }

    public static JndexValue createNumberDouble(double x) {
        return new JndexValue(Type.NUMBER, Double.doubleToRawLongBits(x), true, 8);
    }

    public static JndexValue createTimestamp(Timestamp x) {
        return new JndexValue(Type.TIMESTAMP, x, 8);
    }

    public static JndexValue createString(boolean isTruncated, String x) {
        return new JndexValue(isTruncated, Type.STRING, x, JndexValue.computeStringNaturalSize(x));
    }

    private static int computeStringNaturalSize(String string) {
        return 1 + Utf8.encodedLength(string);
    }

    public static JndexValue createBytes(boolean isTruncated, ByteString x) {
        Preconditions.checkArgument(!isTruncated || !x.isEmpty());
        return new JndexValue(isTruncated, Type.BYTES, x, x.size());
    }

    public static JndexValue createEntityRef(EntityRef x) {
        return new JndexValue(x.namespaceId.isDeepTruncated() || x.segments.isDeepTruncated(), false, Type.ENTITY_REF, x, JndexValue.computeEntityRefNaturalSize(x));
    }

    private static int computeEntityRefNaturalSize(EntityRef indexValueEntityRef) {
        int namespaceIdNaturalSize = indexValueEntityRef.namespaceId.equals(EMPTY_STRING) ? 0 : indexValueEntityRef.namespaceId.naturalSize();
        return 16 + namespaceIdNaturalSize + indexValueEntityRef.segments.naturalSize();
    }

    public static JndexValue createGeoPoint(LatLng x) {
        return new JndexValue(Type.GEO_POINT, x, 16);
    }

    public static JndexValue createArray(boolean isShallowTruncated, ImmutableList<JndexValue> x) {
        ImmutableList<JndexValue> elements = x;
        int numElements = elements.size();
        int naturalSize = 0;
        Preconditions.checkArgument(!isShallowTruncated || numElements != 0);
        boolean isDeepTruncated = isShallowTruncated;
        for (int index = 0; index < numElements; ++index) {
            JndexValue element = (JndexValue)elements.get(index);
            if (element.isDeepTruncated()) {
                Preconditions.checkArgument(index == numElements - 1);
                Preconditions.checkArgument(!isShallowTruncated);
                Preconditions.checkArgument(element != ABSENT);
                isDeepTruncated = true;
            }
            naturalSize += element.naturalSize();
        }
        return new JndexValue(isDeepTruncated, isShallowTruncated, Type.ARRAY, x, naturalSize);
    }

    public static JndexValue createMap(boolean isShallowTruncated, ImmutableMap<JndexValue, JndexValue> x) {
        ImmutableMap<JndexValue, JndexValue> map = x;
        int naturalSize = 0;
        JndexValue prevKeyIndexValue = null;
        JndexValue prevValueIndexValue = null;
        for (Map.Entry entry : map.entrySet()) {
            JndexValue keyIndexValue = (JndexValue)entry.getKey();
            JndexValue valueIndexValue = (JndexValue)entry.getValue();
            naturalSize += keyIndexValue.naturalSize() + valueIndexValue.naturalSize();
            if (prevKeyIndexValue != null) {
                Preconditions.checkArgument(!prevKeyIndexValue.isDeepTruncated());
                Preconditions.checkArgument(!prevValueIndexValue.isDeepTruncated());
            }
            prevKeyIndexValue = keyIndexValue;
            prevValueIndexValue = valueIndexValue;
        }
        boolean isDeepTruncated = isShallowTruncated;
        if (prevKeyIndexValue == null) {
            Preconditions.checkArgument(!isShallowTruncated);
        } else if (isShallowTruncated) {
            Preconditions.checkArgument(!prevKeyIndexValue.isDeepTruncated());
            Preconditions.checkArgument(!prevValueIndexValue.isDeepTruncated());
        } else if (prevKeyIndexValue.isDeepTruncated()) {
            Preconditions.checkArgument(prevValueIndexValue == ABSENT);
            isDeepTruncated = true;
        } else {
            isDeepTruncated = prevValueIndexValue.isDeepTruncated();
        }
        return new JndexValue(isDeepTruncated, isShallowTruncated, Type.MAP, x, naturalSize);
    }

    public static JndexValue createLegacyUser(Value.LegacyUser x) {
        int naturalSize = EntitySize.legacyUserSize(x);
        return new JndexValue(Type.LEGACY_USER, x, naturalSize);
    }

    private JndexValue() {
        this.isDeepTruncated = true;
        this.isShallowTruncated = true;
        this.type = Type.ABSENT_TYPE;
        this.unboxed = -2401053088876216593L;
        this.boxed = NO_BOXED_OBJECT;
        this.isNumberDouble = false;
        this.naturalSize = 0;
    }

    private JndexValue(Type type, long unboxed, boolean isNumberDouble, int naturalSize) {
        this.isDeepTruncated = false;
        this.isShallowTruncated = false;
        this.type = type;
        this.unboxed = unboxed;
        this.boxed = NO_BOXED_OBJECT;
        this.isNumberDouble = isNumberDouble;
        this.naturalSize = naturalSize;
    }

    private JndexValue(Type type, Object boxed, int naturalSize) {
        this.isDeepTruncated = false;
        this.isShallowTruncated = false;
        this.type = type;
        this.unboxed = -4688283849255297363L;
        this.boxed = boxed;
        this.isNumberDouble = false;
        this.naturalSize = naturalSize;
    }

    private JndexValue(boolean isTruncated, Type type, Object boxed, int naturalSize) {
        this.isDeepTruncated = isTruncated;
        this.isShallowTruncated = isTruncated;
        this.type = type;
        this.unboxed = -4688283849255297363L;
        this.boxed = boxed;
        this.isNumberDouble = false;
        this.naturalSize = naturalSize;
    }

    private JndexValue(boolean isDeepTruncated, boolean isShallowTruncated, Type type, Object boxed, int naturalSize) {
        this.isDeepTruncated = isDeepTruncated;
        this.isShallowTruncated = isShallowTruncated;
        this.type = type;
        this.unboxed = -4688283849255297363L;
        this.boxed = boxed;
        this.isNumberDouble = false;
        this.naturalSize = naturalSize;
    }

    public Type type() {
        return this.type;
    }

    public boolean isShallowTruncated() {
        return this.isShallowTruncated;
    }

    public boolean isDeepTruncated() {
        return this.isDeepTruncated;
    }

    public int naturalSize() {
        return this.naturalSize;
    }

    @Nullable
    public IndexValue xjProto() {
        return this.xjProto;
    }

    public JndexValue setXjProto(IndexValue x) {
        Preconditions.checkState(this.xjProto == null || this.xjProto.equals(x));
        this.xjProto = x;
        return this;
    }

    public boolean asBoolean() {
        Preconditions.checkState(this.type == Type.BOOLEAN);
        return this.unboxed != 0L;
    }

    public boolean isNumberDouble() {
        return this.isNumberDouble;
    }

    public long asNumberLong() {
        Preconditions.checkState(this.type == Type.NUMBER);
        Preconditions.checkState(!this.isNumberDouble);
        return this.unboxed;
    }

    public double asNumberDouble() {
        Preconditions.checkState(this.type == Type.NUMBER);
        Preconditions.checkState(this.isNumberDouble);
        return Double.longBitsToDouble(this.unboxed);
    }

    public Timestamp asTimestamp() {
        return (Timestamp)this.boxed;
    }

    public String asString() {
        return (String)this.boxed;
    }

    public ByteString asBytes() {
        return (ByteString)this.boxed;
    }

    public EntityRef asEntityRef() {
        return (EntityRef)this.boxed;
    }

    public LatLng asGeoPoint() {
        return (LatLng)this.boxed;
    }

    public ImmutableList<JndexValue> asArray() {
        return (ImmutableList)this.boxed;
    }

    public ImmutableMap<JndexValue, JndexValue> asMap() {
        return (ImmutableMap)this.boxed;
    }

    public Value.LegacyUser asLegacyUser() {
        return (Value.LegacyUser)this.boxed;
    }

    @VisibleForTesting
    public JndexValue truncate() {
        Preconditions.checkState(!this.isDeepTruncated());
        switch (this.type) {
            case STRING: {
                return JndexValue.createString(true, this.asString());
            }
            case BYTES: {
                return JndexValue.createBytes(true, this.asBytes());
            }
            case ARRAY: {
                ImmutableList<JndexValue> array = this.asArray();
                Preconditions.checkState(!array.isEmpty());
                return JndexValue.createArray(true, array);
            }
            case MAP: {
                ImmutableMap<JndexValue, JndexValue> map = this.asMap();
                Preconditions.checkState(!map.isEmpty());
                return JndexValue.createMap(true, map);
            }
            case ENTITY_REF: {
                EntityRef entityRef = this.asEntityRef();
                JndexValue truncatedSegments = entityRef.segments.asArray().isEmpty() ? ABSENT : entityRef.segments.truncate();
                EntityRef truncatedEntityRef = new EntityRef(entityRef.projectId, entityRef.databaseId, entityRef.namespaceId, truncatedSegments);
                return JndexValue.createEntityRef(truncatedEntityRef);
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof JndexValue)) {
            return false;
        }
        JndexValue other = (JndexValue)otherObject;
        return (this.xjProto == null || other.xjProto == null || this.xjProto.equals(other.xjProto)) && this.type == other.type && this.isDeepTruncated == other.isDeepTruncated && this.isShallowTruncated == other.isShallowTruncated && this.isNumberDouble == other.isNumberDouble && this.unboxed == other.unboxed && this.boxed.equals(other.boxed);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.xjProto, this.isDeepTruncated, this.isShallowTruncated, this.type, this.isNumberDouble, this.unboxed, this.boxed});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{JndexValue: ");
        if (this.type != null) {
            switch (this.type) {
                case ABSENT_TYPE: {
                    return "<absent>";
                }
                case NULL: {
                    stringBuilder.append("null");
                    break;
                }
                case BOOLEAN: {
                    stringBuilder.append(this.asBoolean());
                    break;
                }
                case NUMBER: {
                    if (this.isNumberDouble) {
                        stringBuilder.append(this.asNumberDouble());
                        break;
                    }
                    stringBuilder.append(this.asNumberLong());
                    break;
                }
                case TIMESTAMP: {
                    stringBuilder.append(this.asTimestamp());
                    break;
                }
                case ENTITY_REF: {
                    stringBuilder.append(this.asEntityRef());
                    break;
                }
                case STRING: {
                    stringBuilder.append(this.asString());
                    break;
                }
                case BYTES: {
                    stringBuilder.append(this.asBytes());
                    break;
                }
                case GEO_POINT: {
                    stringBuilder.append(this.asGeoPoint());
                    break;
                }
                case ARRAY: {
                    stringBuilder.append(this.asArray());
                    break;
                }
                case MAP: {
                    stringBuilder.append(this.asMap());
                    break;
                }
                case LEGACY_USER: {
                    stringBuilder.append(this.asLegacyUser());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown index value type.");
                }
            }
        }
        if (this.isShallowTruncated) {
            stringBuilder.append(" (truncated)");
        }
        if (this.xjProto != null) {
            stringBuilder.append(" xjProto: ");
            stringBuilder.append(this.xjProto.toString());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static class EntityRef {
        public static final EntityRef EMPTY = new EntityRef(EMPTY_STRING, EMPTY_STRING, EMPTY_STRING, EMPTY_ARRAY);
        public final JndexValue projectId;
        public final JndexValue databaseId;
        public final JndexValue namespaceId;
        public final JndexValue segments;

        public EntityRef(JndexValue projectId, JndexValue databaseId, JndexValue namespaceId, JndexValue segments) {
            Preconditions.checkNotNull(projectId);
            Preconditions.checkNotNull(databaseId);
            Preconditions.checkArgument(!projectId.isShallowTruncated());
            Preconditions.checkArgument(!databaseId.isShallowTruncated());
            if (segments != ABSENT) {
                Preconditions.checkArgument(!namespaceId.isShallowTruncated());
                EntityRef.checkSegments(segments);
            }
            this.projectId = projectId;
            this.databaseId = databaseId;
            this.namespaceId = namespaceId;
            this.segments = segments;
        }

        private static void checkSegments(JndexValue segments) {
            Preconditions.checkArgument(segments.type() == Type.ARRAY);
            ImmutableList<JndexValue> segmentsList = segments.asArray();
            int numSegments = segmentsList.size();
            block4: for (int index = 0; index < numSegments; ++index) {
                JndexValue segment = (JndexValue)segmentsList.get(index);
                switch (segment.type()) {
                    case NUMBER: {
                        Preconditions.checkArgument(index % 2 == 1);
                        Preconditions.checkArgument(!segment.isNumberDouble());
                        continue block4;
                    }
                    case STRING: {
                        if (!segment.isShallowTruncated()) continue block4;
                        Preconditions.checkArgument(index == numSegments - 1);
                        Preconditions.checkArgument(!segments.isShallowTruncated());
                        continue block4;
                    }
                    default: {
                        Preconditions.checkArgument(false);
                    }
                }
            }
        }

        @Nullable
        public JndexValue collectionId() {
            if (this.segments.type() != Type.ARRAY) {
                return null;
            }
            ImmutableList<JndexValue> segmentsList = this.segments.asArray();
            if (segmentsList.isEmpty()) {
                return null;
            }
            int collectionIdIndex = segmentsList.size() - 1 & 0xFFFFFFFE;
            return (JndexValue)segmentsList.get(collectionIdIndex);
        }

        public EntityRef parent() {
            Preconditions.checkArgument(!this.namespaceId.isDeepTruncated());
            Preconditions.checkArgument(!this.segments.isDeepTruncated());
            ImmutableList<JndexValue> segmentsList = this.segments.asArray();
            int numSegments = segmentsList.size();
            Preconditions.checkArgument(numSegments % 2 == 0);
            int numParentSegments = numSegments - 2;
            Preconditions.checkArgument(numParentSegments >= 0);
            JndexValue parentSegments = numParentSegments == 0 ? EMPTY_ARRAY : JndexValue.createArray(false, (ImmutableList<JndexValue>)segmentsList.subList(0, numParentSegments));
            return new EntityRef(this.projectId, this.databaseId, this.namespaceId, parentSegments);
        }

        public boolean equals(Object otherObject) {
            if (!(otherObject instanceof EntityRef)) {
                return false;
            }
            EntityRef other = (EntityRef)otherObject;
            return this.projectId.equals(other.projectId) && this.databaseId.equals(other.databaseId) && this.namespaceId.equals(other.namespaceId) && this.segments.equals(other.segments);
        }

        public int hashCode() {
            return Objects.hashCode(this.projectId, this.databaseId, this.namespaceId, this.segments);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("index-entity-ref: {projectId: ");
            stringBuilder.append(this.projectId);
            stringBuilder.append(", databaseId: ");
            stringBuilder.append(this.databaseId);
            if (this.namespaceId != ABSENT) {
                stringBuilder.append(", namespaceId: ");
                stringBuilder.append(this.namespaceId);
            }
            if (this.segments != ABSENT) {
                stringBuilder.append(", segments: ");
                stringBuilder.append(this.segments);
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
    }

    public static enum Type {
        ABSENT_TYPE,
        NULL,
        BOOLEAN,
        NUMBER,
        TIMESTAMP,
        STRING,
        BYTES,
        ENTITY_REF,
        GEO_POINT,
        ARRAY,
        MAP,
        LEGACY_USER;


        public int firestoreOrderNum() {
            return this.ordinal();
        }
    }
}

