/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_ListRequest;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.common.base.Preconditions;

@AutoValue
public abstract class ListRequest {
    public abstract DatabaseRef databaseRef();

    public abstract String filter();

    public abstract int pageSize();

    public abstract String pageToken();

    public static Builder builder() {
        return new AutoValue_ListRequest.Builder().filter("").pageSize(0).pageToken("");
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder databaseRef(DatabaseRef var1);

        public abstract Builder filter(String var1);

        public abstract Builder pageSize(int var1);

        public abstract Builder pageToken(String var1);

        abstract ListRequest autoBuild();

        public ListRequest build() {
            ListRequest rep = this.autoBuild();
            Preconditions.checkState(rep.databaseRef().hasAppPartition(), "DatabaseRef must have a fully resolved app ID.");
            return rep;
        }
    }
}

