/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.$AutoValue_Mutation;
import com.google.cloud.datastore.core.rep.EntityMetadata;
import com.google.cloud.datastore.core.rep.EntityTransformation;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.cloud.datastore.core.rep.V3Paths;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import javax.annotation.Nullable;

@AutoValue
public abstract class Mutation {
    private boolean autoIdInserted = false;

    public abstract boolean allocateKey();

    public abstract Op op();

    protected abstract List<Mutation> subMutationsInternal();

    public List<Mutation> subMutations() {
        if (this.subMutationsInternal().isEmpty()) {
            return ImmutableList.of(this);
        }
        return this.subMutationsInternal();
    }

    @Nullable
    public abstract OnestoreEntity.EntityProto entity();

    @Nullable
    public abstract EntityMetadata entityMetadata();

    @Nullable
    public abstract PropertyMask writePropertyMask();

    @Nullable
    public abstract PropertyMask readPropertyMask();

    @Nullable
    public abstract EntityTransformation transformation();

    public abstract boolean transformationOnly();

    public abstract OnestoreEntity.Reference key();

    public boolean ignoresExistingEntityData() {
        PropertyMask mask = this.writePropertyMask();
        return (mask == null || mask.equals(PropertyMask.FULL)) && this.transformation() == null;
    }

    @Nullable
    public abstract Long baseVersion();

    @Nullable
    public abstract ConflictResolutionStrategy conflictResolutionStrategy();

    public abstract boolean recreateEntity();

    public void setAutoIdInserted() {
        this.autoIdInserted = true;
    }

    public boolean autoIdInserted() {
        return this.autoIdInserted;
    }

    public boolean isDelete() {
        return this.op().isDelete();
    }

    public boolean hasConflictDetection() {
        return this.baseVersion() != null;
    }

    public boolean conflictsWith(long serverVersion) {
        return this.baseVersion() != null && this.baseVersion() != serverVersion;
    }

    abstract Builder toBuilder();

    public static Builder builder() {
        return new $AutoValue_Mutation.Builder().allocateKey(false).recreateEntity(false).transformationOnly(false).subMutationsInternal(ImmutableList.of());
    }

    public static Builder insert(OnestoreEntity.EntityProto entity) {
        return Mutation.builder().op(Op.INSERT).entityAndFullMask(entity);
    }

    public static Builder update(OnestoreEntity.EntityProto entity) {
        return Mutation.builder().op(Op.UPDATE).entityAndFullMask(entity);
    }

    public static Builder upsert(OnestoreEntity.EntityProto entity) {
        return Mutation.builder().op(Op.UPSERT).entityAndFullMask(entity);
    }

    public static Builder delete(OnestoreEntity.Reference key) {
        return Mutation.builder().op(Op.DELETE).key(key);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract Builder allocateKey(boolean var1);

        public abstract Builder op(Op var1);

        public abstract Builder subMutationsInternal(List<Mutation> var1);

        public abstract Builder entity(@Nullable OnestoreEntity.EntityProto var1);

        public abstract Builder entityMetadata(EntityMetadata var1);

        public abstract Builder writePropertyMask(@Nullable PropertyMask var1);

        public abstract Builder readPropertyMask(@Nullable PropertyMask var1);

        public abstract Builder transformationOnly(boolean var1);

        public abstract Builder transformation(@Nullable EntityTransformation var1);

        public abstract Builder key(OnestoreEntity.Reference var1);

        public abstract Builder baseVersion(@Nullable Long var1);

        public abstract Builder conflictResolutionStrategy(@Nullable ConflictResolutionStrategy var1);

        public abstract Builder recreateEntity(boolean var1);

        public Builder entityAndFullMask(OnestoreEntity.EntityProto entity) {
            return this.key(entity.getKey()).entity(entity).writePropertyMask(PropertyMask.FULL);
        }

        abstract Mutation autoBuild();

        public Mutation build() {
            Mutation mutation = this.autoBuild();
            if (mutation.op().isDelete()) {
                Preconditions.checkArgument(mutation.transformation() == null, "Transformation cannot be set for delete.");
                Preconditions.checkArgument(!mutation.recreateEntity(), "Cannot recreate entity for delete.");
            }
            Builder.checkNullIff(mutation.entity(), mutation.op().isDelete(), "Entity should be set IFF op is not delete.");
            Builder.checkNullIff(mutation.writePropertyMask(), mutation.entity() == null, "WritePropertyMask should be set IFF entity is set.");
            Builder.checkNullIff((Object)mutation.conflictResolutionStrategy(), mutation.baseVersion() == null, "ConflictResolutionStrategy should be set IFF baseVersion is set.");
            Preconditions.checkArgument(mutation.entity() != null || mutation.readPropertyMask() == null, "readPropertyMask should be set only if entity is set.");
            Preconditions.checkArgument(mutation.entity() != null || mutation.entityMetadata() == null, "EntityMetadata should be set only if entity is set.");
            Preconditions.checkArgument(mutation.entityMetadata() == null || mutation.baseVersion() == null, "Base version cannot be used together with entityMetadata.");
            if (mutation.entity() != null) {
                Preconditions.checkArgument(mutation.writePropertyMask().hasKey());
                Preconditions.checkArgument(mutation.readPropertyMask() == null || mutation.readPropertyMask().hasKey());
                if (V3Paths.hasIncompleteLastElement(mutation.key())) {
                    Preconditions.checkArgument(mutation.op() != Op.UPDATE, "Key cannot have incomplete last element path for update.");
                    mutation = mutation.toBuilder().op(Op.INSERT).allocateKey(true).autoBuild();
                }
                if (!PropertyMask.FULL.equals(mutation.writePropertyMask())) {
                    mutation = mutation.toBuilder().entity(mutation.writePropertyMask().mask(mutation.entity())).autoBuild();
                }
            }
            return mutation;
        }

        private static void checkNullIff(@Nullable Object maybeNull, boolean state, String message) {
            Preconditions.checkArgument(maybeNull == null == state, message);
        }
    }

    public static enum ConflictResolutionStrategy {
        SERVER_VALUE,
        CLIENT_VALUE,
        FAIL;

    }

    public static enum Op {
        INSERT(false),
        UPDATE(false),
        UPSERT(false),
        DELETE(true),
        DELETE_MUST_EXIST(true),
        DELETE_MUST_NOT_EXIST(true);

        private final boolean isDelete;

        private Op(boolean isDelete) {
            this.isDelete = isDelete;
        }

        public boolean isDelete() {
            return this.isDelete;
        }
    }
}

