/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.EntityTransformation;
import com.google.cloud.datastore.core.rep.Mutation;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.cloud.datastore.core.rep.V3Paths;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableTable;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class MutationHelper {
    private static final ImmutableTable<Mutation.Op, Mutation.Op, Mutation.Op> OPERATION_COLLAPSES;

    public static Mutation collapse(Mutation mutation1, Mutation mutation2) throws InvalidConversionException {
        Mutation.Op op1 = mutation1.op();
        Mutation.Op op2 = mutation2.op();
        OnestoreEntity.Reference key1 = mutation1.key();
        OnestoreEntity.Reference key2 = mutation2.key();
        List<Mutation> subMutations1 = mutation1.subMutations();
        List<Mutation> subMutations2 = mutation2.subMutations();
        ArrayList<Mutation> newSubMutations = new ArrayList<Mutation>();
        newSubMutations.addAll(subMutations1);
        newSubMutations.addAll(subMutations2);
        EntityTransformation entityTransformation1 = mutation1.transformation();
        EntityTransformation entityTransformation2 = mutation2.transformation();
        Long baseVersion1 = mutation1.baseVersion();
        Long baseVersion2 = mutation2.baseVersion();
        Mutation.ConflictResolutionStrategy resolutionStrategy1 = mutation1.conflictResolutionStrategy();
        Mutation.ConflictResolutionStrategy resolutionStrategy2 = mutation2.conflictResolutionStrategy();
        Preconditions.checkArgument(!V3Paths.hasIncompleteLastElement(key1), "cannot collapse mutation with incomplete key");
        Preconditions.checkArgument(!V3Paths.hasIncompleteLastElement(key2), "cannot collapse mutation with incomplete key");
        Preconditions.checkArgument(key1.equals(key2), "cannot collapse mutations with different keys");
        Preconditions.checkArgument(op2 != Mutation.Op.DELETE_MUST_EXIST && op2 != Mutation.Op.DELETE_MUST_NOT_EXIST, "second mutation cannot be of type: %s", (Object)op2);
        EntityTransformation newEntityTransformation = mutation2.transformation();
        if (entityTransformation1 != null) {
            if (entityTransformation2 == null) {
                newEntityTransformation = mutation1.transformation();
            } else {
                ImmutableList.Builder newTransformations = ImmutableList.builder();
                newTransformations.addAll(mutation1.transformation().propertyTransformations());
                newTransformations.addAll(mutation2.transformation().propertyTransformations());
                newEntityTransformation = EntityTransformation.create((ImmutableList<EntityTransformation.PropertyTransformation>)newTransformations.build());
            }
        }
        InvalidConversionException.checkConversion(mutation1.entityMetadata() == null, "Cannot collapse mutation with metadata", new Object[0]);
        InvalidConversionException.checkConversion(mutation2.entityMetadata() == null, "Cannot collapse mutation with metadata", new Object[0]);
        Mutation.Op collapsedOp = (Mutation.Op)((Object)OPERATION_COLLAPSES.get((Object)op1, (Object)op2));
        InvalidConversionException.checkConversion(collapsedOp != null, "Cannot %s then %s an entity in the same request.", MutationHelper.opNameForErrorMessage(mutation1), MutationHelper.opNameForErrorMessage(mutation2));
        InvalidConversionException.checkConversion(baseVersion2 == null || Objects.equals(baseVersion1, baseVersion2), "Cannot collapse mutations with different base versions (%s and %s)", baseVersion1, baseVersion2);
        InvalidConversionException.checkConversion(resolutionStrategy2 == null || resolutionStrategy1 == resolutionStrategy2, "Cannot collapse mutations with different resolution strategies (%s and %s)", new Object[]{resolutionStrategy1, resolutionStrategy2});
        if (collapsedOp.isDelete()) {
            return Mutation.builder().op(collapsedOp).key(key2).subMutationsInternal(newSubMutations).baseVersion(baseVersion1).conflictResolutionStrategy(resolutionStrategy1).build();
        }
        OnestoreEntity.EntityProto entity = mutation2.entity();
        PropertyMask writeMask = mutation2.writePropertyMask();
        PropertyMask readMask = mutation2.readPropertyMask();
        Mutation.Builder mutationBuilder = Mutation.builder().op(collapsedOp).key(entity.getKey()).subMutationsInternal(newSubMutations).readPropertyMask(readMask).transformation(newEntityTransformation).transformationOnly(mutation1.transformationOnly() && mutation2.transformationOnly()).baseVersion(baseVersion1).conflictResolutionStrategy(resolutionStrategy1);
        if (!mutation1.isDelete()) {
            InvalidConversionException.checkConversion(Objects.equals(readMask, mutation1.readPropertyMask()), "Cannot collapse mutations with different read mask.", new Object[0]);
            mutationBuilder.entity(writeMask.maskInto(entity, mutation1.entity())).writePropertyMask(writeMask.merge(mutation1.writePropertyMask())).recreateEntity(mutation1.recreateEntity());
        } else {
            mutationBuilder.entity(writeMask.mask(entity)).writePropertyMask(PropertyMask.FULL).recreateEntity(true);
        }
        return mutationBuilder.build();
    }

    private static String opNameForErrorMessage(Mutation mutation) {
        Mutation.Op opForErrorMessage = mutation.op();
        if (mutation.isDelete()) {
            opForErrorMessage = Mutation.Op.DELETE;
        }
        return opForErrorMessage.name().toLowerCase();
    }

    static {
        ImmutableTable.Builder<Mutation.Op, Mutation.Op, Mutation.Op> collapses = ImmutableTable.builder();
        collapses.put(Mutation.Op.INSERT, Mutation.Op.UPDATE, Mutation.Op.INSERT);
        collapses.put(Mutation.Op.INSERT, Mutation.Op.UPSERT, Mutation.Op.INSERT);
        collapses.put(Mutation.Op.INSERT, Mutation.Op.DELETE, Mutation.Op.DELETE_MUST_NOT_EXIST);
        collapses.put(Mutation.Op.UPDATE, Mutation.Op.UPDATE, Mutation.Op.UPDATE);
        collapses.put(Mutation.Op.UPDATE, Mutation.Op.UPSERT, Mutation.Op.UPDATE);
        collapses.put(Mutation.Op.UPDATE, Mutation.Op.DELETE, Mutation.Op.DELETE_MUST_EXIST);
        collapses.put(Mutation.Op.UPSERT, Mutation.Op.UPDATE, Mutation.Op.UPSERT);
        collapses.put(Mutation.Op.UPSERT, Mutation.Op.UPSERT, Mutation.Op.UPSERT);
        collapses.put(Mutation.Op.UPSERT, Mutation.Op.DELETE, Mutation.Op.DELETE);
        collapses.put(Mutation.Op.DELETE, Mutation.Op.INSERT, Mutation.Op.UPSERT);
        collapses.put(Mutation.Op.DELETE, Mutation.Op.UPSERT, Mutation.Op.UPSERT);
        collapses.put(Mutation.Op.DELETE, Mutation.Op.DELETE, Mutation.Op.DELETE);
        collapses.put(Mutation.Op.DELETE_MUST_EXIST, Mutation.Op.INSERT, Mutation.Op.UPDATE);
        collapses.put(Mutation.Op.DELETE_MUST_EXIST, Mutation.Op.UPSERT, Mutation.Op.UPDATE);
        collapses.put(Mutation.Op.DELETE_MUST_EXIST, Mutation.Op.DELETE, Mutation.Op.DELETE_MUST_EXIST);
        collapses.put(Mutation.Op.DELETE_MUST_NOT_EXIST, Mutation.Op.INSERT, Mutation.Op.INSERT);
        collapses.put(Mutation.Op.DELETE_MUST_NOT_EXIST, Mutation.Op.UPSERT, Mutation.Op.INSERT);
        collapses.put(Mutation.Op.DELETE_MUST_NOT_EXIST, Mutation.Op.DELETE, Mutation.Op.DELETE_MUST_NOT_EXIST);
        OPERATION_COLLAPSES = collapses.build();
    }
}

