/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_PartitionRef;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.ResourceRef;
import com.google.storage.onestore.v3.OnestoreEntity;

@AutoValue
public abstract class PartitionRef
implements ResourceRef {
    public static final PartitionRef EMPTY = PartitionRef.createFromDatabaseRef(DatabaseRef.EMPTY);
    private static final String DEFAULT_NAMESPACE = "";

    public static PartitionRef createFromDatabaseRef(DatabaseRef databaseRef) {
        return PartitionRef.createFromDatabaseRefAndNamespace(databaseRef, DEFAULT_NAMESPACE);
    }

    public static PartitionRef createFromDatabaseRefAndNamespace(DatabaseRef databaseRef, String namespace) {
        return new AutoValue_PartitionRef(databaseRef, namespace);
    }

    public static PartitionRef createFromReference(OnestoreEntity.Reference reference) {
        return new AutoValue_PartitionRef(DatabaseRef.createForApp(reference.getApp(), reference.getDatabaseId()), reference.getNameSpace());
    }

    public abstract DatabaseRef databaseRef();

    public abstract String namespace();

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.databaseRef().toString());
        if (!this.namespace().isEmpty()) {
            builder.append('!');
            builder.append(this.namespace());
        }
        return builder.toString();
    }

    public boolean isEntireDatabase() {
        return this.namespace().equals("__all__");
    }
}

