/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.common.DatastoreCoreConfig;
import com.google.cloud.datastore.core.names.Names;
import com.google.cloud.datastore.core.rep.AutoValue_PropertyName_ByteArrayWrapper;
import com.google.cloud.datastore.core.rep.SpecialPropertyDescriptor;
import com.google.common.base.Preconditions;
import com.google.common.base.Utf8;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedBytes;
import com.google.protobuf.ByteString;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import javax.annotation.Nullable;

public class PropertyName
implements Comparable<PropertyName> {
    private static final Comparator<byte[]> UTF8_BYTE_COMPARATOR = UnsignedBytes.lexicographicalComparator();
    private static final ImmutableMap<ByteArrayWrapper, SpecialPropertyName> NAME_TO_SPECIAL_PROPERTY_NAME_MAP = PropertyName.makeNameToSpecialPropertyNameMap();
    public static final PropertyName KEY = PropertyName.fromUtf8(SpecialPropertyDescriptor.KEY.asString());
    private final byte[] nameAsByteArray;
    private final String name;

    private static ImmutableMap<ByteArrayWrapper, SpecialPropertyName> makeNameToSpecialPropertyNameMap() {
        HashMap<ByteArrayWrapper, SpecialPropertyName> map = new HashMap<ByteArrayWrapper, SpecialPropertyName>();
        for (SpecialPropertyDescriptor special : SpecialPropertyDescriptor.values()) {
            if (special == SpecialPropertyDescriptor.NOT_SPECIAL) continue;
            String propertyName = special.asString();
            byte[] propertyNameAsByteArray = ByteString.copyFromUtf8(propertyName).toByteArray();
            SpecialPropertyName previousName = map.put(ByteArrayWrapper.create(propertyNameAsByteArray), new SpecialPropertyName(special, propertyNameAsByteArray, propertyName));
            Preconditions.checkState(previousName == null, "duplicate special property name");
        }
        return ImmutableMap.copyOf(map);
    }

    public static PropertyName fromUtf8(String name) {
        return PropertyName.create(name.getBytes(StandardCharsets.UTF_8), name);
    }

    public static PropertyName from(byte[] nameAsByteArray) {
        Preconditions.checkArgument(!DatastoreCoreConfig.constructionRequiresUtf8PropertyName || Utf8.isWellFormed(nameAsByteArray));
        return PropertyName.create(nameAsByteArray, new String(nameAsByteArray, StandardCharsets.UTF_8));
    }

    static PropertyName fromByteArrayAndUtf8(byte[] nameAsByteArray, String name) {
        return PropertyName.create(nameAsByteArray, name);
    }

    private static PropertyName create(byte[] nameAsByteArray, String name) {
        PropertyName specialPropertyName = PropertyName.specialLookup(nameAsByteArray);
        if (specialPropertyName != null) {
            return specialPropertyName;
        }
        return new PropertyName(nameAsByteArray, name);
    }

    @Nullable
    private static PropertyName specialLookup(byte[] nameAsByteArray) {
        if (!Names.isNameReserved(nameAsByteArray)) {
            return null;
        }
        SpecialPropertyName specialPropertyName = NAME_TO_SPECIAL_PROPERTY_NAME_MAP.get(ByteArrayWrapper.create(nameAsByteArray));
        if (specialPropertyName == null) {
            return null;
        }
        return specialPropertyName;
    }

    private PropertyName(byte[] nameAsByteArray, String name) {
        this.nameAsByteArray = nameAsByteArray;
        this.name = name;
    }

    public byte[] bytes() {
        return this.nameAsByteArray;
    }

    public String string() {
        return this.name;
    }

    public SpecialPropertyDescriptor special() {
        return SpecialPropertyDescriptor.NOT_SPECIAL;
    }

    public boolean isKey() {
        return this.special() == SpecialPropertyDescriptor.KEY;
    }

    public boolean isReserved() {
        return Names.isNameReserved(this.bytes());
    }

    @Override
    public int compareTo(PropertyName other) {
        return UTF8_BYTE_COMPARATOR.compare(this.nameAsByteArray, other.nameAsByteArray);
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof PropertyName)) {
            return false;
        }
        PropertyName other = (PropertyName)otherObject;
        return Arrays.equals(this.nameAsByteArray, other.nameAsByteArray);
    }

    public int hashCode() {
        return Arrays.hashCode(this.nameAsByteArray);
    }

    public String toString() {
        return this.string();
    }

    @AutoValue
    public static abstract class ByteArrayWrapper {
        public static ByteArrayWrapper create(byte[] bytes) {
            return new AutoValue_PropertyName_ByteArrayWrapper(bytes);
        }

        public abstract byte[] bytes();
    }

    private static class SpecialPropertyName
    extends PropertyName {
        private final SpecialPropertyDescriptor descriptor;

        public SpecialPropertyName(SpecialPropertyDescriptor descriptor, byte[] nameAsByteArray, String name) {
            super(nameAsByteArray, name);
            this.descriptor = descriptor;
        }

        @Override
        public SpecialPropertyDescriptor special() {
            return this.descriptor;
        }
    }
}

