/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.common.DatastoreCoreConfig;
import com.google.cloud.datastore.core.rep.PropertyName;
import com.google.cloud.datastore.core.rep.PropertyPathSegment;
import com.google.cloud.datastore.core.rep.SpecialPropertyDescriptor;
import com.google.cloud.datastore.core.rep.Value;
import com.google.common.base.Preconditions;
import com.google.common.base.Utf8;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nullable;

public class PropertyPath
implements Comparable<PropertyPath> {
    public static final PropertyPath KEY = PropertyPath.createFromMemberName(SpecialPropertyDescriptor.KEY.asString());
    public static final PropertyPath KIND = PropertyPath.createFromMemberName(SpecialPropertyDescriptor.KIND.asString());
    public static final PropertyPath SCATTER = PropertyPath.createFromMemberName(SpecialPropertyDescriptor.SCATTER.asString());
    public static final PropertyPath SPLITS = PropertyPath.createFromMemberName(SpecialPropertyDescriptor.SPLITS.asString());
    public static final PropertyPath UNAPPLIED_LOG_TIMESTAMP_US = PropertyPath.createFromMemberName(SpecialPropertyDescriptor.UNAPPLIED_LOG_TIMESTAMP_US.asString());
    private final PropertyPathSegment segment;
    @Nullable
    private final PropertyPath next;
    private final SpecialPropertyDescriptor specialPropertyDescriptor;

    private PropertyPath(PropertyPathSegment segment, @Nullable PropertyPath next) {
        this.segment = Preconditions.checkNotNull(segment);
        this.next = next;
        this.specialPropertyDescriptor = next == null ? segment.special() : SpecialPropertyDescriptor.NOT_SPECIAL;
    }

    public static int compare(@Nullable PropertyPath leftPath, @Nullable PropertyPath rightPath) {
        if (leftPath == null) {
            if (rightPath == null) {
                return 0;
            }
            return -1;
        }
        if (rightPath == null) {
            return 1;
        }
        int segmentComparison = leftPath.segment().compareTo(rightPath.segment());
        if (segmentComparison != 0) {
            return segmentComparison;
        }
        return PropertyPath.compare(leftPath.next(), rightPath.next());
    }

    public static PropertyPath createFromSegments(List<PropertyPathSegment> segments) {
        PropertyPath propertyPath = null;
        for (int index = segments.size() - 1; index >= 0; --index) {
            PropertyPathSegment segment = segments.get(index);
            propertyPath = PropertyPath.create(segment, propertyPath);
        }
        return propertyPath;
    }

    public static PropertyPath createFromMemberName(String name) {
        return PropertyPath.create(PropertyPathSegment.Member.create(PropertyName.fromUtf8(name)), null);
    }

    public static PropertyPath create(PropertyPathSegment segment, @Nullable PropertyPath next) {
        return new PropertyPath(segment, next);
    }

    public static PropertyPath create(@Nullable PropertyPath prefix, PropertyPathSegment segment) {
        if (prefix == null) {
            return PropertyPath.create(segment, null);
        }
        PropertyPath remainder = prefix.next() == null ? PropertyPath.create(segment, null) : PropertyPath.create(prefix.next(), segment);
        return PropertyPath.create(prefix.segment(), remainder);
    }

    public static PropertyPath createFromAmbiguousPathString(String name) {
        return PropertyPath.createFromAmbiguousPathByteArrayAndString(name.getBytes(StandardCharsets.UTF_8), name);
    }

    public static PropertyPath createFromAmbiguousPathByteArray(byte[] nameAsByteArray) {
        Preconditions.checkArgument(!DatastoreCoreConfig.constructionRequiresUtf8PropertyName || Utf8.isWellFormed(nameAsByteArray));
        return PropertyPath.createFromAmbiguousPathByteArrayAndString(nameAsByteArray, new String(nameAsByteArray, StandardCharsets.UTF_8));
    }

    private static PropertyPath createFromAmbiguousPathByteArrayAndString(byte[] nameAsByteArray, String name) {
        PropertyName propertyName = PropertyName.fromByteArrayAndUtf8(nameAsByteArray, name);
        return PropertyPath.create(PropertyPathSegment.Member.create(propertyName), null);
    }

    @Nullable
    public PropertyPath dropLastPathSegment() {
        if (this.next() == null) {
            return null;
        }
        return PropertyPath.create(this.segment(), this.next().dropLastPathSegment());
    }

    public boolean isKey() {
        return this.specialPropertyDescriptor == SpecialPropertyDescriptor.KEY;
    }

    public PropertyPathSegment segment() {
        return this.segment;
    }

    public String memberName() {
        PropertyPathSegment.Member member = (PropertyPathSegment.Member)this.segment();
        return member.name().string();
    }

    public PropertyPathSegment lastSegment() {
        return this.next() == null ? this.segment() : this.next().lastSegment();
    }

    public boolean isArrayElements() {
        return this.lastSegment() instanceof PropertyPathSegment.AllArrayElements;
    }

    @Nullable
    public PropertyPath next() {
        return this.next;
    }

    @Nullable
    Value getFrom(ImmutableList<Value> array) {
        Value subValue = this.segment().getFrom(array);
        if (subValue == null || this.next() == null) {
            return subValue;
        }
        return subValue.get(this.next());
    }

    @Nullable
    Value getFrom(ImmutableMap<String, Value> map) {
        Value subValue = this.segment().getFrom(map);
        if (subValue == null || this.next() == null) {
            return subValue;
        }
        return subValue.get(this.next());
    }

    public SpecialPropertyDescriptor special() {
        return this.specialPropertyDescriptor;
    }

    public PropertyName asPropertyNameWithDelimiterAmbiguity() {
        Preconditions.checkState(this.next() == null);
        Preconditions.checkState(this.segment() instanceof PropertyPathSegment.Member);
        return ((PropertyPathSegment.Member)this.segment()).name();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean isFirst = true;
        for (PropertyPath path = this; path != null; path = path.next()) {
            path.segment().appendAsString(isFirst, stringBuilder);
            isFirst = false;
        }
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(@Nullable PropertyPath other) {
        return PropertyPath.compare(this, other);
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof PropertyPath)) {
            return false;
        }
        PropertyPath otherPropertyPath = (PropertyPath)otherObject;
        return this.compareTo(otherPropertyPath) == 0;
    }

    public int hashCode() {
        int hashCode = this.segment().hashCode();
        if (this.next() != null) {
            hashCode ^= this.next().hashCode();
        }
        return hashCode;
    }

    public String asStringLossy() {
        return this.toString();
    }
}

