/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_ReadResult;
import com.google.cloud.datastore.core.rep.Cursor;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.common.base.Preconditions;
import com.google.storage.onestore.v3.OnestoreEntity;
import javax.annotation.Nullable;

@AutoValue
public abstract class ReadResult {
    public static ReadResult create(@Nullable OnestoreEntity.EntityProto entity, @Nullable Cursor cursor, long createVersion, long updateVersion) {
        return ReadResult.create(entity, cursor, createVersion, updateVersion, null);
    }

    public static ReadResult create(@Nullable OnestoreEntity.EntityProto entity, @Nullable Cursor cursor, long createVersion, long updateVersion, @Nullable Long readTimestamp) {
        return ReadResult.builder().entity(entity).reference(entity != null ? entity.getKey() : null).cursor(cursor).createVersion(createVersion).updateVersion(updateVersion).readTimestamp(readTimestamp).build();
    }

    public static ReadResult createNoVersion(@Nullable OnestoreEntity.EntityProto entity, @Nullable Cursor cursor) {
        return ReadResult.create(entity, cursor, -1L, -1L);
    }

    public static ReadResult createMissing(OnestoreEntity.Reference reference, long version) {
        return ReadResult.createMissing(reference, version, null);
    }

    public static ReadResult createMissing(OnestoreEntity.Reference reference, long version, @Nullable Long readTimestamp) {
        return ReadResult.builder().reference(reference).missingEntityReason(MissingEntityReason.MISSING).createVersion(-1L).updateVersion(version).readTimestamp(readTimestamp).build();
    }

    public static ReadResult createMissingNoVersion(OnestoreEntity.Reference reference) {
        return ReadResult.createMissing(reference, -1L);
    }

    public static ReadResult createMissingNoVersion(OnestoreEntity.Reference reference, Long readTime) {
        return ReadResult.createMissing(reference, -1L, readTime);
    }

    public static ReadResult createDeferred(OnestoreEntity.Reference reference) {
        return ReadResult.builder().reference(reference).createVersion(-1L).updateVersion(-1L).missingEntityReason(MissingEntityReason.DEFERRED).build();
    }

    public ReadResult withMask(PropertyMask propertyMask) {
        Preconditions.checkState(this.exists());
        if (propertyMask.equals(PropertyMask.FULL)) {
            return this;
        }
        return this.withEntity(propertyMask.mask(this.entity()));
    }

    public ReadResult withEntity(OnestoreEntity.EntityProto entity) {
        return this.toBuilder().entity(entity).build();
    }

    public ReadResult withUpdateVersion(long updateVersion) {
        return ReadResult.create(this.entity(), this.cursor(), this.createVersion() == -1L ? updateVersion : this.createVersion(), updateVersion);
    }

    @Nullable
    public abstract OnestoreEntity.Reference reference();

    @Nullable
    public abstract OnestoreEntity.EntityProto entity();

    public boolean exists() {
        return this.entity() != null;
    }

    @Nullable
    public abstract MissingEntityReason missingEntityReason();

    public abstract long createVersion();

    public abstract long updateVersion();

    @Nullable
    public abstract Long readTimestamp();

    @Nullable
    public abstract Cursor cursor();

    static Builder builder() {
        return new AutoValue_ReadResult.Builder();
    }

    abstract Builder toBuilder();

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        public abstract ReadResult build();

        public abstract Builder reference(@Nullable OnestoreEntity.Reference var1);

        public abstract Builder entity(@Nullable OnestoreEntity.EntityProto var1);

        public abstract Builder missingEntityReason(@Nullable MissingEntityReason var1);

        public abstract Builder createVersion(long var1);

        public abstract Builder updateVersion(long var1);

        public abstract Builder readTimestamp(@Nullable Long var1);

        public abstract Builder cursor(@Nullable Cursor var1);
    }

    public static enum MissingEntityReason {
        MISSING,
        DEFERRED;

    }
}

