/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_SingleFieldIndexingConfiguration;
import com.google.cloud.datastore.core.rep.SingleFieldIndex;
import com.google.cloud.datastore.core.rep.SingleFieldIndexingRule;
import com.google.cloud.datastore.core.rep.SingleFieldRef;
import com.google.cloud.datastore.core.rep.WorkflowState;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nullable;

@AutoValue
public abstract class SingleFieldIndexingConfiguration {
    public static final SingleFieldIndexingConfiguration EMPTY = SingleFieldIndexingConfiguration.create(ImmutableList.of(SingleFieldIndexingRule.EMPTY_DATABASE_RULE));

    public abstract ImmutableMap<SingleFieldRef, SingleFieldIndexingRule> rules();

    public SingleFieldIndexingRule databaseDefaults() {
        return this.rules().get(SingleFieldRef.database());
    }

    public ImmutableMultimap<String, SingleFieldIndexingRule> kindRules() {
        ImmutableMultimap.Builder<String, SingleFieldIndexingRule> kinds = ImmutableMultimap.builder();
        for (SingleFieldIndexingRule rule : this.rules().values()) {
            if (rule.ref().kind() == null) continue;
            kinds.put(rule.ref().kind(), rule);
        }
        return kinds.build();
    }

    public SingleFieldIndexingRule generatingRule(SingleFieldRef ref) {
        SingleFieldIndexingRule rule = null;
        while (rule == null || rule.state() == WorkflowState.DELETED) {
            rule = this.rules().get(ref);
            ref = ref.parent();
        }
        return rule;
    }

    public static SingleFieldIndexingConfiguration createWithDatabaseRule(ImmutableMap<SingleFieldIndex.Mode, WorkflowState> indexes, @Nullable Long updateTimeMicros) {
        return SingleFieldIndexingConfiguration.create(ImmutableList.of(SingleFieldIndexingRule.createDatabaseRule(indexes, updateTimeMicros)));
    }

    public static SingleFieldIndexingConfiguration create(Iterable<SingleFieldIndexingRule> rules) {
        ImmutableMap.Builder<SingleFieldRef, SingleFieldIndexingRule> ruleMapBuilder = ImmutableMap.builder();
        for (SingleFieldIndexingRule rule : rules) {
            ruleMapBuilder.put(rule.ref(), rule);
        }
        ImmutableMap<SingleFieldRef, SingleFieldIndexingRule> ruleMap = ruleMapBuilder.build();
        Preconditions.checkArgument(ruleMap.containsKey(SingleFieldRef.database()));
        return new AutoValue_SingleFieldIndexingConfiguration(ruleMap);
    }

    public SingleFieldIndexingConfiguration updateRule(SingleFieldIndexingRule rule) {
        return this.updateRules(ImmutableList.of(rule));
    }

    public SingleFieldIndexingConfiguration updateRules(Collection<SingleFieldIndexingRule> rules) {
        HashMap<SingleFieldRef, SingleFieldIndexingRule> newRules = new HashMap<SingleFieldRef, SingleFieldIndexingRule>();
        HashSet<SingleFieldRef> deletedRules = new HashSet<SingleFieldRef>();
        for (SingleFieldIndexingRule rule : rules) {
            if (rule.equals(this.rules().get(rule.ref()))) continue;
            if (rule.state() == WorkflowState.DELETED) {
                deletedRules.add(rule.ref());
                continue;
            }
            newRules.put(rule.ref(), rule);
        }
        if (newRules.isEmpty() && deletedRules.isEmpty()) {
            return this;
        }
        for (SingleFieldIndexingRule rule : this.rules().values()) {
            if (newRules.containsKey(rule.ref()) || deletedRules.contains(rule.ref())) continue;
            newRules.put(rule.ref(), rule);
        }
        return new AutoValue_SingleFieldIndexingConfiguration(ImmutableMap.copyOf(newRules));
    }
}

