/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_SingleFieldRef;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.RepHelper;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

@AutoValue
public abstract class SingleFieldRef {
    private static final SingleFieldRef DATABASE = new AutoValue_SingleFieldRef(null, null);

    @Nullable
    public abstract String kind();

    @Nullable
    public abstract PropertyPath propertyPath();

    public boolean isDatabase() {
        return this.equals(DATABASE);
    }

    public boolean isKind() {
        return !this.isDatabase() && this.propertyPath() == null;
    }

    public static SingleFieldRef database() {
        return SingleFieldRef.of(null, null);
    }

    public static SingleFieldRef of(@Nullable String kind, @Nullable PropertyPath propertyPath) {
        Preconditions.checkArgument(kind != null || propertyPath == null, "if a propertyPath is specified, the kind must be specified as well");
        Preconditions.checkArgument(propertyPath == null || RepHelper.isTrivialPropertyPath(propertyPath), "only trivial paths are allowed in SFI property paths");
        if (kind == null && propertyPath == null) {
            return DATABASE;
        }
        return new AutoValue_SingleFieldRef(kind, propertyPath);
    }

    @Nullable
    public SingleFieldRef parent() {
        if (this.propertyPath() == null) {
            return this.kind() == null ? null : SingleFieldRef.database();
        }
        return SingleFieldRef.of(this.kind(), this.propertyPath().dropLastPathSegment());
    }
}

