/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.rep.BaseJndexValueComparator;
import com.google.cloud.datastore.core.rep.JndexValue;
import com.google.protobuf.util.Timestamps;
import javax.annotation.Nullable;

public class TotalIndexValueComparator
extends BaseJndexValueComparator {
    public static final TotalIndexValueComparator INSTANCE = new TotalIndexValueComparator();

    private TotalIndexValueComparator() {
    }

    @Override
    public int compare(@Nullable JndexValue left, @Nullable JndexValue right) {
        if (left == null) {
            if (right == null) {
                return 0;
            }
            return 1;
        }
        if (right == null) {
            return -1;
        }
        JndexValue.Type leftType = left.type();
        int typeComparison = Integer.compare(leftType.ordinal(), right.type().ordinal());
        if (typeComparison != 0) {
            return typeComparison;
        }
        int comparisonWithoutTruncated = 0;
        switch (leftType) {
            case ABSENT_TYPE: 
            case NULL: {
                return 0;
            }
            case BOOLEAN: {
                return Boolean.compare(left.asBoolean(), right.asBoolean());
            }
            case NUMBER: {
                return TotalIndexValueComparator.compareNumber(left, right);
            }
            case TIMESTAMP: {
                return Timestamps.compare(left.asTimestamp(), right.asTimestamp());
            }
            case STRING: {
                comparisonWithoutTruncated = left.asString().compareTo(right.asString());
                break;
            }
            case BYTES: {
                comparisonWithoutTruncated = BYTE_STRING_COMPARATOR.compare(left.asBytes(), right.asBytes());
                break;
            }
            case ENTITY_REF: {
                return this.compareEntityRefWithoutTruncated(left.asEntityRef(), right.asEntityRef());
            }
            case GEO_POINT: {
                return this.compareGeoPoint(left.asGeoPoint(), right.asGeoPoint());
            }
            case ARRAY: {
                comparisonWithoutTruncated = this.compareArrayWithoutTruncated(left.asArray(), right.asArray());
                break;
            }
            case MAP: {
                comparisonWithoutTruncated = this.compareMapWithoutTruncated(left.asMap(), right.asMap());
                break;
            }
            case LEGACY_USER: {
                comparisonWithoutTruncated = this.compareLegacyUserWithoutTruncation(left.asLegacyUser(), right.asLegacyUser());
            }
        }
        if (comparisonWithoutTruncated != 0) {
            return comparisonWithoutTruncated;
        }
        return Boolean.compare(left.isShallowTruncated(), right.isShallowTruncated());
    }

    private static int compareNumber(JndexValue left, JndexValue right) {
        boolean rightIsDouble;
        boolean leftIsDouble = left.isNumberDouble();
        if (leftIsDouble == (rightIsDouble = right.isNumberDouble())) {
            if (leftIsDouble) {
                return Double.compare(left.asNumberDouble(), right.asNumberDouble());
            }
            return Long.compare(left.asNumberLong(), right.asNumberLong());
        }
        if (leftIsDouble) {
            return 1;
        }
        return -1;
    }
}

