/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_TransformationFunctions_AppendMissingElements;
import com.google.cloud.datastore.core.rep.AutoValue_TransformationFunctions_Increment;
import com.google.cloud.datastore.core.rep.AutoValue_TransformationFunctions_Maximum;
import com.google.cloud.datastore.core.rep.AutoValue_TransformationFunctions_Minimum;
import com.google.cloud.datastore.core.rep.AutoValue_TransformationFunctions_RemoveAllFromArray;
import com.google.cloud.datastore.core.rep.AutoValue_TransformationFunctions_SetToConstant;
import com.google.cloud.datastore.core.rep.EntityTransformation;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.ValueOrder;
import com.google.cloud.datastore.core.rep.ValueSet;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.math.LongMath;
import javax.annotation.Nullable;

public class TransformationFunctions {
    public static boolean isValueNumberOrNaN(Value value) {
        return value.type() == Value.Type.LONG || value.type() == Value.Type.DOUBLE;
    }

    private TransformationFunctions() {
    }

    public static Function<Value, EntityTransformation.PropertyTransformationResult> setToConstant(Value operand) {
        return SetToConstant.of(operand);
    }

    public static Function<Value, EntityTransformation.PropertyTransformationResult> increment(Value operand) {
        return Increment.of(operand);
    }

    public static Function<Value, EntityTransformation.PropertyTransformationResult> maximum(ValueOrder order, Value operand) {
        return Maximum.of(order, operand);
    }

    public static Function<Value, EntityTransformation.PropertyTransformationResult> minimum(ValueOrder order, Value operand) {
        return Minimum.of(order, operand);
    }

    public static Function<Value, EntityTransformation.PropertyTransformationResult> appendMissingElements(ValueOrder order, Value operand) {
        return AppendMissingElements.of(order, operand);
    }

    public static Function<Value, EntityTransformation.PropertyTransformationResult> removeAllFromArray(ValueOrder order, Value operand) {
        return RemoveAllFromArray.of(order, operand);
    }

    @AutoValue
    static abstract class RemoveAllFromArray
    extends ArrayTransform {
        RemoveAllFromArray() {
        }

        public static RemoveAllFromArray of(ValueOrder order, Value operand) {
            Preconditions.checkArgument(operand.type() == Value.Type.ARRAY);
            return new AutoValue_TransformationFunctions_RemoveAllFromArray(order, operand);
        }

        @Override
        ImmutableList<Value> transform(ImmutableList<Value> originalValues) {
            ImmutableList.Builder resultBuilder = ImmutableList.builder();
            ValueSet removalSet = this.valueOrder().createValueSet();
            for (Value v : this.values()) {
                removalSet.add(v);
            }
            for (Value existingValue : originalValues) {
                if (removalSet.contains(existingValue)) continue;
                resultBuilder.add(existingValue);
            }
            return resultBuilder.build();
        }
    }

    @AutoValue
    static abstract class AppendMissingElements
    extends ArrayTransform {
        AppendMissingElements() {
        }

        public static AppendMissingElements of(ValueOrder order, Value operand) {
            Preconditions.checkArgument(operand.type() == Value.Type.ARRAY);
            return new AutoValue_TransformationFunctions_AppendMissingElements(order, operand);
        }

        @Override
        ImmutableList<Value> transform(ImmutableList<Value> originalValues) {
            ValueSet valueSet = this.valueOrder().createValueSet();
            for (Value v : originalValues) {
                valueSet.add(v);
            }
            ImmutableList.Builder resultBuilder = ImmutableList.builder();
            resultBuilder.addAll(originalValues);
            for (Value v : this.values()) {
                if (!valueSet.add(v)) continue;
                resultBuilder.add(v);
            }
            return resultBuilder.build();
        }
    }

    static abstract class ArrayTransform
    implements Function<Value, EntityTransformation.PropertyTransformationResult> {
        ArrayTransform() {
        }

        abstract ValueOrder valueOrder();

        abstract Value operand();

        ImmutableList<Value> values() {
            return this.operand().asArray();
        }

        abstract ImmutableList<Value> transform(ImmutableList<Value> var1);

        @Override
        public EntityTransformation.PropertyTransformationResult apply(@Nullable Value propertyValue) {
            Value base = propertyValue == null || propertyValue.type() != Value.Type.ARRAY ? Value.EMPTY_ARRAY.withDatastoreIndexing(this.operand().datastoreIndexing()) : propertyValue;
            ImmutableList<Value> transformedValues = this.transform(base.asArray());
            return EntityTransformation.PropertyTransformationResult.create(Value.createArray(transformedValues).withDatastoreIndexing(base.datastoreIndexing()), Value.NULL);
        }
    }

    @AutoValue
    static abstract class Minimum
    extends Comparison {
        Minimum() {
        }

        public static Minimum of(ValueOrder order, Value operand) {
            Preconditions.checkArgument(TransformationFunctions.isValueNumberOrNaN(operand));
            return new AutoValue_TransformationFunctions_Minimum(order, operand);
        }

        @Override
        protected Value applyComparison(Value propertyValue) {
            Value operand;
            ValueOrder order = this.valueOrder();
            if (order.compare(operand = this.operand(), propertyValue) < 0) {
                return operand;
            }
            return propertyValue;
        }
    }

    @AutoValue
    static abstract class Maximum
    extends Comparison {
        Maximum() {
        }

        public static Maximum of(ValueOrder order, Value operand) {
            Preconditions.checkArgument(TransformationFunctions.isValueNumberOrNaN(operand));
            return new AutoValue_TransformationFunctions_Maximum(order, operand);
        }

        @Override
        protected Value applyComparison(Value propertyValue) {
            Value operand = this.operand();
            if (this.valueOrder().compare(operand, propertyValue) > 0) {
                return operand;
            }
            return propertyValue;
        }
    }

    static abstract class Comparison
    implements Function<Value, EntityTransformation.PropertyTransformationResult> {
        Comparison() {
        }

        abstract ValueOrder valueOrder();

        abstract Value operand();

        protected abstract Value applyComparison(Value var1);

        @Override
        public EntityTransformation.PropertyTransformationResult apply(@Nullable Value propertyValue) {
            return EntityTransformation.PropertyTransformationResult.create(this.newValue(propertyValue));
        }

        @Nullable
        private Value newValue(@Nullable Value propertyValue) {
            if (propertyValue == null || !this.valueOrder().areValuesComparableForRelOp(propertyValue, this.operand()) || this.valueOrder().isValueBottom(this.operand())) {
                return this.operand();
            }
            if (this.valueOrder().isValueBottom(propertyValue)) {
                return propertyValue;
            }
            return this.applyComparison(propertyValue);
        }
    }

    @AutoValue
    static abstract class Increment
    implements Function<Value, EntityTransformation.PropertyTransformationResult> {
        Increment() {
        }

        abstract Value operand();

        public static Increment of(Value operand) {
            Preconditions.checkArgument(TransformationFunctions.isValueNumberOrNaN(operand));
            return new AutoValue_TransformationFunctions_Increment(operand);
        }

        @Override
        public EntityTransformation.PropertyTransformationResult apply(@Nullable Value propertyValue) {
            Value result = this.operand();
            if (propertyValue != null && (propertyValue.type() == Value.Type.LONG || propertyValue.type() == Value.Type.DOUBLE)) {
                result = Increment.add(this.operand(), propertyValue).withDatastoreIndexing(this.operand().datastoreIndexing());
            }
            return EntityTransformation.PropertyTransformationResult.create(result);
        }

        private static Value add(Value v1, Value v2) {
            if (v1.type() == Value.Type.LONG && v2.type() == Value.Type.LONG) {
                long operandAsLong = v1.asLong();
                long propertyValueAsLong = v2.asLong();
                try {
                    long result = LongMath.checkedAdd(propertyValueAsLong, operandAsLong);
                    return Value.createLong(result);
                }
                catch (ArithmeticException e) {
                    if (propertyValueAsLong + operandAsLong < 0L) {
                        return Value.MAX_LONG;
                    }
                    return Value.MIN_LONG;
                }
            }
            return Value.createDouble(Increment.getValueAsDouble(v1) + Increment.getValueAsDouble(v2));
        }

        private static double getValueAsDouble(Value propertyValue) {
            switch (propertyValue.type()) {
                case DOUBLE: {
                    return propertyValue.asDouble();
                }
                case LONG: {
                    return propertyValue.asLong();
                }
            }
            return 0.0;
        }
    }

    @AutoValue
    static abstract class SetToConstant
    implements Function<Value, EntityTransformation.PropertyTransformationResult> {
        SetToConstant() {
        }

        abstract Value operand();

        public static SetToConstant of(Value operand) {
            return new AutoValue_TransformationFunctions_SetToConstant(operand);
        }

        @Override
        public EntityTransformation.PropertyTransformationResult apply(@Nullable Value propertyValue) {
            return EntityTransformation.PropertyTransformationResult.create(this.operand());
        }
    }
}

