/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_UnifiedIndexValue;
import com.google.cloud.datastore.core.rep.DatastoreValue;
import com.google.cloud.datastore.core.rep.JndexValue;
import com.google.common.base.Preconditions;
import com.google.storage.onestore.v3.OnestoreEntity;
import javax.annotation.Nullable;

@AutoValue
public abstract class UnifiedIndexValue {
    public JndexValue firestoreIndexValue() {
        Preconditions.checkState(this.isFirestore());
        return this.internalFirestoreIndexValue();
    }

    public OnestoreEntity.PropertyValue datastoreIndexValue() {
        Preconditions.checkState(this.isDatastore());
        return this.internalDatastoreIndexValue().v3Value();
    }

    @Nullable
    protected abstract JndexValue internalFirestoreIndexValue();

    @Nullable
    protected abstract DatastoreValue internalDatastoreIndexValue();

    public static UnifiedIndexValue create(JndexValue firestoreIndexValue) {
        return new AutoValue_UnifiedIndexValue(firestoreIndexValue, null);
    }

    public static UnifiedIndexValue create(OnestoreEntity.PropertyValue datastoreIndexValue) {
        return new AutoValue_UnifiedIndexValue(null, DatastoreValue.create(datastoreIndexValue));
    }

    public boolean isDatastore() {
        return this.internalDatastoreIndexValue() != null;
    }

    public boolean isFirestore() {
        return this.internalFirestoreIndexValue() != null;
    }

    public final String toString() {
        return (this.isDatastore() ? this.datastoreIndexValue() : this.firestoreIndexValue()).toString();
    }
}

