/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_Value_LegacyUser;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.GeoRegion;
import com.google.cloud.datastore.core.rep.OtherServiceResourceRef;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.RepHelper;
import com.google.cloud.datastore.core.rep.ResourceRef;
import com.google.cloud.datastore.core.rep.ValueRange;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import com.google.protobuf.UnknownFieldSet;
import com.google.storage.onestore.v3.OnestoreEntity;
import com.google.type.LatLng;
import javax.annotation.Nullable;

public class Value {
    private static final Object BOXED_UNUSED = new Object();
    public static final Value NULL = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.NULL, -1L, BOXED_UNUSED, OnestoreEntity.PropertyValue.IMMUTABLE_DEFAULT_INSTANCE, OnestoreEntity.Property.Meaning.NO_MEANING, null);
    public static final Value TRUE = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.BOOLEAN, 1L, BOXED_UNUSED, new OnestoreEntity.PropertyValue().setBooleanValue(true), OnestoreEntity.Property.Meaning.NO_MEANING, null);
    public static final Value FALSE = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.BOOLEAN, 0L, BOXED_UNUSED, new OnestoreEntity.PropertyValue().setBooleanValue(false), OnestoreEntity.Property.Meaning.NO_MEANING, null);
    public static final Value MIN_LONG = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.LONG, Long.MIN_VALUE, BOXED_UNUSED, new OnestoreEntity.PropertyValue().setInt64Value(Long.MIN_VALUE), OnestoreEntity.Property.Meaning.NO_MEANING, null);
    public static final Value MAX_LONG = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.LONG, Long.MAX_VALUE, BOXED_UNUSED, new OnestoreEntity.PropertyValue().setInt64Value(Long.MAX_VALUE), OnestoreEntity.Property.Meaning.NO_MEANING, null);
    public static final Value NAN = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.DOUBLE, Double.doubleToRawLongBits(Double.NaN), BOXED_UNUSED, new OnestoreEntity.PropertyValue().setDoubleValue(Double.NaN), OnestoreEntity.Property.Meaning.NO_MEANING, null);
    public static final Value NEGATIVE_INFINITY = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.DOUBLE, Double.doubleToRawLongBits(Double.NEGATIVE_INFINITY), BOXED_UNUSED, new OnestoreEntity.PropertyValue().setDoubleValue(Double.NEGATIVE_INFINITY), OnestoreEntity.Property.Meaning.NO_MEANING, null);
    public static final Value POSITIVE_INFINITY = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.DOUBLE, Double.doubleToRawLongBits(Double.POSITIVE_INFINITY), BOXED_UNUSED, new OnestoreEntity.PropertyValue().setDoubleValue(Double.POSITIVE_INFINITY), OnestoreEntity.Property.Meaning.NO_MEANING, null);
    public static final Value MIN_VALID_TIMESTAMP = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.TIMESTAMP, -1L, Timestamp.newBuilder().setSeconds(-62135596800L).build(), new OnestoreEntity.PropertyValue().setInt64Value(-62135596800000000L), OnestoreEntity.Property.Meaning.GD_WHEN, null);
    public static final Value MAX_VALID_TIMESTAMP = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.TIMESTAMP, -1L, Timestamp.newBuilder().setSeconds(253402300799L).setNanos(999999999).build(), new OnestoreEntity.PropertyValue().setInt64Value(253402300799999999L), OnestoreEntity.Property.Meaning.GD_WHEN, null);
    public static final Value EMPTY_STRING = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.STRING, -1L, "", new OnestoreEntity.PropertyValue().setStringValue(""), OnestoreEntity.Property.Meaning.NO_MEANING, null);
    public static final Value EMPTY_BYTES = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.BYTES, -1L, ByteString.EMPTY, new OnestoreEntity.PropertyValue().setStringValue(""), OnestoreEntity.Property.Meaning.BYTESTRING, null);
    public static final Value EMPTY_RESOURCE_REF = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.RESOURCE_REF, -1L, OtherServiceResourceRef.EMPTY, null);
    public static final Value MIN_VALID_GEO_POINT = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.GEO_POINT, -1L, LatLng.newBuilder().setLatitude(Double.NEGATIVE_INFINITY).setLongitude(Double.NEGATIVE_INFINITY).build(), new OnestoreEntity.PropertyValue().setPointValue(new OnestoreEntity.PropertyValue.PointValue().setX(Double.NEGATIVE_INFINITY).setY(Double.NEGATIVE_INFINITY)), OnestoreEntity.Property.Meaning.GEORSS_POINT, null);
    public static final Value MAX_VALID_GEO_POINT = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.GEO_POINT, -1L, LatLng.newBuilder().setLatitude(Double.POSITIVE_INFINITY).setLongitude(Double.POSITIVE_INFINITY).build(), new OnestoreEntity.PropertyValue().setPointValue(new OnestoreEntity.PropertyValue.PointValue().setX(Double.POSITIVE_INFINITY).setY(Double.POSITIVE_INFINITY)), OnestoreEntity.Property.Meaning.GEORSS_POINT, null);
    public static final Value EMPTY_ARRAY = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.ARRAY, -1L, ImmutableList.of(), OnestoreEntity.PropertyValue.IMMUTABLE_DEFAULT_INSTANCE, OnestoreEntity.Property.Meaning.EMPTY_LIST, null);
    public static final Value EMPTY_MAP = new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.MAP, -1L, ImmutableMap.of(), new OnestoreEntity.PropertyValue().setStringValueAsBytes(OnestoreEntity.EntityProto.IMMUTABLE_DEFAULT_INSTANCE.toByteArray()), OnestoreEntity.Property.Meaning.ENTITY_PROTO, null);
    public static final ImmutableMap<Meaning, Type> SUPPORTED_MEANING_TO_TYPE_MAP = ImmutableMap.builder().put(Meaning.ATOM_CATEGORY, Type.STRING).put(Meaning.ATOM_LINK, Type.STRING).put(Meaning.ATOM_TITLE, Type.STRING).put(Meaning.ATOM_CONTENT, Type.STRING).put(Meaning.ATOM_SUMMARY, Type.STRING).put(Meaning.ATOM_AUTHOR, Type.STRING).put(Meaning.GD_EMAIL, Type.STRING).put(Meaning.GD_IM, Type.STRING).put(Meaning.GD_PHONENUMBER, Type.STRING).put(Meaning.GD_POSTALADDRESS, Type.STRING).put(Meaning.GD_RATING, Type.LONG).put(Meaning.TEXT, Type.STRING).put(Meaning.BYTESTRING, Type.BYTES).put(Meaning.INVALID_ENTITY_PROTO_BYTES, Type.BYTES).put(Meaning.NON_UTF8_BLOB_WITH_APP_ENG_V3_MEANING_NONE, Type.BYTES).put(Meaning.NON_UTF8_BLOB_WITH_APP_ENG_V3_MEANING_TEXT, Type.BYTES).put(Meaning.BLOBKEY, Type.STRING).put(Meaning.URI_MEANING_ZLIB, Type.BYTES).put(Meaning.GEO_POINT_WITHOUT_APP_ENG_V3_MEANING, Type.GEO_POINT).build();
    private final DatastoreIndexing datastoreIndexing;
    private final Meaning meaning;
    private final Type type;
    private final long unboxed;
    private final Object boxed;
    @Nullable
    private final UnknownFieldSet unknownFieldSet;
    private final OnestoreEntity.PropertyValue v3Value;
    private final OnestoreEntity.Property.Meaning v3Meaning;

    public static Value createBoolean(boolean x) {
        return x ? TRUE : FALSE;
    }

    public static Value createLong(long x) {
        return new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.LONG, x, BOXED_UNUSED, null);
    }

    public static Value createDouble(double x) {
        if (Double.isNaN(x)) {
            x = Double.NaN;
        }
        return new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.DOUBLE, Double.doubleToRawLongBits(x), BOXED_UNUSED, null);
    }

    public static Value createTimestamp(Timestamp x) {
        long nanoseconds = x.getNanos();
        Preconditions.checkArgument(RepHelper.isSecondsInTimestampBounds(x.getSeconds()) && nanoseconds >= 0L && nanoseconds < 1000000000L);
        return new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.TIMESTAMP, -1L, x, null);
    }

    public static Value createEntityRef(EntityRef x) {
        return new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.ENTITY_REF, -1L, x, null);
    }

    public static Value createResourceRef(ResourceRef x) {
        Preconditions.checkArgument(!(x instanceof EntityRef));
        return new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.RESOURCE_REF, -1L, x, null);
    }

    public static Value createString(String x) {
        return new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.STRING, -1L, x, null);
    }

    public static Value createBytes(ByteString x) {
        return new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.BYTES, -1L, x, null);
    }

    public static Value createGeoPoint(LatLng x) {
        return new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.GEO_POINT, -1L, x, null);
    }

    public static Value createGeoRegion(GeoRegion x) {
        return new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.GEO_REGION, -1L, x, null);
    }

    public static Value createArray(ImmutableList<Value> x) {
        return new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.ARRAY, -1L, x, null);
    }

    public static Value createMap(ImmutableMap<String, Value> x) {
        return Value.createMap(x, DatastoreIndexing.INCLUDE, null);
    }

    public static Value createMap(ImmutableMap<String, Value> x, DatastoreIndexing datastoreIndexing) {
        return Value.createMap(x, datastoreIndexing, null);
    }

    public static Value createMap(ImmutableMap<String, Value> x, UnknownFieldSet unknownFieldSet) {
        return Value.createMap(x, DatastoreIndexing.INCLUDE, Preconditions.checkNotNull(unknownFieldSet));
    }

    private static Value createMap(ImmutableMap<String, Value> x, DatastoreIndexing datastoreIndexing, @Nullable UnknownFieldSet unknownFieldSet) {
        return new Value(datastoreIndexing, Meaning.NONE, Type.MAP, -1L, x, unknownFieldSet);
    }

    public static Value createEntity(Entity x) {
        return Value.createEntity(x, DatastoreIndexing.INCLUDE, null);
    }

    public static Value createEntity(Entity x, DatastoreIndexing datastoreIndexing) {
        return Value.createEntity(x, datastoreIndexing, null);
    }

    public static Value createEntity(Entity x, UnknownFieldSet unknownFieldSet) {
        return Value.createEntity(x, DatastoreIndexing.INCLUDE, Preconditions.checkNotNull(unknownFieldSet));
    }

    private static Value createEntity(Entity x, DatastoreIndexing datastoreIndexing, @Nullable UnknownFieldSet unknownFieldSet) {
        return new Value(datastoreIndexing, Meaning.NONE, Type.ENTITY, -1L, x, unknownFieldSet);
    }

    public static Value createLegacyUser(LegacyUser x) {
        return new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.LEGACY_USER, -1L, x, null);
    }

    public static Value createLegacyTimestampMicroseconds(long x) {
        Preconditions.checkArgument(!RepHelper.isMicrosecondsInTimestampBounds(x));
        return new Value(DatastoreIndexing.INCLUDE, Meaning.NONE, Type.LEGACY_TIMESTAMP_MICROSECONDS, x, BOXED_UNUSED, null);
    }

    private Value(DatastoreIndexing datastoreIndexing, Meaning meaning, Type type, long unboxed, Object boxed, @Nullable UnknownFieldSet unknownFieldSet) {
        this(datastoreIndexing, meaning, type, unboxed, boxed, null, null, unknownFieldSet);
    }

    private Value(DatastoreIndexing datastoreIndexing, Meaning meaning, Type type, long unboxed, Object boxed, OnestoreEntity.PropertyValue v3Value, OnestoreEntity.Property.Meaning v3Meaning, @Nullable UnknownFieldSet unknownFieldSet) {
        this.datastoreIndexing = datastoreIndexing;
        this.meaning = meaning;
        this.type = type;
        this.unboxed = unboxed;
        this.boxed = boxed;
        this.v3Value = v3Value;
        this.v3Meaning = v3Meaning;
        this.unknownFieldSet = unknownFieldSet;
    }

    public DatastoreIndexing datastoreIndexing() {
        return this.datastoreIndexing;
    }

    public Meaning meaning() {
        return this.meaning;
    }

    public Type type() {
        return this.type;
    }

    public UnknownFieldSet unknownFieldSet() {
        return this.unknownFieldSet;
    }

    @Deprecated
    public OnestoreEntity.PropertyValue v3Value() {
        return this.v3Value;
    }

    @Deprecated
    public OnestoreEntity.Property.Meaning v3Meaning() {
        return this.v3Meaning;
    }

    public boolean asBoolean() {
        this.assertType(Type.BOOLEAN);
        return this.unboxed != 0L;
    }

    public long asLong() {
        this.assertType(Type.LONG);
        return this.unboxed;
    }

    public double asDouble() {
        this.assertType(Type.DOUBLE);
        return Double.longBitsToDouble(this.unboxed);
    }

    public Timestamp asTimestamp() {
        return (Timestamp)this.boxed;
    }

    public EntityRef asEntityRef() {
        return (EntityRef)this.boxed;
    }

    public ResourceRef asResourceRef() {
        return (ResourceRef)this.boxed;
    }

    public String asString() {
        return (String)this.boxed;
    }

    public ByteString asBytes() {
        return (ByteString)this.boxed;
    }

    public LatLng asGeoPoint() {
        return (LatLng)this.boxed;
    }

    public GeoRegion asGeoRegion() {
        return (GeoRegion)this.boxed;
    }

    public ValueRange asRange() {
        return (ValueRange)this.boxed;
    }

    public ImmutableList<Value> asArray() {
        return (ImmutableList)this.boxed;
    }

    public ImmutableMap<String, Value> asMap() {
        return (ImmutableMap)this.boxed;
    }

    public Entity asEntity() {
        return (Entity)this.boxed;
    }

    public LegacyUser asLegacyUser() {
        return (LegacyUser)this.boxed;
    }

    public long asLegacyTimestampMicroseconds() {
        this.assertType(Type.LEGACY_TIMESTAMP_MICROSECONDS);
        return this.unboxed;
    }

    public boolean isNull() {
        return this.type() == Type.NULL;
    }

    public boolean isNaN() {
        return this.type() == Type.DOUBLE && Double.isNaN(this.asDouble());
    }

    public Value withMeaning(Meaning meaning) {
        if (meaning == this.meaning) {
            return this;
        }
        Preconditions.checkArgument(meaning == Meaning.NONE || SUPPORTED_MEANING_TO_TYPE_MAP.get((Object)meaning) == this.type());
        return new Value(this.datastoreIndexing, meaning, this.type, this.unboxed, this.boxed, this.v3Value, this.v3Meaning, this.unknownFieldSet);
    }

    public Value withDatastoreIndexing(DatastoreIndexing datastoreIndexing) {
        if (datastoreIndexing == this.datastoreIndexing) {
            return this;
        }
        return new Value(datastoreIndexing, this.meaning, this.type, this.unboxed, this.boxed, this.v3Value, this.v3Meaning, this.unknownFieldSet);
    }

    public Value withV3Value(OnestoreEntity.PropertyValue v3Value, OnestoreEntity.Property.Meaning v3Meaning) {
        return new Value(this.datastoreIndexing, this.meaning, this.type, this.unboxed, this.boxed, v3Value, v3Meaning, this.unknownFieldSet);
    }

    @Nullable
    public Value get(PropertyPath propertyPath) {
        switch (this.type()) {
            case ARRAY: {
                return propertyPath.getFrom(this.asArray());
            }
            case MAP: {
                return propertyPath.getFrom(this.asMap());
            }
            case ENTITY: {
                return propertyPath.getFrom(this.asEntity().propertyMap());
            }
        }
        return null;
    }

    private void assertType(Type requiredType) {
        Preconditions.checkState(this.type == requiredType);
    }

    public boolean equals(Object valueObject) {
        if (!(valueObject instanceof Value)) {
            return false;
        }
        Value value = (Value)valueObject;
        return this.unboxed == value.unboxed && this.type == value.type && this.datastoreIndexing == value.datastoreIndexing && this.meaning == value.meaning && this.boxed.equals(value.boxed);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.datastoreIndexing, this.meaning, this.type, this.unboxed, this.boxed});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{value: ");
        switch (this.type) {
            case NULL: {
                stringBuilder.append("null");
                break;
            }
            case BOOLEAN: {
                stringBuilder.append(this.asBoolean());
                break;
            }
            case LONG: {
                stringBuilder.append(this.asLong());
                break;
            }
            case DOUBLE: {
                stringBuilder.append(this.asDouble());
                break;
            }
            case TIMESTAMP: {
                stringBuilder.append(this.asTimestamp());
                break;
            }
            case ENTITY_REF: {
                stringBuilder.append(this.asEntityRef());
                break;
            }
            case RESOURCE_REF: {
                stringBuilder.append(this.asResourceRef());
                break;
            }
            case STRING: {
                stringBuilder.append(this.asString());
                break;
            }
            case BYTES: {
                stringBuilder.append(this.asBytes());
                break;
            }
            case GEO_POINT: {
                stringBuilder.append(this.asGeoPoint());
                break;
            }
            case GEO_REGION: {
                stringBuilder.append(this.asGeoRegion());
                break;
            }
            case RANGE: {
                stringBuilder.append(this.asRange());
                break;
            }
            case ARRAY: {
                stringBuilder.append(this.asArray());
                break;
            }
            case MAP: {
                stringBuilder.append(this.asMap());
                break;
            }
            case ENTITY: {
                stringBuilder.append(this.asEntity());
                break;
            }
            case LEGACY_USER: {
                stringBuilder.append(this.asLegacyUser());
                break;
            }
            case LEGACY_TIMESTAMP_MICROSECONDS: {
                stringBuilder.append("{legacy timestamp microseconds: ");
                stringBuilder.append(this.asLegacyTimestampMicroseconds());
                stringBuilder.append("}");
                break;
            }
            default: {
                throw new IllegalStateException("Unknown value type.");
            }
        }
        if (this.datastoreIndexing != DatastoreIndexing.INCLUDE) {
            stringBuilder.append(", indexing: ");
            stringBuilder.append((Object)this.datastoreIndexing);
        }
        if (this.meaning != Meaning.NONE) {
            stringBuilder.append(", meaning: ");
            stringBuilder.append((Object)this.meaning);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static enum Meaning {
        NONE,
        ATOM_CATEGORY,
        ATOM_LINK,
        ATOM_TITLE,
        ATOM_CONTENT,
        ATOM_SUMMARY,
        ATOM_AUTHOR,
        GD_WHEN,
        GD_EMAIL,
        GEORSS_POINT,
        GD_IM,
        GD_PHONENUMBER,
        GD_POSTALADDRESS,
        GD_RATING,
        BLOB,
        TEXT,
        BYTESTRING,
        BLOBKEY,
        OMITTED_BY_MEGASTORE_INDEX,
        INVALID_ENTITY_PROTO_BYTES,
        LEGACY_USER_ENTITY,
        DEPRECATED_LEGACY_GEO_POINT_ENTITY,
        URI_MEANING_ZLIB,
        GEO_POINT_WITHOUT_APP_ENG_V3_MEANING,
        EMPTY_LIST,
        NON_UTF8_BLOB_WITH_APP_ENG_V3_MEANING_NONE,
        NON_UTF8_BLOB_WITH_APP_ENG_V3_MEANING_TEXT;

        private static final Meaning[] ordinalToEnumArray;

        @Nullable
        public static Meaning createFromOrdinal(long ordinal) {
            if (ordinal < 0L || ordinal > (long)ordinalToEnumArray.length) {
                return null;
            }
            return ordinalToEnumArray[(int)ordinal];
        }

        static {
            ordinalToEnumArray = Meaning.values();
        }
    }

    @AutoValue
    public static abstract class LegacyUser {
        public abstract String email();

        public abstract String authDomain();

        public abstract long gaiaId();

        public abstract String obfuscatedGaiaId();

        public abstract boolean isObfuscated();

        @Nullable
        public abstract String federatedIdentity();

        @Nullable
        public abstract String federatedProvider();

        public static LegacyUser createObfuscated(String email, String authDomain, long gaiaId, String obfuscatedGaiaId, @Nullable String federatedIdentity, @Nullable String federatedProvider) {
            return new AutoValue_Value_LegacyUser(email, authDomain, gaiaId, obfuscatedGaiaId, true, federatedIdentity, federatedProvider);
        }

        public static LegacyUser createUnobfuscated(String email, String authDomain, long gaiaId, String obfuscatedGaiaId, @Nullable String federatedIdentity, @Nullable String federatedProvider) {
            return new AutoValue_Value_LegacyUser(email, authDomain, gaiaId, obfuscatedGaiaId, false, federatedIdentity, federatedProvider);
        }
    }

    public static enum DatastoreIndexing {
        INCLUDE,
        EXCLUDE,
        AUTO;

    }

    public static enum Type {
        NULL,
        BOOLEAN,
        LONG,
        DOUBLE,
        TIMESTAMP,
        STRING,
        BYTES,
        ENTITY_REF,
        RESOURCE_REF,
        GEO_POINT,
        ARRAY,
        MAP,
        ENTITY,
        LEGACY_USER,
        LEGACY_TIMESTAMP_MICROSECONDS,
        GEO_REGION,
        RANGE;

    }
}

