/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.Mutation;
import com.google.cloud.datastore.core.rep.MutationHelper;
import com.google.cloud.datastore.core.rep.V3Paths;
import com.google.cloud.datastore.core.rep.Write;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class WriteHelper {
    private WriteHelper() {
    }

    public static Write.Builder toWrite(boolean trusted, boolean markChanges, List<Mutation> mutationsList) throws InvalidConversionException {
        Write.Builder write = Write.builder();
        int[] mutationMap = new int[mutationsList.size()];
        ImmutableMap.Builder<Integer, Integer> transformations = ImmutableMap.builder();
        mutationsList = WriteHelper.collapseMutations(mutationsList, mutationMap, transformations);
        write.mutations(mutationsList).originalMutationsMap(mutationMap).originalTransformations(transformations.build()).isTrusted(trusted).markChanges(markChanges);
        return write;
    }

    private static ImmutableList<Mutation> collapseMutations(List<Mutation> originalMutations, int[] originalMutationsMap, ImmutableMap.Builder<Integer, Integer> originalTransformations) throws InvalidConversionException {
        ArrayList<Mutation> collapsedMutations = Lists.newArrayListWithCapacity(originalMutations.size());
        HashMap<OnestoreEntity.Reference, Integer> collapsedMutationMapping = Maps.newHashMapWithExpectedSize(originalMutations.size());
        for (int i = 0; i < originalMutations.size(); ++i) {
            Mutation mutation = originalMutations.get(i);
            OnestoreEntity.Reference key = mutation.key();
            if (V3Paths.hasIncompleteLastElement(key)) {
                originalMutationsMap[i] = collapsedMutations.size();
                collapsedMutations.add(mutation);
                continue;
            }
            Integer collapsedMutationsIndex = (Integer)collapsedMutationMapping.get(key);
            if (collapsedMutationsIndex == null) {
                collapsedMutationsIndex = collapsedMutations.size();
                collapsedMutations.add(mutation);
                collapsedMutationMapping.put(key, collapsedMutationsIndex);
            } else {
                Mutation previousMutation = (Mutation)collapsedMutations.get(collapsedMutationsIndex);
                Mutation collapsedMutation = MutationHelper.collapse(previousMutation, mutation);
                collapsedMutations.set(collapsedMutationsIndex, collapsedMutation);
            }
            originalMutationsMap[i] = collapsedMutationsIndex;
            if (mutation.transformation() == null) continue;
            originalTransformations.put(i, mutation.transformation().propertyTransformations().size());
        }
        return ImmutableList.copyOf(collapsedMutations);
    }
}

