/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.converter;

import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.exception.ValidationException;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.cloud.datastore.core.rep.PropertyMaskHelper;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.validator.PropertyPathValidator;
import com.google.cloud.datastore.core.rep.validator.ValidationConstraint;
import java.util.Collection;

public class PropertyPathToMaskConverter {
    private final PropertyPathValidator propertyPathValidator;

    public PropertyPathToMaskConverter(PropertyPathValidator propertyPathValidator) {
        this.propertyPathValidator = propertyPathValidator;
    }

    public PropertyMask validateAndConvertPathsToMask(Collection<PropertyPath> propertyPaths, ValidationConstraint constraint) throws InvalidConversionException {
        constraint = constraint.withContext(ValidationConstraint.Context.IN_PROPERTY_MASK);
        try {
            for (PropertyPath propertyPath : propertyPaths) {
                this.propertyPathValidator.validatePropertyPath(propertyPath, constraint);
            }
        }
        catch (ValidationException exception) {
            throw new InvalidConversionException(exception.getMessage(), exception);
        }
        return PropertyMaskHelper.convertPathsToMask(propertyPaths);
    }
}

