/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.converter;

import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.PropertyName;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathSegment;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TildeEscapedPropertyPathToRepConverter {
    public static final char ESCAPE_CHAR = '~';
    public static final String SPECIAL_CHARS = "~/.*[]";
    private static final String ILL_FORMED_PROPERTY_PATH_STRING_MESSAGE = "Invalid property path \"%s\".";
    private static final String EMPTY_PROPERTY_PATH_STRING_ERROR_MESSAGE = "Invalid empty property path string.";
    private static final String MEMBER_REGEX_STRING = "((?:[^~/.*\\[\\]]|(?:~[0-5]))+)";
    private static final String INDEX_REGEX_STRING = "(?:\\[(\\d+)\\])";
    private static final Pattern PROPERTY_PATH_FIRST_OPERATION_REGEX = Pattern.compile("((?:[^~/.*\\[\\]]|(?:~[0-5]))+)");
    private static final Pattern PROPERTY_PATH_REST_OPERATION_REGEX = Pattern.compile(String.format("(?:\\.%s)|(?:%s)", "((?:[^~/.*\\[\\]]|(?:~[0-5]))+)", "(?:\\[(\\d+)\\])"));
    private static final int PROPERTY_PATH_MEMBER_GROUP = 1;
    private static final int PROPERTY_PATH_INDEX_GROUP = 2;
    private final String entityKeyPropertyName;

    public TildeEscapedPropertyPathToRepConverter(String entityKeyPropertyName) {
        this.entityKeyPropertyName = entityKeyPropertyName;
    }

    public PropertyPath convertPropertyPath(String stringPath) throws InvalidConversionException {
        InvalidConversionException.checkConversion(!stringPath.isEmpty(), EMPTY_PROPERTY_PATH_STRING_ERROR_MESSAGE, new Object[0]);
        ArrayList<PropertyPathSegment> segments = new ArrayList<PropertyPathSegment>();
        int endPathStringIndex = stringPath.length();
        Matcher segmentMatcher = PROPERTY_PATH_FIRST_OPERATION_REGEX.matcher(stringPath);
        boolean foundMatch = segmentMatcher.lookingAt();
        InvalidConversionException.checkConversion(foundMatch, ILL_FORMED_PROPERTY_PATH_STRING_MESSAGE, stringPath);
        segments.add(this.makeSegmentFromSegmentMatcher(stringPath, segmentMatcher));
        int startNextOpPathIndex = segmentMatcher.end();
        if (startNextOpPathIndex < endPathStringIndex) {
            segmentMatcher = PROPERTY_PATH_REST_OPERATION_REGEX.matcher(stringPath);
            do {
                segmentMatcher.region(startNextOpPathIndex, endPathStringIndex);
                foundMatch = segmentMatcher.lookingAt();
                InvalidConversionException.checkConversion(foundMatch, ILL_FORMED_PROPERTY_PATH_STRING_MESSAGE, stringPath);
                segments.add(this.makeSegmentFromSegmentMatcher(stringPath, segmentMatcher));
            } while ((startNextOpPathIndex = segmentMatcher.end()) < endPathStringIndex);
        }
        return PropertyPath.createFromSegments(segments);
    }

    private PropertyPathSegment makeSegmentFromSegmentMatcher(String stringPath, Matcher segmentMatcher) throws InvalidConversionException {
        String memberString = segmentMatcher.group(1);
        if (memberString != null) {
            return PropertyPathSegment.Member.create(this.convertMemberName(stringPath, memberString));
        }
        InvalidConversionException.checkConversion(false, ILL_FORMED_PROPERTY_PATH_STRING_MESSAGE, stringPath);
        String indexText = segmentMatcher.group(2);
        try {
            int index = Integer.parseInt(indexText);
            InvalidConversionException.checkConversion(index >= 0, ILL_FORMED_PROPERTY_PATH_STRING_MESSAGE, stringPath);
            return PropertyPathSegment.Index.create(index);
        }
        catch (NumberFormatException exception) {
            throw new InvalidConversionException(String.format(ILL_FORMED_PROPERTY_PATH_STRING_MESSAGE, stringPath));
        }
    }

    private PropertyName convertMemberName(String stringPath, String memberString) throws InvalidConversionException {
        if (memberString.indexOf(126) < 0) {
            return this.convertPropertyName(memberString);
        }
        StringBuilder stringBuilder = new StringBuilder();
        int numChars = memberString.length();
        for (int index = 0; index < numChars; ++index) {
            char c = memberString.charAt(index);
            if (c == '~') {
                InvalidConversionException.checkConversion(++index < numChars, ILL_FORMED_PROPERTY_PATH_STRING_MESSAGE, stringPath);
                c = memberString.charAt(index);
                int digit = c - 48;
                c = SPECIAL_CHARS.charAt(digit);
            }
            stringBuilder.append(c);
        }
        return this.convertPropertyName(stringBuilder.toString());
    }

    public PropertyName convertPropertyName(String nameString) throws InvalidConversionException {
        if (nameString.equals(this.entityKeyPropertyName)) {
            return PropertyName.KEY;
        }
        PropertyName propertyName = PropertyName.fromUtf8(nameString);
        InvalidConversionException.checkConversion(!propertyName.isKey(), "Invalid property path member name \"%s\".", PropertyName.KEY.string());
        return propertyName;
    }
}

