/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.converter;

import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.ReservedName;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.converter.LegacyMapValueConverterHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class ValueToLegacyMapValueConverter {
    public boolean isLegacyValue(Value value) {
        switch (value.type()) {
            case ENTITY: 
            case LEGACY_USER: 
            case LEGACY_TIMESTAMP_MICROSECONDS: {
                return true;
            }
        }
        Value.Meaning meaning = value.meaning();
        return meaning != Value.Meaning.NONE;
    }

    public Entity deepConvertEntity(Entity entity) {
        ImmutableMap<String, Value> propertyMap = entity.propertyMap();
        ImmutableMap<String, Value> convertedPropertyMap = this.deepConvertMap(propertyMap);
        if (convertedPropertyMap == propertyMap) {
            return entity;
        }
        return Entity.create(entity.ref(), convertedPropertyMap);
    }

    @VisibleForTesting
    public Value deepConvertValue(Value value) {
        value = this.shallowConvertValue(value);
        switch (value.type()) {
            case MAP: {
                ImmutableMap<String, Value> map = value.asMap();
                ImmutableMap<String, Value> convertedMap = this.deepConvertMap(map);
                if (convertedMap == map) {
                    return value;
                }
                return Value.createMap(convertedMap);
            }
            case ARRAY: {
                ImmutableList<Value> array = value.asArray();
                ImmutableList<Value> convertedArray = this.deepConvertArray(array);
                if (convertedArray == array) {
                    return value;
                }
                return Value.createArray(convertedArray);
            }
        }
        return value;
    }

    private ImmutableMap<String, Value> deepConvertMap(ImmutableMap<String, Value> map) {
        String propertyNameRequiringConversion = null;
        Value convertedValueForPropertyNameRequiringConversion = null;
        for (Map.Entry entry : map.entrySet()) {
            String propertyName = (String)entry.getKey();
            Value value = (Value)entry.getValue();
            Value convertedValue = this.deepConvertValue(value);
            if (convertedValue == value) continue;
            propertyNameRequiringConversion = propertyName;
            convertedValueForPropertyNameRequiringConversion = convertedValue;
            break;
        }
        if (propertyNameRequiringConversion == null) {
            return map;
        }
        ImmutableMap.Builder<String, Value> mapBuilder = ImmutableMap.builder();
        boolean foundValueRequiringConversion = false;
        for (Map.Entry entry : map.entrySet()) {
            String propertyName = (String)entry.getKey();
            Value value = (Value)entry.getValue();
            if (foundValueRequiringConversion) {
                Value convertedValue = this.deepConvertValue(value);
                mapBuilder.put(propertyName, convertedValue);
                continue;
            }
            if (propertyName == propertyNameRequiringConversion) {
                foundValueRequiringConversion = true;
                mapBuilder.put(propertyName, convertedValueForPropertyNameRequiringConversion);
                continue;
            }
            mapBuilder.put(propertyName, value);
        }
        return mapBuilder.build();
    }

    private ImmutableList<Value> deepConvertArray(ImmutableList<Value> array) {
        Value value;
        int index;
        int arraySize = array.size();
        int indexRequiringConversion = -1;
        Value convertedValueForIndexRequiringConversion = null;
        for (int index2 = 0; index2 < arraySize; ++index2) {
            Value value2 = (Value)array.get(index2);
            Value convertedValue = this.deepConvertValue(value2);
            if (convertedValue == value2) continue;
            indexRequiringConversion = index2;
            convertedValueForIndexRequiringConversion = convertedValue;
            break;
        }
        if (indexRequiringConversion < 0) {
            return array;
        }
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (index = 0; index < indexRequiringConversion; ++index) {
            value = (Value)array.get(index);
            listBuilder.add(value);
        }
        listBuilder.add(convertedValueForIndexRequiringConversion);
        for (index = indexRequiringConversion + 1; index < arraySize; ++index) {
            value = (Value)array.get(index);
            Value convertedValue = this.deepConvertValue(value);
            listBuilder.add(convertedValue);
        }
        return listBuilder.build();
    }

    public Value shallowConvertValue(Value value) {
        Value.Meaning meaning = value.meaning();
        boolean hasMeaning = meaning != Value.Meaning.NONE;
        Value valueWithoutMeaning = value;
        if (hasMeaning) {
            valueWithoutMeaning = value.withMeaning(Value.Meaning.NONE);
        }
        Value legacyMapValueWithoutMeaning = this.shallowConvertValueWithoutMeaning(valueWithoutMeaning);
        if (!hasMeaning) {
            return legacyMapValueWithoutMeaning;
        }
        return this.legacyMeaningWrapValue(legacyMapValueWithoutMeaning, meaning);
    }

    private Value shallowConvertValueWithoutMeaning(Value value) {
        switch (value.type()) {
            case ENTITY: {
                return this.shallowConvertEntity(value.asEntity());
            }
            case LEGACY_USER: {
                return this.convertLegacyUser(value.asLegacyUser());
            }
            case LEGACY_TIMESTAMP_MICROSECONDS: {
                return this.convertLegacyTimestampMicroseconds(value.asLegacyTimestampMicroseconds());
            }
        }
        return value;
    }

    private Value shallowConvertEntity(Entity entity) {
        ImmutableMap.Builder<String, Value> mapBuilder = ImmutableMap.builder();
        mapBuilder.putAll(entity.propertyMap());
        mapBuilder.put(ReservedName.TYPE.asString(), LegacyMapValueConverterHelper.LEGACY_ENTITY_TYPE_NAME_VALUE);
        mapBuilder.put(ReservedName.NAME.asString(), Value.createEntityRef(entity.ref()));
        return Value.createMap(mapBuilder.build());
    }

    private Value convertLegacyUser(Value.LegacyUser user) {
        ImmutableMap.Builder<String, Value> mapBuilder = ImmutableMap.builder();
        mapBuilder.put(ReservedName.TYPE.asString(), LegacyMapValueConverterHelper.LEGACY_USER_TYPE_NAME_VALUE);
        mapBuilder.put("email", Value.createString(user.email()));
        mapBuilder.put("auth_domain", Value.createString(user.authDomain()));
        mapBuilder.put("gaia_id", Value.createString(user.obfuscatedGaiaId()));
        if (user.federatedIdentity() != null) {
            mapBuilder.put("federated_identity", Value.createString(user.federatedIdentity()));
        }
        if (user.federatedProvider() != null) {
            mapBuilder.put("federated_provider", Value.createString(user.federatedProvider()));
        }
        return Value.createMap(mapBuilder.build());
    }

    private Value legacyMeaningWrapValue(Value value, Value.Meaning meaning) {
        ImmutableMap.Builder<String, Value> mapBuilder = ImmutableMap.builder();
        mapBuilder.put(ReservedName.TYPE.asString(), LegacyMapValueConverterHelper.LEGACY_MEANING_WRAPPER_TYPE_NAME_VALUE);
        mapBuilder.put("value", value);
        mapBuilder.put("meaning", Value.createLong(meaning.ordinal()));
        return Value.createMap(mapBuilder.build());
    }

    private Value convertLegacyTimestampMicroseconds(long microseconds) {
        ImmutableMap.Builder<String, Value> mapBuilder = ImmutableMap.builder();
        mapBuilder.put(ReservedName.TYPE.asString(), LegacyMapValueConverterHelper.LEGACY_TIMESTAMP_MICROSECONDS_TYPE_NAME_VALUE);
        mapBuilder.put("microseconds", Value.createLong(microseconds));
        return Value.createMap(mapBuilder.build());
    }
}

