/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.validator;

import com.google.apphosting.datastore.shared.Config;
import com.google.cloud.datastore.core.exception.ProblemCode;
import com.google.cloud.datastore.core.exception.ValidationException;
import com.google.cloud.datastore.core.names.Names;
import com.google.cloud.datastore.core.names.ProjectIds;
import com.google.cloud.datastore.core.rep.PropertyName;
import com.google.cloud.datastore.core.rep.ReservedName;
import com.google.cloud.datastore.core.rep.validator.ValidationConstraint;
import com.google.cloud.datastore.core.rep.validator.ValidationUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.ByteString;
import java.util.Set;

public abstract class BaseDatastoreValidator {
    private static final ByteString KEY_AS_BYTE_STRING = ByteString.copyFromUtf8(ReservedName.KEY.asString());
    protected Config.DatastoreConfig config;
    private final Set<ByteString> allowedReservedKindsBytes;

    protected BaseDatastoreValidator(Config.DatastoreConfig config) {
        this.config = config;
        ImmutableSet.Builder allowedReservedKindsBytesBuilder = ImmutableSet.builder();
        allowedReservedKindsBytesBuilder.addAll(config.getReservedKindsToAllowList().asByteStringList());
        this.allowedReservedKindsBytes = allowedReservedKindsBytesBuilder.build();
    }

    public Config.DatastoreConfig config() {
        return this.config;
    }

    public void validateKind(ValidationConstraint constraint, ByteString kind) throws ValidationException {
        this.validateKind(constraint, kind, "kind");
    }

    public void validateKind(ValidationConstraint constraint, ByteString kind, String desc) throws ValidationException {
        this.validateStringNotEmpty(kind, desc);
        this.validateLength(kind, this.config.getMaxIndexedValueBytes(), desc);
        if (constraint.getCustomizableConfig(this.config).getEnableAppEngV3ValidateKindUtf8()) {
            ValidationUtils.INSTANCE.validateStringUtf8(kind, ProblemCode.KIND_NOT_UTF8, desc);
        }
        if (!constraint.allowReservedKey() && !this.allowedReservedKindsBytes.contains(kind)) {
            this.validateStringNotReserved(kind, desc);
        }
    }

    public void validatePartitionIdDimensionBytes(ByteString value, String dimension) throws ValidationException {
        this.validateLength(value, 100, dimension);
        ValidationUtils.INSTANCE.validateStringUtf8(value, dimension);
    }

    protected void validatePartitionIdDimension(ValidationConstraint constraint, String value, String dimension) throws ValidationException {
        if (!constraint.allowReservedKey()) {
            this.validateStringNotReserved(value, dimension);
        }
        ValidationException.validateAssertion(ProjectIds.PARTITION_ID_REGEX.matcher(value).matches(), "Illegal string \"%s\" in %s.", value, dimension);
    }

    public void validateAppId(ValidationConstraint constraint, String appId) throws ValidationException {
        ValidationException.validateAssertion(!appId.isEmpty(), "The app id is the empty string.", new Object[0]);
        this.validateAppId(constraint, appId, "app id");
    }

    protected void validateAppId(ValidationConstraint constraint, String appId, String description) throws ValidationException {
        try {
            ProjectIds.ParsedAppId parsedAppId = ProjectIds.parseAppId(appId);
            if (!constraint.allowReservedKey()) {
                ValidationException.validateAssertion(parsedAppId.metadata() == null, "The %s %s is reserved.", description, appId);
                this.validateStringNotReserved(parsedAppId.projectId(), description);
            }
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException(String.format("\"%s\" is an invalid %s.", appId, description), e);
        }
    }

    public void validateProjectId(ValidationConstraint constraint, String projectId) throws ValidationException {
        ValidationException.validateAssertion(ProjectIds.isValidProjectId(projectId), "\"%s\" is an invalid project id.", projectId);
        if (!constraint.allowReservedKey()) {
            this.validateStringNotReserved(projectId, "project id");
        }
    }

    public void validatePropertyName(ValidationConstraint constraint, ByteString propertyName) throws ValidationException {
        this.validatePropertyName(constraint, propertyName, "");
    }

    public void validatePropertyName(ValidationConstraint constraint, ByteString propertyName, String desc) throws ValidationException {
        this.validatePropertyName(constraint, propertyName, 0, desc);
    }

    public void validatePropertyName(ValidationConstraint constraint, ByteString propertyName, int prefixLength, String desc) throws ValidationException {
        String string = desc = desc.isEmpty() ? "property.name" : String.valueOf(desc).concat(".property.name");
        if (prefixLength > 0) {
            String string2 = String.valueOf(desc);
            desc = string2.length() != 0 ? "flattened ".concat(string2) : new String("flattened ");
        }
        this.validateStringNotEmpty(propertyName, desc);
        this.validateLength(propertyName.size() + prefixLength, this.config.getMaxIndexedValueBytes(), desc);
        boolean isKeyProperty = propertyName.equals(KEY_AS_BYTE_STRING);
        boolean allowKeyProperty = constraint.allowReservedName(this.config, PropertyName.KEY, true, true);
        if (!(constraint.allowReservedName() || allowKeyProperty && isKeyProperty)) {
            this.validateStringNotReserved(propertyName, desc);
        }
    }

    public void validateStringNotReserved(String string, String desc) throws ValidationException {
        ValidationException.validateAssertion(!Names.isNameReserved(string), "The %s \"%s\" is reserved.", desc, string);
    }

    public void validateStringNotReserved(ByteString string, String desc) throws ValidationException {
        if (Names.isNameReserved(string)) {
            ValidationException.validateAssertion(false, "The %s \"%s\" is reserved.", desc, string.toStringUtf8());
        }
    }

    public void validateStringNotEmpty(String string, String desc) throws ValidationException {
        ValidationException.validateAssertion(!string.isEmpty(), "The %s is the empty string.", desc);
    }

    public void validateStringNotEmpty(ByteString string, String desc) throws ValidationException {
        ValidationException.validateAssertion(!string.isEmpty(), "The %s is the empty string.", desc);
    }

    public void validateLength(ByteString byteString, int maxLength, String desc) throws ValidationException {
        this.validateLength(byteString.size(), maxLength, desc);
    }

    private void validateLength(int length, int maxLength, String desc) throws ValidationException {
        ValidationException.validateAssertion(length <= maxLength, "The %s is longer than %d bytes.", desc, maxLength);
    }

    public void validateLength(int length, int maxLength, ProblemCode problemCode, String desc) throws ValidationException {
        ValidationException.validateAssertion(length <= maxLength, problemCode, "The %s is longer than %d bytes.", desc, maxLength);
    }

    public void validateSameApp(String app1, String app2) throws ValidationException {
        Preconditions.checkNotNull(app1);
        Preconditions.checkNotNull(app2);
        ValidationException.validateAssertion(app1.equals(app2), "%s%s vs. %s", "mismatched app ids within request: ", app1, app2);
    }

    public void validateGeoPoint(double lat, double lon) throws ValidationException {
        if (!(Math.abs(lat) <= 90.0)) {
            ValidationException.validateAssertion(!Double.isNaN(lat), ProblemCode.INVALID_GEO_POINT, "Geo point latitude is not a number.", new Object[0]);
            ValidationException.validateAssertion(false, ProblemCode.INVALID_GEO_POINT, "Geo point latitude outside permitted range -90.0 to 90.0.", new Object[0]);
        }
        if (!(Math.abs(lon) <= 180.0)) {
            ValidationException.validateAssertion(!Double.isNaN(lon), ProblemCode.INVALID_GEO_POINT, "Geo point longitude is not a number.", new Object[0]);
            ValidationException.validateAssertion(false, ProblemCode.INVALID_GEO_POINT, "Geo point longitude outside permitted range -180.0 to 180.0.", new Object[0]);
        }
    }
}

