/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.validator;

import com.google.cloud.datastore.core.exception.ValidationException;
import com.google.cloud.datastore.core.names.ProjectIds;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.validator.ValidationUtils;
import com.google.protobuf.ByteString;
import javax.annotation.Nullable;

public final class DatabaseRefValidator {
    public static final DatabaseRefValidator INSTANCE = new DatabaseRefValidator();
    private static final ThreadLocal<DatabaseRef> databaseRefThreadLocal = new ThreadLocal<DatabaseRef>(){

        @Override
        protected DatabaseRef initialValue() {
            return null;
        }
    };

    private DatabaseRefValidator() {
    }

    public DatabaseRef validateDatabaseRefMatch(DatabaseRef testDatabase, @Nullable DatabaseRef expectedDatabase) throws ValidationException {
        if (expectedDatabase != null && !testDatabase.equalsIgnoringDirectory(expectedDatabase)) {
            throw new ValidationException(String.format("%s%s vs. %s", "mismatched databases within request: ", testDatabase, expectedDatabase));
        }
        return testDatabase;
    }

    public DatabaseRef createAndValidateDatabaseRef(@Nullable byte[] appIdBytesArray, @Nullable byte[] databaseIdBytesArray) throws ValidationException {
        ByteString appId = appIdBytesArray == null ? ByteString.EMPTY : ByteString.copyFrom(appIdBytesArray);
        ByteString databaseId = databaseIdBytesArray == null ? ByteString.EMPTY : ByteString.copyFrom(databaseIdBytesArray);
        return this.createAndValidateDatabaseRef(appId, databaseId);
    }

    public DatabaseRef createAndValidateDatabaseRef(ByteString appIdBytes, ByteString databaseIdBytes) throws ValidationException {
        DatabaseRef threadLocalEntry = databaseRefThreadLocal.get();
        if (threadLocalEntry != null && threadLocalEntry.hasAppPartition() && threadLocalEntry.appIdAsByteString().equals(appIdBytes) && threadLocalEntry.databaseIdAsByteString().equals(databaseIdBytes)) {
            return threadLocalEntry;
        }
        ValidationUtils.INSTANCE.validateStringUtf8(appIdBytes, "app id");
        ValidationUtils.INSTANCE.validateStringUtf8(databaseIdBytes, "database id");
        String appId = appIdBytes.toStringUtf8();
        String databaseId = databaseIdBytes.toStringUtf8();
        DatabaseRef databaseRef = this.createAndValidateDatabaseRef(appId, databaseId);
        DatabaseRefValidator.stash(databaseRef);
        return databaseRef;
    }

    public DatabaseRef createAndValidateDatabaseRef(String appId, String databaseId) throws ValidationException {
        ValidationException.validateAssertion(!appId.isEmpty(), "The app id is the empty string.", new Object[0]);
        if (!databaseId.isEmpty()) {
            ValidationException.validateAssertion(ProjectIds.DATABASE_ID_REGEX.matcher(databaseId).matches(), "\"%s\" is an invalid %s.", databaseId, "database id");
        }
        try {
            return DatabaseRef.createForApp(appId, databaseId);
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException(new StringBuilder(24 + String.valueOf(appId).length()).append("\"").append(appId).append("\" is an invalid app id.").toString(), e);
        }
    }

    public static void stash(DatabaseRef databaseRef) {
        databaseRefThreadLocal.set(databaseRef);
    }
}

