/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.validator;

import com.google.cloud.datastore.core.exception.ProblemCode;
import com.google.cloud.datastore.core.exception.ValidationException;
import com.google.cloud.datastore.core.rep.RepHelper;
import com.google.protobuf.ByteString;
import com.google.protobuf.TimestampOrBuilder;

public final class ValidationUtils {
    public static final ValidationUtils INSTANCE = new ValidationUtils();

    private ValidationUtils() {
    }

    public void validateStringUtf8(ByteString byteString, String desc) throws ValidationException {
        ValidationException.validateAssertion(byteString.isValidUtf8(), "The %s is not valid UTF-8.", desc);
    }

    public void validateStringUtf8(ByteString byteString, ProblemCode problemCode, String desc) throws ValidationException {
        ValidationException.validateAssertion(byteString.isValidUtf8(), problemCode, "The %s is not valid UTF-8.", desc);
    }

    public void validateTimestamp(TimestampOrBuilder timestamp) throws ValidationException {
        ValidationException.validateAssertion(timestamp.getNanos() >= 0 && timestamp.getNanos() < 1000000000, "Timestamp nanos exceeds limit for field", new Object[0]);
        ValidationException.validateAssertion(RepHelper.isSecondsInTimestampBounds(timestamp.getSeconds()), "Timestamp seconds exceeds limit for field", new Object[0]);
    }
}

