/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.util;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.exception.DatastoreExceptionHelper;
import com.google.cloud.datastore.core.util.AutoValue_ComparingSupplier;
import com.google.cloud.datastore.core.util.DatastoreSupplier;
import com.google.common.flogger.GoogleLogger;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;

@AutoValue
public abstract class ComparingSupplier<T>
implements DatastoreSupplier<T> {
    @Override
    public T get() throws DatastoreException {
        Object currentValue = null;
        DatastoreException currentException = null;
        Object newValue = null;
        DatastoreException newDatastoreException = null;
        RuntimeException newRuntimeException = null;
        if (!this.useNewSupplier() || this.compareSuppliers()) {
            try {
                currentValue = this.currentSupplier().get();
            }
            catch (DatastoreException e) {
                currentException = e;
            }
        }
        if (this.useNewSupplier() || this.compareSuppliers()) {
            try {
                newValue = this.newSupplier().get();
            }
            catch (DatastoreException e) {
                newDatastoreException = e;
            }
            catch (RuntimeException e) {
                newRuntimeException = e;
            }
        }
        if (this.compareSuppliers()) {
            Exception newException;
            Exception exception = newException = newRuntimeException != null ? newRuntimeException : newDatastoreException;
            if (!this.resultsAreEquals(currentValue, currentException, newValue, newException)) {
                this.onDifferenceHandler().handle(currentValue, currentException, newValue, newException);
            }
        }
        if (this.useNewSupplier()) {
            if (newRuntimeException != null) {
                throw newRuntimeException;
            }
            if (newDatastoreException != null) {
                throw newDatastoreException;
            }
            return newValue;
        }
        if (currentException != null) {
            throw currentException;
        }
        return currentValue;
    }

    public T getUnchecked() {
        try {
            return this.get();
        }
        catch (DatastoreException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean resultsAreEquals(@Nullable T currentValue, @Nullable DatastoreException currentException, @Nullable T newValue, @Nullable Exception newException) {
        boolean bothExceptionsNull = currentException == null && newException == null;
        boolean bothExceptionsNonNull = currentException != null && newException != null && newException instanceof DatastoreException;
        return this.comparator().test(currentValue, newValue) && (bothExceptionsNull || bothExceptionsNonNull && this.exceptionComparator().test(currentException, (DatastoreException)newException));
    }

    abstract DatastoreSupplier<T> currentSupplier();

    abstract DatastoreSupplier<T> newSupplier();

    abstract boolean useNewSupplier();

    abstract boolean compareSuppliers();

    abstract BiPredicate<T, T> comparator();

    abstract BiPredicate<DatastoreException, DatastoreException> exceptionComparator();

    abstract DifferenceHandler<T> onDifferenceHandler();

    public static <T> Builder<T> builder() {
        return new AutoValue_ComparingSupplier.Builder().useNewSupplier(false).compareSuppliers(false).comparator(Objects::equals).exceptionComparator((e1, e2) -> e1.sameErrorAndMessage((DatastoreException)e2)).onDifferenceHandler((v, e, ov, oe) -> {});
    }

    private static <T> String makeMessage(String description, T currentValue, DatastoreException currentException, T newValue, Exception newException) {
        return String.format("%s current: %s (err: %s), new: %s (err: %s)", description, currentValue, currentException, newValue, newException);
    }

    @AutoValue.Builder
    public static abstract class Builder<T> {
        public abstract Builder<T> currentSupplier(DatastoreSupplier<T> var1);

        public abstract Builder<T> newSupplier(DatastoreSupplier<T> var1);

        public abstract Builder<T> useNewSupplier(boolean var1);

        public abstract Builder<T> compareSuppliers(boolean var1);

        public Builder<T> mode(Mode mode) {
            switch (mode) {
                case USE_CURRENT: {
                    this.useNewSupplier(false);
                    this.compareSuppliers(false);
                    break;
                }
                case COMPARE: {
                    this.useNewSupplier(false);
                    this.compareSuppliers(true);
                    break;
                }
                case COMPARE_AND_USE_NEW: {
                    this.useNewSupplier(true);
                    this.compareSuppliers(true);
                    break;
                }
                case USE_NEW: {
                    this.useNewSupplier(true);
                    this.compareSuppliers(false);
                    break;
                }
                case TEST: {
                    this.useNewSupplier(true);
                    this.compareSuppliers(true);
                    this.throwOnDifference("unexpected difference");
                }
            }
            return this;
        }

        public abstract Builder<T> comparator(BiPredicate<T, T> var1);

        public abstract Builder<T> exceptionComparator(BiPredicate<DatastoreException, DatastoreException> var1);

        public Builder<T> onDifference(DifferenceHandler<T> onDifference) {
            DifferenceHandler existing = this.onDifferenceHandler();
            return this.onDifferenceHandler((v, e, ov, oe) -> {
                existing.handle(v, e, ov, oe);
                onDifference.handle(v, e, ov, oe);
            });
        }

        public Builder<T> logOnDifferenceAtMostEvery(String description, int n, TimeUnit unit) {
            return this.onDifference((v, e, ov, oe) -> ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)GoogleLogger.forInjectedClassName("com/google/cloud/datastore/core/util/ComparingSupplier$Builder").atWarning()).atMostEvery(n, unit)).withCause(e == null ? oe : null)).withInjectedLogSite("com/google/cloud/datastore/core/util/ComparingSupplier$Builder", "lambda$logOnDifferenceAtMostEvery$1", 258, "ComparingSupplier.java")).log(ComparingSupplier.makeMessage(description, v, e, ov, oe)));
        }

        public Builder<T> throwOnDifference(String description) {
            return this.onDifference((v, e, ov, oe) -> {
                throw DatastoreExceptionHelper.internalError(ComparingSupplier.makeMessage(description, v, e, ov, oe), oe);
            });
        }

        protected abstract DifferenceHandler<T> onDifferenceHandler();

        protected abstract Builder<T> onDifferenceHandler(DifferenceHandler<T> var1);

        public abstract ComparingSupplier<T> build();

        public T get() throws DatastoreException {
            return this.build().get();
        }

        public T getUnchecked() {
            return this.build().getUnchecked();
        }
    }

    @FunctionalInterface
    public static interface DifferenceHandler<T> {
        public void handle(@Nullable T var1, @Nullable DatastoreException var2, @Nullable T var3, @Nullable Exception var4) throws DatastoreException;
    }

    public static enum Mode {
        USE_CURRENT,
        COMPARE,
        COMPARE_AND_USE_NEW,
        USE_NEW,
        TEST;

    }
}

