/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.util;

import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;

public interface DatastoreSupplier<T> {
    public T get() throws DatastoreException;

    public static <T> DatastoreSupplier<T> ofInstance(T value) {
        return () -> value;
    }

    public static <T> DatastoreSupplier<T> memoize(DatastoreSupplier<T> delegate) {
        Supplier<Object> memoized = Suppliers.memoize(() -> {
            try {
                return delegate.get();
            }
            catch (DatastoreException e) {
                throw new RuntimeException(e);
            }
        });
        return () -> {
            try {
                return memoized.get();
            }
            catch (RuntimeException ex) {
                Throwables.propagateIfPossible(ex.getCause(), DatastoreException.class);
                throw ex;
            }
        };
    }

    public static interface SingletonDatastoreSupplier<T>
    extends DatastoreSupplier<T> {
    }
}

