/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.util;

import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.util.DatastoreSupplier;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Iterator;

public class DatastoreSuppliers {
    private DatastoreSuppliers() {
    }

    public static <T> DatastoreSupplier.SingletonDatastoreSupplier<T> memoize(DatastoreSupplier<T> delegate) {
        if (delegate instanceof DatastoreSupplier.SingletonDatastoreSupplier) {
            return (DatastoreSupplier.SingletonDatastoreSupplier)delegate;
        }
        return new MemoizingSupplier<T>(delegate);
    }

    public static <T> DatastoreSupplier.SingletonDatastoreSupplier<T> ofInstance(T t) {
        return new InstanceSupplier<T>(t);
    }

    public static <T> DatastoreSupplier<T> sequence(DatastoreSupplier<T> ... suppliers) {
        Preconditions.checkArgument(suppliers.length > 0, "Must use at least 1 supplier in sequence.");
        if (suppliers.length == 1) {
            return suppliers[0];
        }
        return new SequenceSupplier<T>(suppliers);
    }

    private static class SequenceSupplier<T>
    implements DatastoreSupplier<T> {
        private DatastoreSupplier<T> current;
        private final Iterator<DatastoreSupplier<T>> delegates;

        SequenceSupplier(DatastoreSupplier<T> ... delegates) {
            this.delegates = Iterators.forArray(Arrays.copyOf(delegates, delegates.length));
        }

        @Override
        public synchronized T get() throws DatastoreException {
            if (this.delegates.hasNext()) {
                this.current = this.delegates.next();
            }
            return this.current.get();
        }
    }

    private static class MemoizingSupplier<T>
    implements DatastoreSupplier.SingletonDatastoreSupplier<T> {
        private final DatastoreSupplier<T> delegate;
        private boolean initialized = false;
        private T value;

        MemoizingSupplier(DatastoreSupplier<T> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        @Override
        public synchronized T get() throws DatastoreException {
            if (!this.initialized) {
                this.value = this.delegate.get();
                this.initialized = true;
            }
            return this.value;
        }
    }

    private static class InstanceSupplier<T>
    implements DatastoreSupplier.SingletonDatastoreSupplier<T> {
        private final T instance;

        InstanceSupplier(T instance) {
            this.instance = instance;
        }

        @Override
        public T get() {
            return this.instance;
        }
    }
}

