/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.cli;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class EmulatorCli {
    public static final int MAX_WIDTH = 80;
    public static final int OPTION_INDENT = 2;
    public static final int OPTION_DESCRIPTION_INDENT = 2;

    public static List<String> wrap(String source, int maxWidth, int indent) {
        Iterable<String> words = Splitter.on(' ').split(source);
        ArrayList<String> wrappedLines = Lists.newArrayList();
        StringBuilder line = new StringBuilder(Strings.repeat(" ", indent));
        int lineLength = indent;
        for (String word : words) {
            if (lineLength + word.length() >= maxWidth) {
                wrappedLines.add(line.toString());
                line = new StringBuilder(Strings.repeat(" ", indent));
                lineLength = indent;
            }
            if (lineLength > indent && lineLength < maxWidth) {
                line.append(" ");
                ++lineLength;
            }
            line.append(word);
            lineLength += word.length();
        }
        wrappedLines.add(line.toString());
        return wrappedLines;
    }
}

