/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.cli;

import com.google.appengine.tools.util.Option;
import com.google.cloud.datastore.emulator.cli.EmulatorCli;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public abstract class EmulatorOption
extends Option {
    private final boolean isVisible;
    private final String placeholderValue;
    private final String description;

    public EmulatorOption(@Nullable String shortName, @Nullable String longName, boolean isFlag, boolean isVisible, @Nullable String placeholderValue, @Nullable String description) {
        super(shortName, longName, isFlag);
        Preconditions.checkArgument(isFlag || !isVisible || placeholderValue != null, "non-null placeholder value required");
        Preconditions.checkArgument(!isVisible || description != null, "non-null description required");
        this.isVisible = isVisible;
        this.placeholderValue = placeholderValue;
        this.description = description;
    }

    public float getValueAsFloat() {
        try {
            return Float.parseFloat(this.getValue());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Invalid float value for %s: %s.", this.getSpecifiedForm(false), this.getValue()), e);
        }
    }

    public boolean getValueAsBoolean() {
        if (this.getValue().equalsIgnoreCase("true")) {
            return true;
        }
        if (this.getValue().equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException(String.format("Invalid boolean value for %s: %s. Must be 'true' or 'false'.", this.getSpecifiedForm(false), this.getValue()));
    }

    public int getValueAsInt() {
        try {
            return Integer.parseInt(this.getValue());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Invalid int value for %s: %s.", this.getSpecifiedForm(false), this.getValue()), e);
        }
    }

    public String getShortForm(boolean includePlaceholder) {
        if (this.getShortName() == null) {
            return null;
        }
        StringBuilder form = new StringBuilder();
        form.append("-").append(this.getShortName());
        if (!this.isFlag() && includePlaceholder) {
            form.append(" ").append(this.placeholderValue);
        }
        return form.toString();
    }

    public String getLongForm(boolean includePlaceholder) {
        if (this.getLongName() == null) {
            return null;
        }
        StringBuilder form = new StringBuilder();
        form.append("--").append(this.getLongName());
        if (!this.isFlag() && includePlaceholder) {
            form.append("=").append(this.placeholderValue);
        }
        return form.toString();
    }

    public String getSpecifiedForm(boolean includePlaceholder) {
        if (this.getArgStyle() == Option.Style.Long) {
            return this.getLongForm(includePlaceholder);
        }
        return this.getShortForm(includePlaceholder);
    }

    @Override
    public List<String> getHelpLines() {
        if (!this.isVisible) {
            return super.getHelpLines();
        }
        String shortForm = this.getShortForm(true);
        String longForm = this.getLongForm(true);
        StringBuilder option = new StringBuilder();
        if (shortForm != null) {
            option.append(shortForm);
            if (longForm != null) {
                option.append(", ");
            }
        }
        if (longForm != null) {
            option.append(longForm);
        }
        ArrayList<String> lines = Lists.newArrayList();
        lines.add(option.toString());
        lines.addAll(EmulatorCli.wrap(this.description, 78, 2));
        return lines;
    }
}

