/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.io.Resources;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Parameters(separators="=")
public final class FirestoreEmulatorCliOptions {
    private static final String VERSION_STRING = "cloud-firestore-emulator 1.3.0";
    @Parameter(names={"--help"}, help=true, description="Print usage and exit")
    private boolean help = false;
    @Parameter(names={"--version"}, description="Print version and exit")
    private boolean version = false;
    @Parameter(names={"--licenses"}, description="Print open-source dependencies and licenses, then exit")
    private boolean licenses = false;
    @Parameter(names={"--host"}, description="The address to bind to on the local machine.")
    public List<String> hosts = Arrays.asList("[::1]", "127.0.0.1");
    @Parameter(names={"--port"}, description="The port number to listen to on the local machine.")
    public int port = 8080;
    @Parameter(names={"--rules"}, description="Cloud Firestore rules file")
    public String rulesFile = null;
    @Parameter(names={"--testing"}, hidden=true)
    private boolean testing = false;
    @Parameter(names={"--project_id"}, hidden=true)
    private String projectId = null;
    @Parameter(description="<ignored>")
    private List<String> arg = new ArrayList<String>();

    public static FirestoreEmulatorCliOptions parse(String[] args) throws IOException {
        FirestoreEmulatorCliOptions cli = new FirestoreEmulatorCliOptions();
        JCommander jc = new JCommander();
        jc.setProgramName("cloud-firestore-emulator");
        jc.addObject(cli);
        jc.parse(args);
        if (cli.help) {
            jc.usage();
            System.exit(0);
        }
        if (cli.version) {
            System.out.println(VERSION_STRING);
            System.exit(0);
        }
        if (cli.licenses) {
            System.out.println(Resources.toString(FirestoreEmulatorCliOptions.class.getResource("FIRESTORE_EMULATOR_LICENSES"), StandardCharsets.UTF_8));
            System.exit(0);
        }
        if (!cli.arg.isEmpty() && cli.arg.get(0).equals("create")) {
            System.exit(0);
        }
        return cli;
    }
}

