/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.firestore;

import com.google.cloud.datastore.core.common.DatastoreCoreConfig;
import com.google.cloud.datastore.emulator.cli.FirestoreEmulatorCliOptions;
import com.google.cloud.datastore.emulator.firestore.EmulatorAuxiliaryGrpcAdapter;
import com.google.cloud.datastore.emulator.firestore.FirestoreEmulator;
import com.google.cloud.datastore.emulator.firestore.FirestoreEmulatorMetadataKeys;
import com.google.cloud.datastore.emulator.firestore.FirestoreRuleCoverageHandler;
import com.google.cloud.datastore.emulator.firestore.v1.FirestoreV1GrpcAdapter;
import com.google.cloud.datastore.emulator.firestore.v1beta1.FirestoreV1Beta1GrpcAdapter;
import com.google.cloud.datastore.emulator.impl.FirestoreEmulatorConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.google.firebase.rules.v1.File;
import com.google.firebase.rules.v1.Source;
import com.google.firestore.emulator.v1.FirestoreEmulatorGrpc;
import com.google.firestore.emulator.v1.FirestoreEmulatorProto;
import com.google.firestore.v1.FirestoreGrpc;
import com.google.firestore.v1.FirestoreProto;
import com.google.firestore.v1beta1.FirestoreGrpc;
import com.google.protobuf.Descriptors;
import io.gapi.emulators.grpc.GrpcServer;
import io.gapi.emulators.grpc.HttpJsonAdapter;
import io.gapi.emulators.netty.OkHandler;
import io.gapi.emulators.netty.OptionsHandler;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.protobuf.services.ProtoReflectionService;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CloudFirestore {
    public static void main(String[] args) throws Exception {
        DatastoreCoreConfig.useJndexValue = true;
        FirestoreEmulatorCliOptions opts = FirestoreEmulatorCliOptions.parse(args);
        FirestoreEmulatorConfig.Builder config = FirestoreEmulatorConfig.builder();
        if (opts.rulesFile != null) {
            config.defaultRules(Source.newBuilder().addFiles(File.newBuilder().setContent(Files.asCharSource(new java.io.File(opts.rulesFile), StandardCharsets.UTF_8).read()).setName(opts.rulesFile).build()).build());
        }
        FirestoreEmulator firestore = FirestoreEmulator.fromConfig(config.build());
        ArrayList<GrpcServer> servers = new ArrayList<GrpcServer>();
        for (String host2 : opts.hosts) {
            GrpcServer server = CloudFirestore.buildGrpcServer(host2, opts.port, firestore);
            servers.add(server);
            server.start();
            System.out.printf("API endpoint: http://%s:%s\n", host2, opts.port);
        }
        String emulatorHosts = opts.hosts.stream().map(host -> String.format("%s:%s", host, opts.port)).collect(Collectors.joining(","));
        System.out.println("If you are using a library that supports the FIRESTORE_EMULATOR_HOST environment variable, run:");
        System.out.printf("\n   export FIRESTORE_EMULATOR_HOST=%s\n\n", emulatorHosts);
        System.out.println("Dev App Server is now running.\n");
        for (GrpcServer server : servers) {
            server.awaitTerminated();
        }
    }

    private static GrpcServer buildGrpcServer(String hostname, int port, FirestoreEmulator emulator) throws IOException {
        ServerServiceDefinition firestorev1 = ServerInterceptors.intercept(FirestoreV1GrpcAdapter.build(emulator), new FirebaseAuthInterceptor(), new FirebaseDatabaseRefInterceptor());
        ServerServiceDefinition firestorev1beta1 = ServerInterceptors.intercept(FirestoreV1Beta1GrpcAdapter.build(emulator), new FirebaseAuthInterceptor(), new FirebaseDatabaseRefInterceptor());
        ServerServiceDefinition emulatorv1 = ServerInterceptors.intercept(EmulatorAuxiliaryGrpcAdapter.build(emulator), new FirebaseAuthInterceptor(), new FirebaseDatabaseRefInterceptor());
        GrpcServer server = new GrpcServer(hostname, port, ImmutableList.of(firestorev1, firestorev1beta1, emulatorv1));
        ManagedChannel channel = NettyChannelBuilder.forAddress(hostname, port).usePlaintext().build();
        HttpJsonAdapter jsonAdapter = new HttpJsonAdapter();
        Descriptors.ServiceDescriptor firestorev1Descriptor = FirestoreProto.getDescriptor().findServiceByName("Firestore");
        FirestoreGrpc.FirestoreStub firestorev1Stub = FirestoreGrpc.newStub(channel);
        jsonAdapter.addService(firestorev1Descriptor, firestorev1Stub, Pattern.compile(".*Firestore.(Get|List)Documents?$"));
        Descriptors.ServiceDescriptor firestorev1beta1Descriptor = com.google.firestore.v1beta1.FirestoreProto.getDescriptor().findServiceByName("Firestore");
        FirestoreGrpc.FirestoreStub firestorev1beta1Stub = com.google.firestore.v1beta1.FirestoreGrpc.newStub(channel);
        jsonAdapter.addService(firestorev1beta1Descriptor, firestorev1beta1Stub, Pattern.compile(".*Firestore.(Get|List)Documents?$"));
        Descriptors.ServiceDescriptor firestoreEmulatorv1Descriptor = FirestoreEmulatorProto.getDescriptor().findServiceByName("FirestoreEmulator");
        FirestoreEmulatorGrpc.FirestoreEmulatorStub firestoreEmulatorv1Stub = FirestoreEmulatorGrpc.newStub(channel);
        jsonAdapter.addService(firestoreEmulatorv1Descriptor, firestoreEmulatorv1Stub, Pattern.compile(".*FirestoreEmulator.(ClearData|SetSecurityRules)?$"));
        server.addHttpHandler(jsonAdapter);
        server.addService(ProtoReflectionService.newInstance());
        server.addHttpHandler(new OkHandler("/"));
        server.addHttpHandler(FirestoreRuleCoverageHandler.create(firestoreEmulatorv1Stub));
        server.addHttpHandler(new OptionsHandler());
        return server;
    }

    private static final class FirebaseDatabaseRefInterceptor
    implements ServerInterceptor {
        private FirebaseDatabaseRefInterceptor() {
        }

        @Override
        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
            Context ctx = Context.current().withValue(FirestoreEmulatorMetadataKeys.DATABASE_REF.contextKey(), headers.get(FirestoreEmulatorMetadataKeys.DATABASE_REF.metadataKey()));
            return Contexts.interceptCall(ctx, call, headers, next);
        }
    }

    private static final class FirebaseAuthInterceptor
    implements ServerInterceptor {
        private FirebaseAuthInterceptor() {
        }

        @Override
        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
            Context ctx = Context.current().withValue(FirestoreEmulatorMetadataKeys.AUTHORIZATION.contextKey(), headers.get(FirestoreEmulatorMetadataKeys.AUTHORIZATION.metadataKey()));
            return Contexts.interceptCall(ctx, call, headers, next);
        }
    }
}

