/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.firestore;

import com.google.cloud.datastore.emulator.firestore.HttpHtmlAdapter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Resources;
import com.google.firestore.emulator.v1.FirestoreEmulatorGrpc;
import com.google.firestore.emulator.v1.FirestoreEmulatorProto;
import com.google.firestore.emulator.v1.RuleCoverageReport;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import io.gapi.emulators.grpc.JsonFormat;
import io.grpc.Status;
import io.grpc.StatusException;
import io.netty.channel.ChannelHandler;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;

@ChannelHandler.Sharable
public class FirestoreRuleCoverageHandler
extends HttpHtmlAdapter {
    private static final String RESOURCES_ROOT = "com/google/cloud/datastore/emulator/impl/rules/resources/";
    @VisibleForTesting
    static final Descriptors.ServiceDescriptor DESCRIPTOR = FirestoreEmulatorProto.getDescriptor().findServiceByName("FirestoreEmulator");
    @VisibleForTesting
    static final Pattern SERVICE_IGNORE_PATTERN = Pattern.compile(".*FirestoreEmulator(?!\\.GetRuleCoverage).*$");
    private final RuleCoverageReportPage reportTemplate;
    private final ErrorPage errorTemplate;

    public FirestoreRuleCoverageHandler(RuleCoverageReportPage reportTemplate, ErrorPage errorPage, FirestoreEmulatorGrpc.FirestoreEmulatorStub firestoreEmulatorv1Stub) {
        this.reportTemplate = reportTemplate;
        this.errorTemplate = errorPage;
        this.addService(DESCRIPTOR, firestoreEmulatorv1Stub, SERVICE_IGNORE_PATTERN);
    }

    public static FirestoreRuleCoverageHandler create(FirestoreEmulatorGrpc.FirestoreEmulatorStub firestoreEmulatorv1Stub) throws IOException {
        return new FirestoreRuleCoverageHandler(RuleCoverageReportPage.create(), ErrorPage.create(), firestoreEmulatorv1Stub);
    }

    @Override
    protected String generateHtml(Message message) throws StatusException {
        try {
            return this.reportTemplate.build((RuleCoverageReport)message);
        }
        catch (InvalidProtocolBufferException e) {
            throw Status.INTERNAL.withCause(e).asException();
        }
    }

    @Override
    protected String formatError(Status status) {
        return this.errorTemplate.build(status);
    }

    private static String loadFile(String fileName) throws IOException {
        String string = String.valueOf(RESOURCES_ROOT);
        String string2 = String.valueOf(fileName);
        return Resources.toString(Resources.getResource(string2.length() != 0 ? string.concat(string2) : new String(string)), StandardCharsets.UTF_8);
    }

    static class ErrorPage {
        private final String template;

        private ErrorPage(String template) {
            this.template = template;
        }

        public static ErrorPage create() throws IOException {
            return new ErrorPage(FirestoreRuleCoverageHandler.loadFile("error.html"));
        }

        public String build(Status status) {
            String errorCode = Integer.toString(FirestoreRuleCoverageHandler.toHttpCode(status.getCode()));
            String errorName = status.getCode().name();
            String errorMessage = status.getDescription() != null ? status.getDescription() : "No description provided";
            return this.template.replace("$ERROR_CODE$", errorCode).replace("$ERROR_NAME$", errorName).replace("$ERROR_MESSAGE$", errorMessage);
        }
    }

    static class RuleCoverageReportPage {
        private static final JsonFormat.Printer JSON_PRINTER = JsonFormat.printer().escapingHtml();
        private final String template;

        private RuleCoverageReportPage(String template) {
            this.template = template;
        }

        public static RuleCoverageReportPage create() throws IOException {
            return new RuleCoverageReportPage(FirestoreRuleCoverageHandler.loadFile("rulecoverage.html"));
        }

        public String build(RuleCoverageReport report) throws InvalidProtocolBufferException {
            String jsonData = JSON_PRINTER.print(report);
            return this.template.replace("$JSON_DATA$", jsonData);
        }
    }
}

