/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl;

import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.exception.DatastoreExceptionHelper;
import com.google.cloud.datastore.core.internal.Transactions;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.EntityTransformation;
import com.google.cloud.datastore.core.rep.Lookup;
import com.google.cloud.datastore.core.rep.Mutation;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.core.rep.ReadResult;
import com.google.cloud.datastore.core.rep.Write;
import com.google.cloud.datastore.emulator.impl.CloudFirestoreV1ListenStream;
import com.google.cloud.datastore.emulator.impl.CloudFirestoreV1WriteStream;
import com.google.cloud.datastore.emulator.impl.FirestoreEmulatorConfig;
import com.google.cloud.datastore.emulator.impl.context.EmulatorAuthorization;
import com.google.cloud.datastore.emulator.impl.context.FirestoreEmulatorRequestContext;
import com.google.cloud.datastore.emulator.impl.queries.FirestoreEmulatorQuerySemantics;
import com.google.cloud.datastore.emulator.impl.rules.EmulatorRulesAuthorizer;
import com.google.cloud.datastore.emulator.impl.storage.FirestoreEmulatorLookupHandler;
import com.google.cloud.datastore.emulator.impl.storage.FlatLocalEntityStore;
import com.google.cloud.datastore.emulator.impl.storage.LocalEntityStore;
import com.google.cloud.datastore.emulator.impl.transactions.TransactionGenerator;
import com.google.cloud.datastore.emulator.impl.util.EntityReadResult;
import com.google.cloud.datastore.emulator.impl.util.FirestoreEmulatorConverters;
import com.google.cloud.datastore.emulator.impl.watch.FirestoreSyncManager;
import com.google.cloud.datastore.emulator.impl.watch.ListenStreamManager;
import com.google.cloud.datastore.emulator.impl.watch.StreamId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.common.time.TimeSource;
import com.google.firestore.emulator.v1.ClearDataRequest;
import com.google.firestore.emulator.v1.GetRuleCoverageRequest;
import com.google.firestore.emulator.v1.RuleCoverageReport;
import com.google.firestore.emulator.v1.SetSecurityRulesRequest;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.BatchGetDocumentsResponse;
import com.google.firestore.v1.BeginTransactionRequest;
import com.google.firestore.v1.CommitRequest;
import com.google.firestore.v1.CommitResponse;
import com.google.firestore.v1.CreateDocumentRequest;
import com.google.firestore.v1.DeleteDocumentRequest;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.DocumentMask;
import com.google.firestore.v1.DocumentTransform;
import com.google.firestore.v1.GetDocumentRequest;
import com.google.firestore.v1.ListCollectionIdsRequest;
import com.google.firestore.v1.ListCollectionIdsResponse;
import com.google.firestore.v1.ListDocumentsRequest;
import com.google.firestore.v1.ListDocumentsResponse;
import com.google.firestore.v1.ListenRequest;
import com.google.firestore.v1.ListenResponse;
import com.google.firestore.v1.RollbackRequest;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.firestore.v1.UpdateDocumentRequest;
import com.google.firestore.v1.Value;
import com.google.firestore.v1.WriteRequest;
import com.google.firestore.v1.WriteResponse;
import com.google.firestore.v1.WriteResult;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.JavaTimeConversions;
import com.google.protobuf.util.Timestamps;
import com.google.storage.onestore.v3.OnestoreEntity;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class CloudFirestoreV1
implements FirestoreSyncManager {
    private static final Duration MAX_FUTURE_SNAPSHOT_READ_SKEW = Duration.ofMillis(50L);
    private final DatabaseRef databaseRef;
    private final TimeSource timeSource;
    private final Duration maxReadStaleness;
    private final LocalEntityStore localEntityStore;
    private final FirestoreEmulatorConverters converters;
    private final ListenStreamManager<ListenRequest> listenStreamManager;
    private final AtomicReference<EmulatorRulesAuthorizer> rulesAuthorizer;
    private final AtomicLong nextStreamId = new AtomicLong();
    private final TransactionGenerator transactionGenerator = new TransactionGenerator();

    public CloudFirestoreV1(FirestoreEmulatorConfig config, DatabaseRef databaseRef) throws DatastoreException {
        this.databaseRef = databaseRef;
        this.timeSource = config.timeSource();
        this.maxReadStaleness = Duration.ofMillis(config.datastoreConfig().getMaxReadStalenessMs());
        this.localEntityStore = new FlatLocalEntityStore(this.timeSource, Duration.ofMinutes(5L));
        this.converters = new FirestoreEmulatorConverters(Preconditions.checkNotNull(config).datastoreConfig());
        this.rulesAuthorizer = new AtomicReference<EmulatorRulesAuthorizer>(EmulatorRulesAuthorizer.fromSource(config.defaultRules(), this.converters));
        this.listenStreamManager = new ListenStreamManager(this, this.timeSource);
    }

    public Document getDocument(FirestoreEmulatorRequestContext context, GetDocumentRequest request) throws DatastoreException {
        Lookup lookup = this.converters.toLookup(request);
        ImmutableList<ReadResult> readResults = null;
        switch (request.getConsistencySelectorCase()) {
            case CONSISTENCYSELECTOR_NOT_SET: {
                readResults = this.snapshotLookup(context, lookup.keys(), lookup.propertyMask(), this.timeSource.now());
                break;
            }
            case TRANSACTION: {
                long existingTransaction = Transactions.getTransactionHandle(request.getTransaction());
                readResults = this.transactionalLookup(context, lookup.keys(), existingTransaction, lookup.propertyMask());
                break;
            }
            case READ_TIME: {
                readResults = this.snapshotLookup(context, lookup.keys(), lookup.propertyMask(), FirestoreEmulatorConverters.toInstant(lookup.readTimestamp()));
            }
        }
        ReadResult readResult = (ReadResult)Iterables.getOnlyElement(readResults);
        if (!readResult.exists()) {
            throw new DatastoreException(String.format("Document (%s) not found.", request.getName()), DatastoreV3Pb.Error.ErrorCode.NOT_FOUND, null);
        }
        return this.converters.toDocument(readResult);
    }

    public ListDocumentsResponse listDocuments(FirestoreEmulatorRequestContext context, ListDocumentsRequest request) throws DatastoreException {
        Query listDocumentsQuery = this.converters.toListDocumentsQuery(request);
        ImmutableList<ReadResult> documents = this.snapshotQuery(context, listDocumentsQuery, this.timeSource.now());
        ListDocumentsResponse.Builder builder = ListDocumentsResponse.newBuilder();
        documents.stream().map(this.converters::toDocument).forEach(builder::addDocuments);
        return builder.build();
    }

    public Document createDocument(FirestoreEmulatorRequestContext context, CreateDocumentRequest request) throws DatastoreException {
        EntityRef ref = this.converters.toEntityRef(request);
        EntityReadResult newlyCreatedRow = this.internalCommit(context, this.converters.toWrite(request), this.transactionGenerator.next()).get(ref);
        Document document = this.converters.toDocument(this.converters.rowToReadResult(newlyCreatedRow));
        return this.applyDocumentMask(document, request.hasMask() ? request.getMask() : null);
    }

    public Document updateDocument(FirestoreEmulatorRequestContext context, UpdateDocumentRequest request) throws DatastoreException {
        EntityRef ref = this.converters.toEntityRef(request.getDocument().getName());
        EntityReadResult newlyUpdatedRow = this.internalCommit(context, this.converters.toWrite(request), this.transactionGenerator.next()).get(ref);
        Document document = this.converters.toDocument(this.converters.rowToReadResult(newlyUpdatedRow));
        return this.applyDocumentMask(document, request.hasMask() ? request.getMask() : null);
    }

    public void deleteDocument(FirestoreEmulatorRequestContext context, DeleteDocumentRequest request) throws DatastoreException {
        this.internalCommit(context, this.converters.toWrite(request), this.transactionGenerator.next());
    }

    public ImmutableList<BatchGetDocumentsResponse> batchGetDocuments(FirestoreEmulatorRequestContext context, BatchGetDocumentsRequest request) throws DatastoreException {
        Lookup lookup = this.converters.toLookup(request);
        ArrayList<BatchGetDocumentsResponse> batchGetDocumentsResponses = new ArrayList<BatchGetDocumentsResponse>();
        ImmutableList<ReadResult> readResults = null;
        switch (request.getConsistencySelectorCase()) {
            case CONSISTENCYSELECTOR_NOT_SET: {
                long transientTransaction = this.transactionGenerator.next();
                readResults = this.transactionalLookup(context, lookup.keys(), transientTransaction, lookup.propertyMask());
                this.rollbackTransaction(transientTransaction);
                break;
            }
            case NEW_TRANSACTION: {
                long newTransaction = this.transactionGenerator.next();
                readResults = this.transactionalLookup(context, lookup.keys(), newTransaction, lookup.propertyMask());
                batchGetDocumentsResponses.add(BatchGetDocumentsResponse.newBuilder().setTransaction(this.converters.toTransactionBytes(newTransaction)).build());
                break;
            }
            case TRANSACTION: {
                long existingTransaction = Transactions.getTransactionHandle(request.getTransaction());
                readResults = this.transactionalLookup(context, lookup.keys(), existingTransaction, lookup.propertyMask());
                break;
            }
            case READ_TIME: {
                readResults = this.snapshotLookup(context, lookup.keys(), lookup.propertyMask(), FirestoreEmulatorConverters.toInstant(lookup.readTimestamp()));
            }
        }
        batchGetDocumentsResponses.addAll(readResults.stream().map(this.converters::toBatchGetDocumentResponse).collect(ImmutableList.toImmutableList()));
        return ImmutableList.copyOf(batchGetDocumentsResponses);
    }

    public ByteString beginTransaction(FirestoreEmulatorRequestContext context, BeginTransactionRequest ignored) {
        return this.converters.toTransactionBytes(this.transactionGenerator.next());
    }

    public CommitResponse commit(FirestoreEmulatorRequestContext context, CommitRequest request) throws DatastoreException {
        long txn = request.getTransaction().isEmpty() ? this.transactionGenerator.next() : Transactions.getTransactionHandle(request.getTransaction());
        Map<EntityRef, EntityReadResult> commitResponse = this.internalCommit(context, this.converters.toWrite(request, JavaTimeConversions.toProtoTimestamp(context.requestTime())), txn);
        Timestamp responseTime = JavaTimeConversions.toProtoTimestamp(commitResponse.values().stream().findAny().get().updatedAt());
        return CommitResponse.newBuilder().addAllWriteResults(request.getWritesList().stream().map(req -> WriteResult.newBuilder().setUpdateTime(responseTime).build()).collect(Collectors.toList())).setCommitTime(responseTime).build();
    }

    public void rollback(FirestoreEmulatorRequestContext context, RollbackRequest request) {
        throw new UnsupportedOperationException("unimplemented");
    }

    public ImmutableList<RunQueryResponse> runQuery(FirestoreEmulatorRequestContext context, RunQueryRequest request) throws DatastoreException {
        Query query = this.converters.toQuery(request, 0L);
        Instant readTime = null;
        switch (request.getConsistencySelectorCase()) {
            case NEW_TRANSACTION: 
            case TRANSACTION: {
                throw new UnsupportedOperationException("transactional queries not implemented");
            }
            case READ_TIME: {
                readTime = FirestoreEmulatorConverters.toInstant(Timestamps.toMicros(request.getReadTime()));
                break;
            }
            case CONSISTENCYSELECTOR_NOT_SET: {
                readTime = this.timeSource.now();
            }
        }
        ImmutableList<ReadResult> readResults = this.snapshotQuery(context, query, readTime);
        Timestamp timestamp = JavaTimeConversions.toProtoTimestamp(readTime);
        if (readResults.isEmpty()) {
            return ImmutableList.of(RunQueryResponse.newBuilder().setReadTime(timestamp).build());
        }
        return readResults.stream().map(readResult -> RunQueryResponse.newBuilder().setDocument(this.converters.toDocument((ReadResult)readResult)).setReadTime(timestamp).build()).collect(ImmutableList.toImmutableList());
    }

    public CloudFirestoreV1WriteStream writeStream(FirestoreEmulatorRequestContext context, StreamObserver<WriteResponse> responseObserver) {
        return CloudFirestoreV1WriteStream.create(this, this.timeSource, responseObserver, Long.toString(this.nextStreamId.getAndIncrement()), context);
    }

    public CloudFirestoreV1ListenStream listenStream(FirestoreEmulatorRequestContext context, StreamObserver<ListenResponse> responseObserver) {
        return CloudFirestoreV1ListenStream.create(context, StreamId.of(this.nextStreamId.getAndIncrement()), this.converters, this.listenStreamManager, responseObserver);
    }

    public ListCollectionIdsResponse listCollectionIds(FirestoreEmulatorRequestContext context, ListCollectionIdsRequest request) throws DatastoreException {
        ImmutableSet collectionIds;
        Preconditions.checkArgument(request.getPageSize() == 0 && request.getPageToken().isEmpty(), "emulator does not support paging in listCollectionIds yet");
        EntityRef parent = this.converters.parseParent(request.getParent());
        ListCollectionIdsResponse.Builder builder = ListCollectionIdsResponse.newBuilder();
        try (LocalEntityStore.ReadView readView = this.localEntityStore.snapshot(context.requestTime());){
            collectionIds = readView.all().keySet().stream().filter(ref -> ref.parent().equals(parent)).map(ref -> ref.collectionId()).collect(ImmutableSet.toImmutableSet());
        }
        collectionIds.stream().forEach(builder::addCollectionIds);
        return builder.build();
    }

    public void setSecurityRules(FirestoreEmulatorRequestContext context, SetSecurityRulesRequest request) throws DatastoreException {
        Preconditions.checkArgument(context.databaseRef().equals(this.databaseRef));
        this.rulesAuthorizer.set(EmulatorRulesAuthorizer.fromSource(request.getRules(), this.converters));
    }

    public void clearData(FirestoreEmulatorRequestContext context, ClearDataRequest request) throws DatastoreException {
        Set entitiesToDelete;
        Preconditions.checkArgument(context.databaseRef().equals(this.databaseRef));
        try (LocalEntityStore.ReadView readView = this.localEntityStore.snapshot(context.requestTime());){
            entitiesToDelete = readView.all().keySet();
        }
        ImmutableList<Mutation> mutations = entitiesToDelete.stream().map(ref -> Mutation.delete(FirestoreEmulatorConverters.toReference(ref)).build()).collect(ImmutableList.toImmutableList());
        Write write = Write.builder().mutations(mutations).build();
        FirestoreEmulatorRequestContext elevatedContext = context.toBuilder().auth(Optional.of(EmulatorAuthorization.ofAdmin(EmulatorAuthorization.AdminRole.OWNER))).build();
        this.internalCommit(elevatedContext, write, this.transactionGenerator.next());
    }

    public RuleCoverageReport ruleCoverageReport(FirestoreEmulatorRequestContext context, GetRuleCoverageRequest request) {
        return this.rulesAuthorizer.get().ruleCoverageReport();
    }

    public WriteResponse write(FirestoreEmulatorRequestContext context, WriteRequest request) throws DatastoreException {
        Timestamp requestTime = JavaTimeConversions.toProtoTimestamp(context.requestTime());
        Map<EntityRef, EntityReadResult> commitResponse = this.internalCommit(context, this.converters.toWrite(request, requestTime), this.transactionGenerator.next());
        Timestamp responseTime = JavaTimeConversions.toProtoTimestamp(commitResponse.values().stream().findAny().get().updatedAt());
        return WriteResponse.newBuilder().addAllWriteResults(request.getWritesList().stream().map(req -> {
            WriteResult.Builder result = WriteResult.newBuilder().setUpdateTime(responseTime);
            if (req.hasTransform()) {
                for (DocumentTransform.FieldTransform transform : req.getTransform().getFieldTransformsList()) {
                    switch (transform.getTransformTypeCase()) {
                        case SET_TO_SERVER_VALUE: {
                            result.addTransformResults(Value.newBuilder().setTimestampValue(requestTime));
                            break;
                        }
                    }
                }
            }
            return result.build();
        }).collect(Collectors.toList())).setCommitTime(responseTime).build();
    }

    private void rollbackTransaction(long transaction) {
        this.localEntityStore.commit(transaction, ImmutableMap.of());
    }

    private Map<EntityRef, EntityReadResult> internalCommit(FirestoreEmulatorRequestContext context, Write write, long transaction) throws DatastoreException {
        Preconditions.checkArgument(context.databaseRef().equals(this.databaseRef));
        ImmutableMap mutationsByRef = Maps.uniqueIndex(write.mutations(), m -> FirestoreEmulatorConverters.toEntityRef(m.key()));
        HashMap<EntityRef, Optional<Entity>> mutationResults = new HashMap<EntityRef, Optional<Entity>>();
        try (LocalEntityStore.ReadView readView = this.localEntityStore.read(transaction);){
            ImmutableMap<EntityRef, EntityReadResult> rows = readView.get(mutationsByRef.keySet());
            for (Map.Entry entry : rows.entrySet()) {
                EntityRef ref = (EntityRef)entry.getKey();
                EntityReadResult row = (EntityReadResult)entry.getValue();
                Mutation mutation = mutationsByRef.get(ref);
                FirestoreEmulatorConverters.checkMutation(mutation, row.entity().isPresent(), FirestoreEmulatorConverters.toMicroseconds(row.updatedAt()));
                mutationResults.put(ref, this.computeNewEntityViaSubMutations(row, mutation));
            }
            this.rulesAuthorizer.get().checkCommit(context, transaction, write, readView, mutationResults);
        }
        catch (Exception e) {
            this.rollbackTransaction(transaction);
            throw e;
        }
        ImmutableMap<EntityRef, EntityReadResult> results = this.localEntityStore.commit(transaction, mutationResults);
        this.listenStreamManager.notifyListeners(ImmutableMap.copyOf(Maps.transformValues(results, this.converters::rowToReadResult)));
        return results;
    }

    private ImmutableList<ReadResult> transactionalLookup(FirestoreEmulatorRequestContext context, List<OnestoreEntity.Reference> keys, long transaction, PropertyMask mask) throws DatastoreException {
        Preconditions.checkArgument(context.databaseRef().equals(this.databaseRef));
        try (LocalEntityStore.ReadView readView = this.localEntityStore.read(transaction);){
            FirestoreEmulatorLookupHandler handler = new FirestoreEmulatorLookupHandler(this.converters, readView);
            this.rulesAuthorizer.get().checkLookup(context, transaction, ImmutableSet.copyOf(keys), readView);
            ImmutableList<ReadResult> immutableList = handler.batchLookup(keys).stream().map(readResult -> readResult.exists() ? readResult.withMask(mask) : readResult).collect(ImmutableList.toImmutableList());
            return immutableList;
        }
    }

    private void checkValidReadTime(Instant readTime) throws DatastoreException {
        Instant now = this.timeSource.now();
        if (readTime.plus(this.maxReadStaleness).isBefore(now)) {
            throw DatastoreExceptionHelper.badRequest("The requested snapshot version is too old.", new Object[0]);
        }
        if (readTime.minus(MAX_FUTURE_SNAPSHOT_READ_SKEW).isAfter(now)) {
            throw DatastoreExceptionHelper.badRequest("The requested snapshot version is invalid.", new Object[0]);
        }
    }

    @Override
    public ImmutableList<ReadResult> snapshotLookup(FirestoreEmulatorRequestContext context, ImmutableList<OnestoreEntity.Reference> keys, PropertyMask mask, Instant readTime) throws DatastoreException {
        Preconditions.checkArgument(context.databaseRef().equals(this.databaseRef));
        this.checkValidReadTime(readTime);
        try (LocalEntityStore.ReadView readView = this.localEntityStore.snapshot(readTime);){
            FirestoreEmulatorLookupHandler handler = new FirestoreEmulatorLookupHandler(this.converters, readView);
            this.rulesAuthorizer.get().checkLookup(context, null, ImmutableSet.copyOf(keys), readView);
            ImmutableList<ReadResult> immutableList = handler.batchLookup(keys).stream().map(readResult -> readResult.exists() ? readResult.withMask(mask) : readResult).collect(ImmutableList.toImmutableList());
            return immutableList;
        }
    }

    @Override
    public ImmutableList<ReadResult> snapshotQuery(FirestoreEmulatorRequestContext context, Query query, Instant readTime) throws DatastoreException {
        ImmutableMap<EntityRef, EntityReadResult> rows;
        Preconditions.checkArgument(context.databaseRef().equals(this.databaseRef));
        this.checkValidReadTime(readTime);
        try (LocalEntityStore.ReadView readView = this.localEntityStore.snapshot(readTime);){
            this.rulesAuthorizer.get().checkQuery(context, query, readView);
            rows = readView.all();
        }
        ImmutableList<Entity> presentRows = rows.values().stream().flatMap(row -> Streams.stream(row.entity())).collect(ImmutableList.toImmutableList());
        return FirestoreEmulatorQuerySemantics.runQuery(presentRows, query).stream().map(entity -> this.converters.rowToReadResult(((EntityReadResult)rows.get(entity.ref())).masked(query.propertyMask()))).collect(ImmutableList.toImmutableList());
    }

    @VisibleForTesting
    ImmutableList<ReadResult> getAllEntities() {
        Instant now = this.timeSource.now();
        try (LocalEntityStore.ReadView readView = this.localEntityStore.snapshot(now);){
            ImmutableMap<EntityRef, EntityReadResult> rows = readView.all();
            ImmutableList<ReadResult> immutableList = rows.values().stream().filter(row -> row.entity().isPresent()).map(this.converters::rowToReadResult).collect(ImmutableList.toImmutableList());
            return immutableList;
        }
    }

    @VisibleForTesting
    ListenStreamManager<ListenRequest> getListenStreamManager() {
        return this.listenStreamManager;
    }

    @VisibleForTesting
    FirestoreEmulatorConverters getConverters() {
        return this.converters;
    }

    private Document applyDocumentMask(Document document, @Nullable DocumentMask mask) {
        if (mask == null) {
            return document;
        }
        HashMap<String, Value> map = Maps.newHashMap();
        HashSet<String> fields = Sets.newHashSet(mask.getFieldPathsList());
        for (Map.Entry<String, Value> e : document.getFieldsMap().entrySet()) {
            if (!fields.contains(e.getKey())) continue;
            map.put(e.getKey(), e.getValue());
        }
        return document.toBuilder().clearFields().putAllFields(map).build();
    }

    private Optional<Entity> computeNewEntityViaSubMutations(EntityReadResult row, Mutation m) {
        OnestoreEntity.EntityProto currentEntity = row.entity().map(this.converters::entityToProto).orElse(null);
        for (Mutation subMutation : m.subMutations()) {
            if (subMutation.isDelete()) {
                currentEntity = null;
                continue;
            }
            PropertyMask writeMask = subMutation.writePropertyMask();
            currentEntity = currentEntity == null ? writeMask.mask(subMutation.entity()) : writeMask.maskInto(subMutation.entity(), currentEntity);
            if (subMutation.transformation() == null) continue;
            currentEntity = this.transformEntity(subMutation.transformation(), currentEntity);
        }
        return Optional.ofNullable(currentEntity).map(this.converters::protoToEntity);
    }

    private OnestoreEntity.EntityProto transformEntity(EntityTransformation transformation, OnestoreEntity.EntityProto entityProto) {
        Entity entity = this.converters.protoToEntity(entityProto);
        EntityTransformation.TransformationResult result = transformation.transform(entity);
        return this.converters.entityToProto(result.transformedEntity());
    }
}

