/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl;

import com.google.apphosting.datastore.shared.Config;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.emulator.impl.AutoValue_FirestoreEmulatorConfig;
import com.google.common.time.TimeSource;
import com.google.firebase.rules.v1.File;
import com.google.firebase.rules.v1.Source;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@AutoValue
public abstract class FirestoreEmulatorConfig {
    private static final Source OPEN_RULES = Source.newBuilder().addFiles(File.newBuilder().setName("OPEN_RULES").setContent(Stream.of("service cloud.firestore {", "  match /databases/{database}/documents {", "    match /{document=**} {", "      allow read, write: if true;", "    }", "  }", "}").collect(Collectors.joining("\n")))).build();

    public abstract Source defaultRules();

    public abstract TimeSource timeSource();

    public abstract Config.DatastoreConfig datastoreConfig();

    public static Builder builder() {
        return new AutoValue_FirestoreEmulatorConfig.Builder().defaultRules(OPEN_RULES).timeSource(new MillisecondResolutionTimeSource(TimeSource.system())).datastoreConfig(Config.DatastoreConfig.getDefaultInstance());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder defaultRules(Source var1);

        public abstract Builder timeSource(TimeSource var1);

        public abstract Builder datastoreConfig(Config.DatastoreConfig var1);

        public abstract FirestoreEmulatorConfig build();
    }

    private static final class MillisecondResolutionTimeSource
    implements TimeSource {
        private final TimeSource underlying;

        private MillisecondResolutionTimeSource(TimeSource underlying) {
            this.underlying = underlying;
        }

        @Override
        public Instant now() {
            return this.underlying.now().truncatedTo(ChronoUnit.MILLIS);
        }
    }
}

