/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.context;

import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.emulator.impl.context.EmulatorAuthorization;
import com.google.cloud.datastore.emulator.impl.context.FirestoreEmulatorRequestContext;
import java.time.Instant;
import java.util.Optional;

final class AutoValue_FirestoreEmulatorRequestContext
extends FirestoreEmulatorRequestContext {
    private final DatabaseRef databaseRef;
    private final Instant requestTime;
    private final Optional<EmulatorAuthorization> auth;

    private AutoValue_FirestoreEmulatorRequestContext(DatabaseRef databaseRef, Instant requestTime, Optional<EmulatorAuthorization> auth) {
        this.databaseRef = databaseRef;
        this.requestTime = requestTime;
        this.auth = auth;
    }

    @Override
    public DatabaseRef databaseRef() {
        return this.databaseRef;
    }

    @Override
    public Instant requestTime() {
        return this.requestTime;
    }

    @Override
    public Optional<EmulatorAuthorization> auth() {
        return this.auth;
    }

    public String toString() {
        String string = String.valueOf(this.databaseRef);
        String string2 = String.valueOf(this.requestTime);
        String string3 = String.valueOf(this.auth);
        return new StringBuilder(66 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("FirestoreEmulatorRequestContext{databaseRef=").append(string).append(", requestTime=").append(string2).append(", auth=").append(string3).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FirestoreEmulatorRequestContext) {
            FirestoreEmulatorRequestContext that = (FirestoreEmulatorRequestContext)o;
            return this.databaseRef.equals(that.databaseRef()) && this.requestTime.equals(that.requestTime()) && this.auth.equals(that.auth());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.databaseRef.hashCode();
        h$ *= 1000003;
        h$ ^= this.requestTime.hashCode();
        h$ *= 1000003;
        return h$ ^= this.auth.hashCode();
    }

    @Override
    public FirestoreEmulatorRequestContext.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends FirestoreEmulatorRequestContext.Builder {
        private DatabaseRef databaseRef;
        private Instant requestTime;
        private Optional<EmulatorAuthorization> auth = Optional.empty();

        Builder() {
        }

        private Builder(FirestoreEmulatorRequestContext source) {
            this.databaseRef = source.databaseRef();
            this.requestTime = source.requestTime();
            this.auth = source.auth();
        }

        @Override
        public FirestoreEmulatorRequestContext.Builder databaseRef(DatabaseRef databaseRef) {
            if (databaseRef == null) {
                throw new NullPointerException("Null databaseRef");
            }
            this.databaseRef = databaseRef;
            return this;
        }

        @Override
        public FirestoreEmulatorRequestContext.Builder requestTime(Instant requestTime) {
            if (requestTime == null) {
                throw new NullPointerException("Null requestTime");
            }
            this.requestTime = requestTime;
            return this;
        }

        @Override
        public FirestoreEmulatorRequestContext.Builder auth(Optional<EmulatorAuthorization> auth) {
            if (auth == null) {
                throw new NullPointerException("Null auth");
            }
            this.auth = auth;
            return this;
        }

        @Override
        public FirestoreEmulatorRequestContext build() {
            String missing = "";
            if (this.databaseRef == null) {
                missing = String.valueOf(missing).concat(" databaseRef");
            }
            if (this.requestTime == null) {
                missing = String.valueOf(missing).concat(" requestTime");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_FirestoreEmulatorRequestContext(this.databaseRef, this.requestTime, this.auth);
        }
    }
}

