/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.context;

import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.auto.value.AutoOneOf;
import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.emulator.impl.context.AutoOneOf_EmulatorAuthorization;
import com.google.common.base.Preconditions;
import com.google.firebase.firebear.client.JsonHelper;
import com.google.firebase.firebear.client.JwtToken;
import com.google.firebase.firebear.client.JwtVerificationException;
import java.util.Optional;
import javax.annotation.Nullable;

@AutoOneOf(value=Kind.class)
public abstract class EmulatorAuthorization {
    private static final String HEADER_PREFIX = "Bearer ";

    public abstract Kind kind();

    public abstract JwtToken jwt();

    public abstract AdminRole admin();

    private static EmulatorAuthorization ofJwt(JwtToken token) {
        return AutoOneOf_EmulatorAuthorization.jwt(token);
    }

    public static EmulatorAuthorization ofAdmin(AdminRole role) {
        return AutoOneOf_EmulatorAuthorization.admin(role);
    }

    public static Optional<EmulatorAuthorization> fromHeader(@Nullable String header) throws DatastoreException {
        if (header == null) {
            return Optional.empty();
        }
        Preconditions.checkArgument(header.toLowerCase().startsWith(HEADER_PREFIX.toLowerCase()));
        String serializedToken = header.substring(HEADER_PREFIX.length());
        try {
            return Optional.of(EmulatorAuthorization.ofAdmin(AdminRole.valueOf(serializedToken.toUpperCase())));
        }
        catch (IllegalArgumentException badEnum) {
            try {
                JwtToken token = JwtToken.deserialize(serializedToken);
                EmulatorAuthorization.validateUnsecuredJwt(token);
                return Optional.of(EmulatorAuthorization.ofJwt(token));
            }
            catch (JwtVerificationException e) {
                throw DatastoreException.builder().cause(e).errorCode(DatastoreV3Pb.Error.ErrorCode.BAD_REQUEST).message("invalid jwt").build();
            }
        }
    }

    private static void validateUnsecuredJwt(JwtToken token) {
        String alg = JsonHelper.forObject(token.getHeader()).getParamAsString("alg");
        Preconditions.checkArgument(alg != null && alg.equals("none"), "expected JWT alg to be 'none' but got '%s'", (Object)alg);
        Preconditions.checkArgument(token.getSignature().length == 0, "expected empty JWT signature");
    }

    public static enum AdminRole {
        OWNER;

    }

    public static enum Kind {
        JWT,
        ADMIN;

    }
}

