/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.queries;

import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.IndexDef;
import com.google.cloud.datastore.emulator.impl.queries.FirestoreEmulatorQueryPlanner;
import com.google.cloud.datastore.emulator.impl.queries.IndexEntry;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.NavigableSet;
import java.util.Optional;

public final class FirestoreEmulatorQueryExecutor {
    private FirestoreEmulatorQueryExecutor() {
    }

    static ImmutableList<EntityRef> scanIndex(NavigableSet<IndexEntry> indexTable, FirestoreEmulatorQueryPlanner.IndexEntryRange range, int offset, Optional<Integer> limit) {
        return indexTable.subSet(range.lo().value(), range.lo().before(), range.hi().value(), !range.hi().before()).stream().map(IndexEntry::entityRef).skip(offset).limit(limit.orElseGet(indexTable::size).intValue()).collect(ImmutableList.toImmutableList());
    }

    static NavigableSet<IndexEntry> materializeIndexTable(List<Entity> entities, IndexDef indexDef, EntityRef parent) {
        return entities.stream().filter(e -> indexDef.appliesToKind(e.ref().collectionId())).filter(e -> FirestoreEmulatorQueryExecutor.matchesIndexAncestor(indexDef.indexAncestor(), e.ref(), parent)).flatMap(e -> IndexEntry.createForIndex(e, indexDef)).collect(ImmutableSortedSet.toImmutableSortedSet(IndexEntry.Comparator.fromIndexDef(indexDef)));
    }

    static ImmutableList<Entity> lookupEntities(ImmutableList<EntityRef> entityKeys, ImmutableList<Entity> entities) {
        ImmutableMap refToEntity = Maps.uniqueIndex(entities, Entity::ref);
        return entityKeys.stream().map(refToEntity::get).collect(ImmutableList.toImmutableList());
    }

    private static boolean matchesIndexAncestor(IndexDef.IndexAncestor indexAncestor, EntityRef ref, EntityRef target) {
        switch (indexAncestor) {
            case ANCESTOR: {
                return FirestoreEmulatorQueryExecutor.hasAncestor(ref, target);
            }
            case PARENT: {
                return target.equals(ref.parent());
            }
            case NONE: {
                throw new UnsupportedOperationException("IndexAncestor should always be ANCESTOR or PARENT");
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    private static boolean hasAncestor(EntityRef ref, EntityRef target) {
        do {
            if (!(ref = ref.parent()).equals(target)) continue;
            return true;
        } while (!ref.path().isEmpty());
        return false;
    }
}

