/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.emulator.impl.queries;

import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.emulator.impl.queries.FirestoreEmulatorQueryExecutor;
import com.google.cloud.datastore.emulator.impl.queries.FirestoreEmulatorQueryPlanner;
import com.google.cloud.datastore.emulator.impl.queries.IndexEntry;
import com.google.common.collect.ImmutableList;
import java.util.NavigableSet;
import java.util.Optional;

public final class FirestoreEmulatorQuerySemantics {
    private FirestoreEmulatorQuerySemantics() {
    }

    public static ImmutableList<Entity> runQuery(ImmutableList<Entity> entities, Query query) {
        FirestoreEmulatorQueryPlanner.validate(query);
        Query normalized = FirestoreEmulatorQueryPlanner.normalize(query);
        EntityRef parent = Optional.ofNullable(normalized.ancestor()).orElseGet(() -> EntityRef.create(normalized.scope().partition(), new EntityRef.PathElement[0]));
        FirestoreEmulatorQueryPlanner.PerfectIndexScan perfectIndexScan = FirestoreEmulatorQueryPlanner.planQuery(normalized);
        if (!perfectIndexScan.range().isPresent()) {
            return ImmutableList.of();
        }
        NavigableSet<IndexEntry> indexTable = FirestoreEmulatorQueryExecutor.materializeIndexTable(entities, perfectIndexScan.index(), parent);
        ImmutableList<EntityRef> entityKeys = FirestoreEmulatorQueryExecutor.scanIndex(indexTable, perfectIndexScan.range().get(), normalized.offset(), Optional.ofNullable(normalized.limit()));
        return FirestoreEmulatorQueryExecutor.lookupEntities(entityKeys, entities);
    }
}

